// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive     PIGrCoord
// Classe de gestion de coordonnees grpahique   R. Ansari  97
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PIGRCOORD_H_SEEN
#define PIGRCOORD_H_SEEN

#include "pisysdep.h"


//  Classe pour gerer indifferement des coordonnees double ou int 
class PIGrCoord {
public:
  inline PIGrCoord() { iv = 0; dv = 0.;}
  inline PIGrCoord(int a) { iv = a; dv = (double)a;}
  inline PIGrCoord(float a) { iv = (a>=0.)?(int)(a+0.5):(int)(a-0.5); dv = (double)a;}
  inline PIGrCoord(double a) { iv = (a>=0.)?(int)(a+0.5):(int)(a-0.5); dv = a;}
  inline PIGrCoord(PIGrCoord const & gc) { iv = gc.iv;  dv = gc.dv; }
  explicit PIGrCoord(const char * sv);

  inline operator int() { return(iv); }
  inline operator short() { return((short)iv); }
  inline operator unsigned int() { return((unsigned int)iv); }
  inline operator unsigned short() { return((unsigned short)iv); }
  inline operator float() { return((float)dv); }
  inline operator double() { return(dv); }
  inline PIGrCoord& operator= (int a) { iv = a; dv = (double)a; return(*this); }
  inline PIGrCoord& operator= (float a) 
        { iv = (a>=0.)?(int)(a+0.5):(int)(a-0.5); dv = (double)a; return(*this); }
  inline PIGrCoord& operator= (double a) 
        { iv = (a>=0.)?(int)(a+0.5):(int)(a-0.5); dv = a; return(*this); }
  inline PIGrCoord& operator= (PIGrCoord const & gc) { iv = gc.iv; dv = gc.dv;  return(*this); }
protected:
  int iv;
  double dv;
};


#endif      // PIGRCOORD_H_SEEN
