// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive     PILineAtt 
// Gestionnaire d'attributs de ligne   R. Ansari  2002
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PILINEATT_H_SEEN
#define PILINEATT_H_SEEN

#include "pisysdep.h"


// Line drawing attributes
enum PILineJoin { PI_JoinMiter=0, PI_JoinRound=1, PI_JoinBevel=2};
enum PILineCap  { PI_CapButt=0, PI_CapRound=1, PI_CapProjecting=2};
enum PILineDash { PI_LineSolid, PI_LineDashed, PI_LineDotted, 
		  PI_LineDashDotted};
// Predefined line types
enum PILineTypes { PI_NotDefLineAtt,
		   PI_NormalLine, PI_ThinLine, PI_ThickLine,
		   PI_DashedLine, PI_ThinDashedLine, PI_ThickDashedLine,
		   PI_DottedLine, PI_ThinDottedLine, PI_ThickDottedLine,
                   PI_DashDottedLine, PI_ThinDashDottedLine, PI_ThickDashDottedLine};


// Classe pour gerer les attributs de lignes
class PILineAtt {
public:
  explicit inline PILineAtt(int width=1, PILineDash dash=PI_LineSolid, 
			    PILineJoin join=PI_JoinMiter, PILineCap cap=PI_CapButt)
  {_lwidth = (width>0)?width*8:8; _ldash=dash; _ljoincap=join+cap*256; }
  explicit inline PILineAtt(double width, PILineDash dash=PI_LineSolid, 
			    PILineJoin join=PI_JoinMiter, PILineCap cap=PI_CapButt)
  { _lwidth = (width>0)?(unsigned short)(width*8.):8; _ldash=dash; _ljoincap=join+cap*256; } 
  inline PILineAtt(PILineAtt const& b)
  { _lwidth=b._lwidth; _ldash=b._ldash; _ljoincap=b._ljoincap; }
 
  PILineAtt(PILineTypes ltyp);

  inline ~PILineAtt() {}

  inline PILineAtt& operator = (PILineAtt const& b)
  { _lwidth=b._lwidth; _ldash=b._ldash; _ljoincap=b._ljoincap; return(*this); }  
  inline PILineAtt& operator = (PILineTypes ltyp)
  { *this=PILineAtt(ltyp);  return(*this); }
   
  inline bool operator == (PILineAtt const& b) const
  { return ((_lwidth==b._lwidth)&&(_ldash==b._ldash)&&(_ljoincap==b._ljoincap)); }
  inline bool operator == (PILineTypes ltyp) const
  { return ((*this) == PILineAtt(ltyp)); }
  inline bool operator != (PILineAtt const& b) const
  { return ((_lwidth!=b._lwidth)||(_ldash!=b._ldash)||(_ljoincap!=b._ljoincap)); }
  inline bool operator != (PILineTypes ltyp) const
  { return ((*this) != PILineAtt(ltyp)); }

  inline int GetLineWidth() const { return ((_lwidth>0)?_lwidth/8:1); }
  inline int GetLineWidthx8() const { return (_lwidth); }
  inline double GetLineWidthD() const { return ((_lwidth>0)?(double)_lwidth/8.:1.); }
  inline PILineDash GetLineDash() const { return _ldash; }
  inline PILineJoin GetLineJoin() const { return (PILineJoin)(_ljoincap%256); }
  inline PILineCap  GetLineCap() const { return (PILineCap)(_ljoincap/256); }

  inline void SetLineWidth(int lw) { _lwidth = lw*8; }
  inline void SetLineWidth(double lw) { _lwidth = (unsigned short)(lw*8.); }
  inline void SetLineDash(PILineDash ld)  { _ldash = ld; }
  inline void SetLineJoin(PILineJoin lj)  { _ljoincap = lj+(_ljoincap&0xFF00); }
  inline void SetLineCap(PILineCap lc)  { _ljoincap = lc*256+(_ljoincap&0x00FF); }

protected:
  unsigned short _lwidth;  // en 1/8 de pixels (ou points)
  unsigned short _ljoincap;
  PILineDash _ldash;  
};

#endif      // PILINEATT_H_SEEN
