// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive     PIGrCoord
// Classe de gestion de coordonnees grpahique   R. Ansari  97
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include "pigrcoord.h"
#include <stdlib.h>
#include <stdio.h>
#include <math.h>


//++
// Class	PIGrCoord
// Lib		PI
// include	pigrcoord.h
//
//   	Classe utilis pour la spcifiaction de coordonnes graphique.
//	Des constructeurs et des mthodes de conversion  partir 
//	et vers des "int", "float" et "double" sont dfinis.
//	La valeur entiere d'un objet PIGrCoord construite  partir 
//	d'une valeur flottante (ou suite  une affectation) correpond
//	 l'entier le plus proche.
// 
//|	PIGrCoord gco = 3.14;
//|	int ic = gco;     // ic -> 3
//|	float fc = gco;   // fc -> 3.14
//|	gco = 1.1;        // (int)gco -> 1
//|	gco = 1.6;        // (int)gco -> 2
//|	gco = -0.4;       // (int)gco -> 0
//|	gco = -0.7;       // (int)gco -> -1
//--
//++
// Links	Voir aussi
// PIGraphic
// PIGraphicAtt
//--

PIGrCoord::PIGrCoord(const char * sv)
{
  double a = atof(sv);
  iv = (a>=0.)?(int)(a+0.5):(int)(a-0.5); dv = a;
}

//++
// Titre	Constructeurs
//--
//++
// 
// PIGrCoord() 
//	Constructeur par dfaut ("intVal=floatVal=0")
// PIGrCoord(int a)
//	Constructeur  partir de l'entier "a"
// PIGrCoord(float a) 
//	Constructeur  partir de la valeur flottante "a"
// PIGrCoord(double a) 
//	Constructeur  partir de la valeur flottante double prcision "a"
// PIGrCoord(const char * sv) 
//	Constructeur  partir d'une chaine de caracteres "sv".
//--
//++
// Titre	Oprateurs de conversion
//--
//++
// operator int() 
//	Conversion en entier "int"
// operator short() 
//	Conversion en entier "short"
// operator unsigned int() 
//	Conversion en entier non sign "unsigned int"
// operator unsigned short() 
//	Conversion en entier non sign "unsigned short"
// operator float() 
//	Conversion en rl "float"
// operator double() 
//	Conversion en rl "double"
//--
//++
// Titre	Oprateurs d'affectation
//--
//++
// PIGrCoord& operator= (int a) 
//	Affectation  partir de valeur entire "int"
// PIGrCoord& operator= (float a) 
//	Affectation  partir de valeur rlle "float"
// PIGrCoord& operator= (double a) 
//	Affectation  partir de valeur rlle double prcision "double"
//--

