// Module PI : Peida Interactive     PIElDrawer
//	      E. Aubourg , R.Ansari     96-02
// (C) LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include "machdefs.h"
#include <strings.h>
#include <iostream.h>

#include "pieldrw.h"

#include <math.h>

/*  --------------------------------------------------------------  */
/*  ------------------- Classe PIElDrwMgr ------------------------  */
/*  --------------------------------------------------------------  */

//++
// Class	PIElDrwMgr
// Lib		PI
// include	pieldrw.h
//
//	Classe gestionnaire de trac d'lments. Utilis par "PIElDrawer".
//--
//++
// Links	Voir aussi
// PIElDrawer
//--
//++
// Titre	Constructeurs et mthodes
//--

/* --Methode-- */
//++
PIElDrwMgr::PIElDrwMgr()
//	Constructeur
//--
{
  mEn = 0;
}

/* --Methode-- */
//++
PIElDrwMgr::~PIElDrwMgr()
//	destructeur
//--
{
  ElDelAll();
}
/* --Methode-- */
//++
void PIElDrwMgr::DrawElements(PIGraphicUC* g, double xmin, double ymin, double xmax, double ymax)
//	Trac des lments
//--
{
  DrwElList::iterator it;
  g->SaveGraphicAtt();
  for (it = mElist.begin(); it != mElist.end(); it++)
    {
      PIColors fcol = (*it).gatt.GetFgColor(); 
      if (fcol != PI_NotDefColor)    g->SelForeground(fcol);
      PIColors bcol = (*it).gatt.GetBgColor(); 
      if (bcol != PI_NotDefColor)    g->SelBackground(bcol);
      if ((*it).gatt.GetLineAtt() != PI_NotDefLineAtt)  
	g->SelLine((*it).gatt.GetLineAtt());
      if ( ((*it).gatt.GetFontName() != PI_DefaultFont) ||
	   ((*it).gatt.GetFontAtt() != PI_NotDefFontAtt) )
	g->SelFont((*it).gatt.GetFont());
      if ((*it).gatt.GetMarker() != PI_NotDefMarker) 
	g->SelMarker((*it).gatt.GetMarkerSize(), (*it).gatt.GetMarker());
      if ((*it).gatt.GetArrowMarker() !=  PI_NotDefArrowMarker) 
	g->SelArrowMarker((*it).gatt.GetArrowMarkerSize(), 
			  (*it).gatt.GetArrowMarker());

      switch ( (*it).etyp )
	{
	case PIDEL_Line :
	  g->DrawLine((*it).ex, (*it).ey, (*it).edx, (*it).edy ); 
	  break;
	case PIDEL_Mark :
	  g->DrawMarker((*it).ex, (*it).ey); 
	  break;
	case PIDEL_Arrow :
	  g->DrawArrowMarker((*it).ex, (*it).ey, (*it).edx, (*it).edy, true); 
	  break;
	case PIDEL_Text :
	  g->DrawString((*it).ex, (*it).ey, (char*) ((*it).es.c_str()) ); 
	  break;
	case PIDEL_Rect :
	  g->DrawBox((*it).ex, (*it).ey, (*it).edx, (*it).edy ); 
	  break;
	case PIDEL_FRect :
	  g->DrawFBox((*it).ex, (*it).ey, (*it).edx, (*it).edy ); 
	  break;
	case PIDEL_Circ :
	  g->DrawCircle((*it).ex, (*it).ey, (*it).edx ); 
	  break;
	case PIDEL_FCirc :
	  g->DrawFCircle((*it).ex, (*it).ey, (*it).edx ); 
	  break;
	case PIDEL_Poly :
	  g->DrawPolygon((*it).xpol, (*it).ypol, (*it).npol, false ); 
	  break;
	case PIDEL_FPoly :
	  g->DrawFPolygon((*it).xpol, (*it).ypol, (*it).npol, false ); 
	  break;
	default :
	  break;
	}
      g->RestoreGraphicAtt();
    }
}

//++
// int  ElAddText(PIGrCoord x, PIGrCoord y, const char* s)
// int  ElAddText(PIGrCoord x, PIGrCoord y, const char* s, PIGraphicAtt gatt)
// int  ElAddText(PIGrCoord x, PIGrCoord y, string const & s)
// int  ElAddText(PIGrCoord x, PIGrCoord y, string const &  s, PIGraphicAtt gatt)
//	Ajout d'un lment texte (possibilit de spcification d'un attribut graphique).
//	Renvoie le numro identificateur de l'lment.
// 
// int  ElAddLine(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2)
// int  ElAddLine(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2, PIGraphicAtt gatt)
//	Ajout d'un lment de ligne (possibilit de spcification d'un attribut graphique).
//	Renvoie le numro identificateur de l'lment.
//	
// int  ElAddRect(PIGrCoord x, PIGrCoord y, PIGrCoord dx, PIGrCoord dy)
// int  ElAddRect(PIGrCoord x, PIGrCoord y, PIGrCoord dx, PIGrCoord dy, PIGraphicAtt gatt)
//	Ajout d'un lment de type rectangle (possibilit de spcification d'un attribut graphique).
//	Renvoie le numro identificateur de l'lment.
//
// int  ElAddFRect(PIGrCoord x, PIGrCoord y, PIGrCoord dx, PIGrCoord dy)
// int  ElAddFRect(PIGrCoord x, PIGrCoord y, PIGrCoord dx, PIGrCoord dy,  PIGraphicAtt gatt)
//	Ajout d'un lment de type rectangle plein 
//	(possibilit de spcification d'un attribut graphique).
//	Renvoie le numro identificateur de l'lment.
//
// int  ElAddCirc(PIGrCoord x, PIGrCoord y, PIGrCoord r)
// int  ElAddCirc(PIGrCoord x, PIGrCoord y, PIGrCoord r, PIGraphicAtt gatt)
//	Ajout d'un lment de type cercle (possibilit de spcification d'un attribut graphique).
//	Renvoie le numro identificateur de l'lment.
//
// int  ElAddFCirc(PIGrCoord x, PIGrCoord y, PIGrCoord r)
// int  ElAddFCirc(PIGrCoord x, PIGrCoord y, PIGrCoord r, PIGraphicAtt gatt)
//	Ajout d'un lment de type cercle plein avec un attribut de couleur.
//	Renvoie le numro identificateur de l'lment.
//
// int  ElAddPoly(vector<PIGrCoord>& x, vector<PIGrCoord>& y)
// int  ElAddPoly(vector<PIGrCoord>& x, vector<PIGrCoord>& y, PIGraphicAtt gatt)
//	Ajout d'un lment de type polygone (possibilit de spcification d'un attribut graphique).
//	Renvoie le numro identificateur de l'lment.
//
// int  ElAddFPoly(vector<PIGrCoord>& x, vector<PIGrCoord>& y)
// int  ElAddFPoly(vector<PIGrCoord>& x, vector<PIGrCoord>& y, PIGraphicAtt gatt)
//	Ajout d'un lment de type polygone plein 
//	(possibilit de spcification d'un attribut graphique).
//	Renvoie le numro identificateur de l'lment.
// 
// void  ElDel(int id)
//	Suppression de l'lment avec l'identificateur "id".
// void  ElDelAll()
//	Suppression de tous les lments de l'objet.
//--

/* --Methode-- */
int PIElDrwMgr::ElAdd(int typ, PIGrCoord x, PIGrCoord  y, PIGrCoord dx, PIGrCoord dy, 
		      const char* s, PIGraphicAtt const& att)
{
  DrwEl dre;
  mEn++;
  dre.eid = mEn;  dre.etyp = typ;
  dre.ex = x;   dre.ey = y;
  dre.edx = dx;  dre.edy = dy;
  dre.gatt = att;
  if (s)  dre.es = s;
  dre.xpol = dre.ypol = NULL;
  dre.npol = 0;
  mElist.push_back(dre);
  return(mEn);
}

/* --Methode-- */
int PIElDrwMgr::ElAdd(int typ, vector<PIGrCoord>& x, vector<PIGrCoord>& y, PIGraphicAtt const& att)
{
  DrwEl dre;
  mEn++;
  dre.eid = mEn;  dre.etyp = typ;
  dre.ex = dre.ey = 0;
  dre.edx = dre.edy = 0;
  dre.gatt = att;
  dre.xpol = dre.ypol = NULL;
  dre.npol = (y.size() < x.size()) ? y.size() : x.size();
  if (dre.npol > 0) {
    dre.xpol = new PIGrCoord[dre.npol];
    dre.ypol = new PIGrCoord[dre.npol];
    for(int kk=0; kk<dre.npol; kk++) {
      dre.xpol[kk] = x[kk];
      dre.ypol[kk] = y[kk];
    }
  }
  mElist.push_back(dre);
  return(mEn);
}

/* --Methode-- */
void  PIElDrwMgr::ElDel(int id)
{
  DrwElList::iterator it;
  for (it = mElist.begin(); it != mElist.end(); it++) {
    if ( (*it).eid == id) { 
      if ( (*it).xpol ) delete[] (*it).xpol;
      if ( (*it).ypol ) delete[] (*it).ypol;
      mElist.erase(it);   
      break; 
    }
  }
  return;
}

/* --Methode-- */
void  PIElDrwMgr::ElDelAll()
{
  DrwElList::iterator it;
  for (it = mElist.begin(); it != mElist.end(); it++) {
    if ( (*it).xpol ) delete[] (*it).xpol;
    if ( (*it).ypol ) delete[] (*it).ypol;
  }
  mElist.erase(mElist.begin(), mElist.end());
  return;
}




/*  --------------------------------------------------------------  */
/*  ------------------- Classe PIElDrawer ------------------------  */
/*  --------------------------------------------------------------  */

//++
// Class	PIElDrawer
// Lib		PI
// include	pieldrw.h
//
//	Classe de traceur ("Drawer") capable de grer et de 
//	tracer une liste d'lments simples. Cette classe
//	est utilis pour le trac des axes et des lments de
//	texte ds les "PIScDrawWdg", "PIDraw3DWdg" et "PIImage".
//--
//++
// Links	Parents
// PIDrawer
//--
//++
// Links	Voir aussi
// PIElDrwMgr
//--

//++
// Titre	Constructeurs et mthodes
//--

//++
// PIElDrawer()
//	Constructeur
//--

/* --Methode-- */
PIElDrawer::PIElDrawer()
{
ShowTitles();
 ShowAxesLabels();
}

/* --Methode-- */
PIElDrawer::~PIElDrawer()
{
}


//++
//  void  SetTitles(string tt, string tb)
//	Ajout de titres haut ("tt") et bas ("tb")
//--


/* --Methode-- */
int PIElDrawer::DecodeOptionString(vector<string> & opt, bool rmdecopt)
{
  int nopt0 = opt.size();
  if (nopt0 < 1)  return(0);  
  int ndec1 = PIDrawer::DecodeOptionString(opt, rmdecopt);
  if ((nopt0 - ndec1) < 1) return(ndec1);  // si tout a ete decode
  vector<string> udopt;
  unsigned int k = 0;
  int ndec = opt.size();
  for( k=0; k<opt.size(); k++ ) {
    string opts = opt[k];
    if ( (opts == "stdaxes") || (opts == "defaxes") || (opts == "boxaxes") )
      SetAxesFlags(kBoxAxes | kExtTicks | kLabels);
    else if (opts == "boxaxesgrid")
      SetAxesFlags(kBoxAxes | kExtTicks | kLabels | kGridOn);
    else if (opts == "fineaxes") 
      SetAxesFlags(kBoxAxes | kTicks | kLabels | kMinTicks | kMajTicks);
    else if ((opts == "grid") || (opts == "fineaxesgrid"))
      SetAxesFlags(kBoxAxes | kTicks | kLabels | kMinTicks | kMajTicks | kGridOn);
    else if (opts == "centeredaxes")
      SetAxesFlags(kStdAxes | kMajTicks | kLabels);
    else if (opts == "finecenteredaxes")
      SetAxesFlags(kStdAxes | kMajTicks | kMinTicks | kLabels);
    else if (opts == "centeredaxesgrid")
      SetAxesFlags(kStdAxes | kMajTicks | kLabels | kGridOn);
    else if (opts == "finecenteredaxesgrid")
      SetAxesFlags(kStdAxes | kMajTicks | kMinTicks | kLabels | kGridOn);
    else if (opts == "autofontsize")
      SetAxesAutoFontSize(true);
    else if (opts == "fixedfontsize")
      SetAxesAutoFontSize(false);
    else if (opts == "title") ShowTitles(true);
    else if (opts == "notitle") ShowTitles(false);

    else {
      ndec--;
      if (rmdecopt)  udopt.push_back(opts);
    }
  }  

  if (rmdecopt)  opt = udopt;
  return(ndec+ndec1);
}

/* --Methode-- */
void  PIElDrawer::DrawAxes(PIGraphicUC* g)
{
  g->NoClip();
  g->SaveGraphicAtt();
  PIAxes axes;
  axes.DrawXYAxes(g, mGrAtt, axesFlags, axesAFSz, XMin(), XMax(), YMin(), YMax()); 
  g->RestoreGraphicAtt();
  if (showAxesLabels) { 
    axes.DrawXCaption(g, labelAtt, axesFlags, xLabel);
    axes.DrawYCaption(g, labelAtt, axesFlags, yLabel);
  }
  g->Clip();
}

/* --Methode-- */
void  PIElDrawer::Draw(PIGraphicUC* g, double xmin, double ymin, double xmax, double ymax)
{
SelGraAtt(g);   // DrawAxes change certains attributs graphiques
DrawAxes(g);   // Trace des axes 
g->SelFont(PI_NormalSizeFont);
SelGraAtt(g);   // DrawAxes change certains attributs graphiques

// Trace des titres 
if ( showTitles && ((titleT.length() > 0) || (titleB.length() > 0)) ) {
  PIGraphicAtt grs = GetGraphicAtt();
  UpdateGraphicAtt(titleAtt);
  SelGraAtt(g); 

  aXdir = false;  // Vrai si Axe X de Droite vers Gauche 
  aYdir = false;  // Vrai si Axe Y de Haut vers Bas
  double fx, fy, fh;
//  fh = g->GetFontHeightUC(gas, gds);
  fh = 0.075*(YMax()-YMin());
  if ( titleT.length() > 0) {
      if (g->isAxeYDirUpDown()) fy = g->DeltaUCY(YMin(), -fh);
      else fy = g->DeltaUCY(YMax(), fh);
      g->DrawString((XMax()+XMin())*0.5, fy, titleT.c_str(), PI_HorizontalCenter | PI_VerticalCenter);
//      printf(" PIElDrawer::Draw()/DBG (%g , %g) %s  - %g \n", fx, fy, titleT.c_str(), fh);
    }
  if ( titleB.length() > 0) {
      fx = g->CalcStringWidth(titleB.c_str());
      if(aXdir) fx = g->DeltaUCX(XMax(), -(XMax()-XMin()-fx)/2.);
      else fx = g->DeltaUCX(XMin(), (XMax()-XMin()-fx)/2.);
      if (g->isAxeYDirUpDown()) fy =  g->DeltaUCY(YMax(), fh*1.5);
      else fy = g->DeltaUCY(YMin(), -fh*1.5);
      g->DrawString((XMax()+XMin())*0.5, fy, titleB.c_str(), PI_HorizontalCenter | PI_VerticalCenter);
//      printf(" PIElDrawer::Draw()/DBG (%g , %g) %s  - %g \n", fx, fy, titleT.c_str(), fh);
    }
  SetGraphicAtt(grs);
  }

 SelGraAtt(g);
// Trace des elements
 ElDrwMgr().DrawElements(g, xmin, ymin, xmax, ymax);

}

