// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: toidelay.cc,v 1.1 2002-09-09 15:33:15 aubourg Exp $

#include "toimanager.h"
#include "toidelay.h"

TOIDelay::TOIDelay(int n) {
  delay = n;
  nskip = ndrop = 0;
}

void TOIDelay::init() {
  declareInput("signal");
  declareOutput("signal");
  upExtra = delay + ndrop;
  lowExtra = nskip;
}

#define BUFSZ 4096

void TOIDelay::run() {
  int snb = getMinIn()+nskip;
  int sne = getMaxIn()-ndrop;


  if(snb>sne) {
    cout<<"TOIDelay::run() - Bad sample interval"<<snb<<" , "<<sne<<endl;
    throw ParmError("TOIDelay::run() - Bad sample interval");
  }

  cout << "TOIDelay delay="<<delay<< " sn : " << snb << " - " << sne << endl;

  double* buf = new double[BUFSZ];
  
  int sn = snb;
  while (sn <= sne) {
    int sn2 = sn + BUFSZ - 1;
    if (sn2>sne) sn2=sne;
    int nsamp = sn2-sn+1;
    getData(0, sn+delay, nsamp, buf);
    putData(0, sn, nsamp, buf);
    sn += nsamp;
  }
}
