// This may look like C code, but it is really -*- C++ -*-

// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: toi.h,v 1.17 2002-09-09 15:33:15 aubourg Exp $

#ifndef TOI_H
#define TOI_H

#include "config.h"
#include <vector>
using namespace std;

#include <pthread.h>

#ifdef WITH_SOPHYA
#include "array.h"
#include "pexceptions.h"
using namespace SOPHYA;
#else
#include "apexceptions.h"
#endif



class TOIProcessor;

class TOI {
public:
  TOI();
  TOI(string name);
  virtual ~TOI();

  //   ----- Rajouts Reza 12/3/2001
  virtual void PrintStatus(::ostream & os) const;
  //  Fin rajouts Reza 12/3/2001 ------


#ifdef WITH_SOPHYA
  /* l'interface va etre modifiee, NE PAS UTILISER
  virtual Array         getData(int iStart, int iEnd);
  virtual Array         getError(int iStart, int iEnd);
  virtual TArray<int_4> getFlag(int iStart, int iEnd);
  l'interface va etre modifiee, NE PAS UTILISER */
#endif

  enum DataStatus       {DATA_OK=0, DATA_DELETED, DATA_NOT_YET};
    
  virtual double        getData(int i);
  virtual void          getData(int i, double &data, uint_8 &flag);
  //RZCMV  virtual DataStatus    getDataError(int i,double &data,double &error,int_4 &flag);
  virtual void          getData(int i, int n, double* data, uint_8* flg=0);

  virtual DataStatus    isDataAvail(int iStart, int iEnd);
  virtual DataStatus    isDataAvail(int i);
  virtual void          waitForData(int iStart, int iEnd);
  virtual void          waitForData(int i);
  virtual void          waitForAnyData();
  virtual int           nextDataAvail(int iAfter)=0;
  virtual bool          hasSomeData()=0;
  
  virtual void          putData(int i, double value, uint_8 flag=0);
  //RZCMV  virtual void          putDataError(int i, double value, 
  //		                     double error, int_4 flag=0);
  virtual void          putData(int i, int n, double const* val, uint_8 const* flg);
  virtual void          putDone() {}

  virtual void          wontNeedBefore(int i);
  
  bool  dbg;

  void setName(string n) {name =n;}
  string getName() const {return name;}

  bool needSyncOldWay() const {return syncOldWay;}

protected:
  TOI*                  errorTOI;
  pthread_mutex_t       mutex;
  //   ----- Rajouts Reza 12/3/2001
  pthread_cond_t        condv;
  bool                  fgwaitput;
  bool                  fgwaitget;
  bool                  fgsigput;
  bool                  fgsigget;
  int                   countwaitput;
  int                   countwaitget;
  //  Fin rajouts Reza 12/3/2001 ------

  // variables pour propagation
  TOIProcessor*         producer;       //producteur du toi
  vector<TOIProcessor*> consumers;      //consomateurs du toi
  
  double                defaultValue;
  bool  syncOldWay;

#ifdef WITH_SOPHYA
  /* l'interface va etre modifiee, NE PAS UTILISER
  virtual Array         doGetData(int iStart, int iEnd)=0;
  virtual TArray<int_4> doGetFlag(int iStart, int iEnd)=0;
  l'interface va etre modifiee, NE PAS UTILISER */
#endif

  virtual void          doGetData(int i, double& data, uint_8& flag)=0;
  virtual void          doPutData(int i, double value, uint_8 flag=0)=0;
  virtual void          doWontNeedBefore(int i);

  virtual DataStatus    isDataAvailNL(int iStart, int iEnd)=0;
  virtual DataStatus    isDataAvailNL(int i);

  virtual void          setProducer(TOIProcessor* prod);
public: // for toiprocessors redefining addInput. Change ?
  virtual void          addConsumer(TOIProcessor* prod);
protected:
  friend class          TOIProcessor;
      
  string name;

  virtual int           getMinSn();
  virtual int           getMaxSn();
  void  TOIInit();

  // Il faut faire attention avec mutex et condv, si TOI cree sur le stack !
  // Il faut donc faire new TOI  -    Reza 11/3/2001
  void lock() {pthread_mutex_lock(&mutex);}
  void unlock() {pthread_mutex_unlock(&mutex);}

  //   ----- Rajouts Reza 12/3/2001
  inline void wait() {pthread_cond_wait(&condv, &mutex);}
  inline void signal() {pthread_cond_signal(&condv);}
  inline void broadcast() {pthread_cond_broadcast(&condv);}
  inline void waitPut() 
    {fgwaitput=true; countwaitput++; pthread_cond_wait(&condv, &mutex);}
  inline void waitGet() 
    {fgwaitget=true; countwaitget++; pthread_cond_wait(&condv, &mutex);}
  inline bool isPutWaiting() const { return fgwaitput; }
  inline bool isGetWaiting() const { return fgwaitget; }
  inline void signalPut() {fgsigput=true; }
  inline void signalGet() {fgsigget=true; }
  inline void cleanWaitPut() { fgsigput = fgwaitput = false; }
  inline void cleanWaitGet() { fgsigget = fgwaitget = false; }


  // ajout vf 31/07/2002
  bool checkSampleLimits(long &Min, long &Max, int pass);





public:
  inline int  getCountWaitPut() const { return countwaitput; }
  inline int  getCountWaitGet() const { return countwaitget; }
  //  Fin rajouts Reza 12/3/2001 ------

};

inline ::ostream & operator << (::ostream & os, TOI const & toi)
{ toi.PrintStatus(os); return os; }

class TOIRegular : public TOI {
};


#endif






