#include "defs.h"
#include "exceptions.h"
#include <iostream.h>
#include <new.h>
#ifndef __mac__
#include <unistd.h>
#endif
#include <stdlib.h>
#include "perrors.h"

#ifdef __mac__
#include "unixmac.h"
#include <SIOUX.h>
#endif

//#define LAL

#ifndef EXC_MSG
#define EXC_MSG(i) "Exception " << i
#endif

#define kDynAllocBlock 10

void EAFailHandler(void); 

#ifndef COMPILER_EXCEPTIONS

#ifndef NO_EXCEPTIONS

ExcHndl::ExcHndl(ExcHndl* up)
: nextHandler(up), 
  theExc(0), hadExc(0),
  nObj(0), nObjAlloc(kDynAllocBlock), objects((ExcAwareObject**)malloc(kDynAllocBlock*sizeof(void*))), 
  nDyn(0), nDynAlloc(kDynAllocBlock), dynObjs((ExcAwareObject**)malloc(kDynAllocBlock*sizeof(void*))),
  nDynTab(0), nDynTabAlloc(kDynAllocBlock), 
  dynTabObjs((ExcAwareObject**)malloc(kDynAllocBlock*sizeof(void*))),
  dynTabSz((size_t*)malloc(kDynAllocBlock*sizeof(size_t)))
{
 //  cerr << "TRY : " << hex << this << "  <-  " << nextHandler << dec << endl;
}

ExcHndl::~ExcHndl()
{
  free(objects);
  free(dynObjs);
  free(dynTabObjs);
  free(dynTabSz);
 // cerr << "~TRY: " << hex << this << "  <-  " << nextHandler << dec << endl;
}

void ExcHndl::Add(ExcAwareObject* obj)
{
  // on verifie s'il est dans la liste a ignorer
  int trouve=0;
  int i;
  for (i=0; i<nDyn; i++)
    if (dynObjs[i] == obj) {
      trouve = true;
      break;
    }
  if (trouve) {   // On le vire de la table des news.
    nDyn--;
    for (int j=i; j<nDyn; j++)
      dynObjs[j] = dynObjs[j+1];
    return;
  }
  
  // Dans les tableaux ?
  for (i=0; i<nDynTab; i++)
    if ((dynTabObjs[i] <= obj) && ((char*)(dynTabObjs[i]) + dynTabSz[i] >= (char*)obj)) {
      return;
    }

  // on l'ajoute a la liste des objets
  nObj++;
  if (nObj>nObjAlloc) {
    nObjAlloc += kDynAllocBlock;
    objects = (ExcAwareObject**) realloc(objects, nObjAlloc*sizeof(void*));
  }

  objects[nObj-1] = obj;
}

void ExcHndl::Forget(ExcAwareObject* obj)
{
  // on verifie s'il est dans la liste
  int trouve=0;
  int i=0;
  for (i=0; i<nObj; i++)
    if (objects[i] == obj) {
      trouve = true;
      break;
    }
  if (trouve) {
    nObj--;
    for (int j=i; j<nObj; j++)
      objects[j] = objects[j+1];
  }
}

void ExcHndl::Ignore(ExcAwareObject* obj)
{
  // on l'ajoute a la liste des objets
  nDyn++;
  if (nDyn>nDynAlloc) {
    nDynAlloc += kDynAllocBlock;
    dynObjs = (ExcAwareObject**) realloc(dynObjs, nDynAlloc*sizeof(void*));
  }

  dynObjs[nDyn-1] = obj;
}

void ExcHndl::IgnoreTab(ExcAwareObject* obj, size_t sz)
{
  // on l'ajoute a la liste des objets
  nDynTab++;
  if (nDynTab>nDynTabAlloc) {
    nDynTabAlloc += kDynAllocBlock;
    dynTabObjs =(ExcAwareObject**) realloc(dynTabObjs, nDynTabAlloc*sizeof(void*));
    dynTabSz   = (size_t*) realloc(dynTabSz,   nDynTabAlloc*sizeof(size_t));
  }

  dynTabObjs[nDynTab-1] = obj;
  dynTabSz  [nDynTab-1] = sz;
}

void ExcHndl::DelTab(ExcAwareObject* obj)
{
  // on le supprime

  int trouve=0;
  int i=0;
  for (i=0; i<nDynTab; i++)
    if (dynTabObjs[i] == obj) {
      trouve = true;
      break;
    }
  if (trouve) {
    nDynTab--;
    for (int j=i; j<nDynTab; j++) {
      dynTabObjs[j] = dynTabObjs[j+1];
      dynTabSz  [j] = dynTabSz  [j+1];
    }
  }
}



// End Constructor : ne pas se preoccuper des objets qui sont
// a l'interieur de cet objet.
void ExcHndl::EndConstructor(void* obj, size_t s)
{
  for (int i=0; i<nObj; i++)
    if ((char*)objects[i] > (char*)obj && (char*)objects[i] < (char*)obj + s) {
      nObj--;
      for (int j=i; j<nObj; j++)
	objects[j] = objects[j+1];
      i--;
    }
}

#undef DEBUG

void ExcHndl::Throw(int i, char* file, int line)
{
  if (_ExcAbortAll || (i<0 && _ExcAbortNeg)) {
    cerr << EXC_MSG(i);
    if (file) cerr << " file " << file << " line " << line;
    cerr << endl;
    abort();
  } else {
    #ifdef DEBUG
    cerr << "caught " << EXC_MSG(i);
    if (file) cerr << " file " << file << " line " << line;
    cerr << endl;
    #endif
    theExc = i;
    hadExc = 1;
    
    // On detruit tous les objets crees depuis le TRY
    // ExcAwareObject a un destructeur virtuel...
    // Le tableau est dans l'ordre de creation. donc i--
    
    for (int i=nObj-1; i>=0; i--)
      objects[i]->~ExcAwareObject();
    
    // et maintenant on saute...
    
    longjmp(env, 1);
  }
}


void ExcHndl::NoHandler(int i, char* file, int line)
{
  cerr << "No handler : ";
  cerr << EXC_MSG(i);
  if (file) cerr << " file " << file << " line " << line;
  cerr << endl;
  terminate();
}

ExcHndl* topExcHndl = 0;
int      _ExcAbortNeg = 1;
int      _ExcAbortAll = 0;

#endif
#endif


void EAFailHandler(void)
{
        set_new_handler(NULL);
	cerr << "Allocation exception -- out of memory" << endl;
        THROW(allocationErr);
}

void InitFailNewHandler()
{
        set_new_handler(EAFailHandler);
}


#ifdef THINK_CPLUS
void terminate()
{
	DebugStr("\pTerminate...");
	abort();
}
#endif

#ifdef x__GNUG__
void terminate()
{ abort(); }
#endif
