#ifndef PERRORS_SEEN
#define PERRORS_SEEN

// Erreurs PEIDA
// Les erreurs graves sont negatives. Par defaut elles causent
// un abort, alors que les erreurs positives propagent une
// exception.
// voir les macros EXC_ABORT_NEG(flag) et EXC_ABORT_ALL(flag)

#include "exceptions.h"
enum {
  allocationErr    = -1,
  nullPtrErr       = -2,
  sizeMismatchErr  = -3,
  rangeCheckErr    = -4,
  parmErr          = -5,
  forbiddenErr     = -6,
  assertionFailErr = -7,

  typeMismatchErr  = 1,
  fileErr             ,
  fitsImageErr        ,
  endOfFileErr        ,
  tapeErr             ,
  tapeNoLogErr        ,
  tapeNoLabelErr      ,
  tapeEndMediaErr     ,
  tapeNotReadyErr     ,
  acqTapeErr          ,
  acqRobotErr         ,
  tarFileErr          ,
  tarFileNoHeaderErr  ,
  noStarsErr          ,
  transfoErr          ,
  fitsHeaderErr       ,
  singMatxErr         ,
  noCvgErr            ,
  notFoundErr         ,
  dupIdErr            ,
  getEnvErr           ,
  catchedSIGFPE       ,
  catchedSIGSEGV      ,
  catchedSIGINT       ,
  catchedSIGQUIT      ,
  catchedSIGUSR1      ,
  catchedSIGUSR2      ,
  inconsistentErr
};

static inline char* PeidaExc(int i) {
  switch (i) {
  case allocationErr:       return "Allocation Exception";
  case nullPtrErr:          return "Null Pointer Exception";
  case sizeMismatchErr:     return "Size Mismatch Exception";
  case rangeCheckErr:       return "Range Check Exception";
  case parmErr:             return "Invalid Parameter Exception";
  case forbiddenErr:        return "Forbidden Function Exception";
  case assertionFailErr:    return "Assertion Failed Exception";
  case typeMismatchErr:     return "Type Mismatch Exception";
  case fileErr:             return "File Error Exception";
  case fitsImageErr:        return "FitsImage Error Exception";
  case endOfFileErr:        return "End of File Error Exception";
  case tapeErr:             return "Tape Error Exception";
  case tapeNoLogErr:        return "Tape No Log File Exception";
  case tapeNoLabelErr:      return "Tape No label Exception";
  case tapeEndMediaErr:     return "Tape end data Exception";
  case tapeNotReadyErr:     return "Tape not ready Exception";
  case acqTapeErr:          return "Acq Tape Error Exception";
  case acqRobotErr:         return "Acq Robot Error Exception";
  case tarFileErr:          return "TarFile Error Exception";
  case tarFileNoHeaderErr:  return "TarFile No Header Error Exception";
  case noStarsErr:          return "No/Not Enough Stars Exception";
  case transfoErr:          return "Transformation finding Exception";
  case fitsHeaderErr:       return "Fits Header Exception";
  case singMatxErr:         return "Singular Matrix Exception";
  case noCvgErr:            return "No Convergence Exception";
  case notFoundErr:         return "Not Found Exception";
  case dupIdErr:            return "Duplicate Id Exception";
  case getEnvErr:           return "GetEnv no var Exception";
  case inconsistentErr:     return "Inconsistent Data Exception";
  case catchedSIGFPE:       return "catched SIGFPE (floating point exception) Exception";
  case catchedSIGSEGV:      return "catched SIGSEGV (segmentation fault) Exception";
  case catchedSIGINT:       return "catched SIGINT (Interrupt signal) Exception";
  case catchedSIGQUIT:      return "catched SIGQUIT (Quit signal) Exception";
  case catchedSIGUSR1:      return "catched SIGUSR1 (User1 signal) Exception";
  case catchedSIGUSR2:      return "catched SIGUSR2 (User2 signal) Exception";
  }
  return "Unkown Exception";
}


#define FAILNIL(_x_) \
       if (!(_x_)) THROW(nullPtrErr)

#define EXC_MSG(i) PeidaExc(i) << "(" << i << ")"

#ifdef DEBUG
#define DBFAILNIL(_x_) FAILNIL(_x_)
#define DBASSERT(_x_) ASSERT(_x_)
#else
#define DBFAILNIL(_x_)
#define DBASSERT(_x_)
#endif

#endif
