//
// $Id: ctimer.cc,v 1.1.1.1 1999-04-09 17:57:04 ansari Exp $
//

#include "defs.h"
#include "ctimer.h"

//++
// Class	Timer
// Lib  	Outils++
// include	ctimer.h
//
//	Chronomtrage de programmes. Le constructeur mmorise l'heure et
//      le temps CPU, ainsi qu'un message ventuel.
//
//	Split affiche le temps partiel.
//
//	Le destructeur affiche le temps total (CPU, et coul).
//    
//      Des macros permettent une utilisation simplifie :
//      * TIMEF   cre un objet de type Timer, avec le nom de la function 
//	courante comme message. Le temps coul sera affich  la sortie 
//	de la function.
//      * SPLITTIME affiche le temps partiel du compteur cre par TIMEF
//      * TIMEN(nom) permet de donner un autre nom que le nom de la fonction.
//--


//++
// Titre	Constructeurs
//--

//++
// Timer::Timer(const char* name)
//	Cre un objet qui mmorise l'heure et le temps CPU du process courant.
//	Le destructeur affiche les temps coul et CPU utilis.
//--

Timer::Timer(const char* name)
: timerName(name)
{
  cpu0 = cpuSplit = clock();
  elapse0 = elapseSplit = time(0);
  END_CONSTRUCTOR
}

//++
// Titre	Mthodes
//--

//++
// Timer::Split(const char* comm)
//	Affiche le temps partiel.
//--


void Timer::Split(const char* comm)
{
  time_t elapse = time(0);
  clock_t cpu   = clock();

  float cpuSecT = ((float)cpu - (float)cpu0) / (float)(CLOCKS_PER_SEC);
  float cpuSecP = ((float)cpu - (float)cpuSplit) / (float)(CLOCKS_PER_SEC);
  
  int etm  = elapse - elapseSplit;
  int etmt = elapse - elapse0;

  cout << "***Timing " << (comm ? comm : timerName) << endl;

// Pour des formats comme ca, la syntaxe printf est plus agreable.
// Pour ne pas melanger stdio/iostream (pb de desynchronisation sur
// autres C++ que GNU), on fait un cout << chaine.

  char out[200];
  sprintf(out,"CPU     Time: Total= %g (Partial= %g) Sec.",
	  cpuSecT, cpuSecP);
  cout << out << endl;

  sprintf(out,"Elapsed Time: Total= %02d:%02d:%02d (Partial=%02d:%02d:%02d)",
	  etmt/3600, (etmt%3600)/60, etmt%60, 
	  etm/3600,  (etm%3600)/60,  etm%60);

  cout << out << endl;

  elapseSplit = elapse;
  cpuSplit    = cpu;
}

Timer::~Timer()
{
  Split();
}
