// Pour merger des fichiers FITS       cmv 19/06/2002
#include "machdefs.h"
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include "toi.h"
#include "toimanager.h"
#include "fitstoirdr.h"
#include "fitstoiwtr.h"
#include "sophyainit.h"
#include "strutilxx.h"
#include "timing.h"
#include <stdexcept>

struct In_TOI {
  string         ColNameIn;
  string         ColNameOut;
  bool           ColFlagOut;
  vector<string> FileNameIn;
  void Init(void) {
    ColNameIn=""; ColNameOut=""; ColFlagOut=false;
    FileNameIn.resize(0);
  }
};

int DecodeDatac(string datacname,vector< struct In_TOI > &TOI_Merge);
void PrintDatac(vector< struct In_TOI > &TOI_Merge);
void usage(void);

void usage(void) {
 cout
 <<"toimerge [-h] [-I] [-p lp] [-s samplemin,samplemax] [-w data_window_size]"<<endl
 <<"         -o nameout.fits inout.datacard"<<endl
 <<" -p lp : print level (def=0)"<<endl
 <<" -s samplemin,samplemax : sample range to be treated (def=all)"<<endl
 <<" -w data_window_size : window size for pipe (def=8192)"<<endl
 <<" -o : nom du fichier FITS en sortie [toimerge.fits]"<<endl
 <<" inout.datacard : nom datacard descriptif [toimerge.datac]"<<endl;
}

////////////////////////////////////////////////////////////////
int main(int narg, char** arg)
{
//-- Decodage arguments
int lp=0, width=8192;
long sdeb,sfin;
bool gsetstart=false;
string namefitsout="toimerge.fits";
string namedatacard="toimerge.datac";
bool fgsegmented=false;
int c;
while((c = getopt(narg,arg,"hp:s:w:o:")) != -1) {
  switch (c) {
  case 's' :
    sscanf(optarg,"%ld,%ld",&sdeb,&sfin);
    cout<<"Requested Samples from "<<sdeb<<" , "<<sfin<<endl;
    gsetstart = true;
    break;
  case 'w' :
    sscanf(optarg,"%d",&width);
    if(width<=0) width=8192;
    cout<<"Data window size "<<width<<endl;
    break;
  case 'p' :
    sscanf(optarg,"%d",&lp);
    if(lp<0) lp=0;
    break;
  case 'o' :
    namefitsout=(string)optarg;
    cout<<"Fits outfile name : "<<namefitsout<<endl;
    break;
  case 'h' :
  default:
    usage(); exit(1);
    break;
  }
}
if(optind<narg) {
  namedatacard = arg[optind];
  cout<<"Input datacards : "<<namedatacard<<endl;
}

SophyaInit();
InitTim();

//--------------------------------------------------------------------
try {
//--------------------------------------------------------------------

 // Decode datacards
 vector< struct In_TOI > TOI_Merge;
 int ntoi = DecodeDatac(namedatacard,TOI_Merge);
 if(lp) PrintDatac(TOI_Merge);
 if(ntoi<=0) throw ParmError("Error: No Connected TOI");

 // Set Pipe
 TOIManager* mgr = TOIManager::getManager();
 //if(gsetstart) mgr->setRequestedSample(sdeb,sfin);
 if(fgsegmented) mgr->selectTOISegmented(width);
   else          mgr->selectTOISeqBuffered(width);

 // Create FITS writer
 cout<<"> Creating FITSTOIWriter OutFitsName= "<<namefitsout<<endl;
 string cmd = "rm -f "; cmd += namefitsout; system(cmd.c_str());
 FITSTOIWriter wfits(namefitsout);
 //if(gsetstart) wfits.setRequestedSample(sdeb,sfin);

 // Create FITS reader table
 cout<<"> Creating "<<ntoi<<" FITSTOIReader"<<endl;
 FITSTOIReader **rfits = new FITSTOIReader*[ntoi];
 for(int i=0;i<ntoi;i++) rfits[i]=NULL;

 // Create FITS reader and connect
 cout<<"> Connecting Processors ... "<<endl;
 for(int i=0;i<ntoi;i++) {
   int nread = TOI_Merge[i].FileNameIn.size();
   if(lp>1) cout<<"---TOI "<<i<<",  "<<nread<<" input files connected"<<endl;
   string colin  = TOI_Merge[i].ColNameIn;
   string colout = TOI_Merge[i].ColNameOut;
   bool withflag = TOI_Merge[i].ColFlagOut;
   if(nread<=0) throw ParmError("Error: No input file for that TOI");
   for(int j=0;j<nread;j++) {
     string fname = TOI_Merge[i].FileNameIn[j];
     if(j==0) rfits[i] = new FITSTOIReader(fname,width);
       else   rfits[i]->addFile(fname);
   }
   mgr->connect(*(rfits[i]),colin,wfits,colout,"",width,withflag);
 }

 // Start Pipe
 PrtTim("starting processors");
 mgr->startAll();

 // ------------------- Impression continu de stat ------------------------ 
 if(lp>1) {
   sleep(3);  // Il faut attendre que le FitsWriter ait demarre
   ProcSampleCounter<FITSTOIWriter> stats(wfits);
   stats.InfoMessage() = "toimerge/Info";
   stats.PrintStats();
 }
 // -----------------------------------------------------------------------

 // End Pipe
 mgr->waitForAll();
 PrtTim("End threads");

 // Cleaning
 for(int i=0;i<ntoi;i++) if(rfits[i]) delete rfits[i];
 delete rfits;

//--------------------------------------------------------------------
} catch (PThrowable & exc) {
  cout<<"\ntoimerge: Catched Exception \n"<<(string)typeid(exc).name() 
      <<" - Msg= "<<exc.Msg()<<endl;
} catch (const std::exception & sex) {
  cout<<"\ntoimerge: Catched std::exception \n" 
      <<(string)typeid(sex).name()<<endl;
} //catch (...) {
//cout<<"\ntoimerge: some other exception was caught ! "<<endl;
//}
//--------------------------------------------------------------------

exit(0);
}


//--------------------------------------------------------------------
//--------------------------------------------------------------------
int DecodeDatac(string datacname,vector< struct In_TOI > &TOI_Merge)
/*
Format du fichier de datacards:
@TOI nom_col_int nom_col_out flag
  nom_col_int : nom de la colonne a lire dans le FITS d'entree
  nom_col_out : nom de la colonne a ecrire dans le FITS de sortie
  flag_out = n'importe quoi : ecriture d'une colonne de flag pour ce TOI
             absent         : pas de flag pour ce TOI (default)
@REP nom_rep
  nom_rep : nom du repertoire courant pour lire les fichiers en entree.
            Peut etre change en cours de route. Defaut=./
@FILE nom_fichier
  nom_fichier : en entree (il est dans le dernier nom_rep appelle).
Return: le nombre de TOI en entree qui ont ete connectees

--- Exemple:
#######################################################
>>> 1er TOI avec ecriture de flag
@TOI  boloMuV_24 bolomuv FLAG
@REP $PLANCK/Kiruna_2002_02_07/TOI/Full_sampling/Bolos_optfilt
  @FILE b143k03_0.fits
  @FILE b143k03_1.fits
  @FILE b143k03_2.fits
@REP $PLANCK/Kiruna_2002_02_07/TOI/Full_sampling/Bolos_optfilt_2
  @FILE b143k03_a.fits
  @FILE b143k03_b.fits
>>> 2sd TOI sans ecriture de flag
@REP $PLANCK/Kiruna_2002_02_07/TOI/Full_sampling/Pointing_LALv3
@TOI  GLON_24 glon
  @FILE bolo24_gal0.fits
  @FILE bolo24_gal1.fits
  @FILE bolo24_gal2.fits
  @FILE bolo24_gal3.fits
  @FILE bolo24_gal4.fits
  @FILE bolo24_gal5.fits
  @FILE bolo24_gal6.fits
@TOI  GLAT_24 glat
  @FILE bolo24_gal0.fits
  @FILE bolo24_gal1.fits
  @FILE bolo24_gal2.fits
  @FILE bolo24_gal3.fits
  @FILE bolo24_gal4.fits
  @FILE bolo24_gal5.fits
  @FILE bolo24_gal6.fits
#######################################################
############### Fin du fichier datacard ###############
#######################################################
*/
{
#define LENLINE 4096
 char line[LENLINE];
 FILE* FileDatacard = fopen(datacname.c_str(),"r");
 //cout<<">>> DecodeDatac:"<<datacname<<endl;
 if(FileDatacard==NULL) throw IOExc("DecodeDatac: Error opening datacards");

 string repcur = "./";
 struct In_TOI intoi;
 int ntoi=-1;

 while(fgets(line,LENLINE,FileDatacard) != NULL) {

   string sline = line;
   // Attention, il y a un '\n' a la fin de ligne ?
   size_t pos = sline.rfind('\n');
   if(pos<sline.size()) sline.resize(pos);
   //cout<<">>>>"<<sline<<endl;

   vector<string> vsline;
   FillVStringFrString(sline,vsline,' ');
   if(vsline.size()==0) continue;
   //for(int i=0;i<vsline.size();i++) cout<<"vsline["<<i<<"]="<<vsline[i]<<endl;
   if(vsline[0][0] != '@' ) continue;

   if(strstr(vsline[0].c_str(),"@TOI") == vsline[0].c_str()) {
     if(vsline.size()<3)
       throw ParmError("DecodeDatac: Give a col name for @TOI IN and OUT");
     ntoi++;
     intoi.Init();
     TOI_Merge.push_back(intoi);
     TOI_Merge[ntoi].ColNameIn  = vsline[1];
     TOI_Merge[ntoi].ColNameOut = vsline[2];
     TOI_Merge[ntoi].ColFlagOut = false;
     if(vsline.size()>3) TOI_Merge[ntoi].ColFlagOut = true;
     //cout<<"New TOI("<<ntoi<<") ColNameIn="<<vsline[1]<<endl;
     //cout<<"       ColNameOut="<<vsline[2]<<" flag="<<TOI_Merge[ntoi].ColFlagOut<<endl;

   } else if(strstr(vsline[0].c_str(),"@REP") == vsline[0].c_str()) {
     if(vsline.size()>1) repcur = vsline[1];
     if(repcur.size()>0)
       if(repcur[repcur.size()-1] != '/') repcur += '/';
     //cout<<"repcur: "<<repcur<<endl;

   } else if(strstr(vsline[0].c_str(),"@FILE") == vsline[0].c_str()) {
     if(ntoi<0) continue;
     if(vsline.size()<2) throw ParmError("DecodeDatac: Give filename AND colname for @FILE");
     string fname = repcur + vsline[1];
     TOI_Merge[ntoi].FileNameIn.push_back(fname);
     //cout<<"File: "<<fname<<endl;

   }
 }

 return ntoi+1;
}

void PrintDatac(vector< struct In_TOI > &TOI_Merge)
{
 int ntoi = TOI_Merge.size();
 cout<<"PrintDatac: ntoi="<<ntoi<<endl;
 for(int i=0;i<ntoi;i++) {
   int n = TOI_Merge[i].FileNameIn.size();
   cout<<"TOI("<<i<<") NameIn="<<TOI_Merge[i].ColNameIn
       <<" NameOut="<<TOI_Merge[i].ColNameOut
       <<" FlagOut="<<TOI_Merge[i].ColFlagOut
       <<", "<<n<<" connected TOI"<<endl;
   if(n>0) for(int j=0;j<n;j++)
     cout<<"   "<<j<<" File="<<TOI_Merge[i].FileNameIn[j]<<endl;
 }
}
