// This may look like C code, but it is really -*- C++ -*-
// Interface de type NTuple           Reza 05/99
// LAL-IN2P3/CNRS               CEA-DAPNIA      

#ifndef NTUPLEINTERFACE_H_SEEN
#define NTUPLEINTERFACE_H_SEEN

#include "machdefs.h"
#include <string>

namespace SOPHYA {  

class NTupleInterface {
public:
  			NTupleInterface(); 
  virtual		~NTupleInterface();
// Nombre de lignes du NTuple  (Nb d'entrees)  
  virtual uint_4        NbLines() const ;
// Nombre de colonnes (nb de variables)
  virtual uint_4        NbColumns() const ;
// La ligne numero n, sous forme d'un tableau de double
  virtual r_8 *         GetLineD(int n) const ;
// Cellule de la ligne n, colonne k
  virtual r_8		GetCell(int n, int k) const ;
// Cellule de la ligne n, colonne nom
  virtual r_8		GetCell(int n, string const & nom) const ;
// Cellule de la ligne n, colonne k, converti en chaine de caracteres
  virtual string	GetCelltoString(int n, int k) const ;
// Cellule de la ligne n, colonne nom, converti en chaine de caracteres
  virtual string	GetCelltoString(int n, string const & nom) const ;
// Min et Max pour la colonne k
  virtual void		GetMinMax(int k, double& min, double& max)   const ; 
// Min et Max pour la colonne nom
  virtual void		GetMinMax(string const & nom, double& min, double& max)   const ;
// Numero de colonne pour nom 
  virtual int           ColumnIndex(string const & nom)  const ;
// Nom de colonne numero k
  virtual string        ColumnName(int k) const;
// Declaration des variables style C
  virtual string	VarList_C(const char* nomx=NULL) const ;
// Entete et liste de variable, pouvant servir a l'impression
  virtual string        LineHeaderToString() const;
// Contenu de la ligne n, pouvant servir a l'impression
  virtual string        LineToString(int n) const;  
};

} // namespace SOPHYA

#endif   /*  NTUPLEINTERFACE_H_SEEN  */


