#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#ifdef OSF1
#include <dlfcn.h>
#endif

#include "perrors.h"
#include "ctimer.h"
#include "fitsimage.h"
#include "dynccd.h"

#include "strecinit.h"

#include "psf.h"
#include "nbmath.h"

#include "pidemo.h"
#include "piup.h"


/*  Pour le link dynamique  */
typedef ImageR4 * (* UsPrFunc) (ImageR4 * myimg, int xp, int yp, int dx, int dy,
                                char * arg1, char * arg2);
static UsPrFunc  userFunc[3] = { NULL, NULL, NULL };
static void *dlhandle = NULL;

/*  Variables globales pour les options et parametres de pidemo  */
static int pav_sz=15;
static bool rect_pav=true;
static int typ_psf=1;
static bool prt_pval=true;
static DynCCD *mdynccd;   // Initialise ds main()
static bool his_ckd=true;
static float his_min=0.;
static float his_max=2000.;
static int his_nbin=200; 
static bool vis_cursshow=true;
static int vis_zoom=1;
/*  Fin des options / variables globales                         */

static int DynLink(bool fgmk);

/* Nouvelle-Fonction */
int DynLink(bool fgmk)
{
UsPrFunc uf;
int i, rc;

#ifdef C_NO_SHLIBS
puts("PIDemo/DynLink() Warning: Cette version a ete cree sans ShLibs ");
puts(" ... Pas de possibite de link dynamique -> Pas de UserProc ... ");
for(i=0; i<3; i++)  userFunc[i] = NULL;
return(0);
#else

TIMEF
if (dlhandle != NULL)  dlclose(dlhandle);
for(i=0; i<3; i++)  userFunc[i] = NULL;

if (fgmk)
  {
  printf("PIDemo_DynLink(): Making user.so, Relinking from user.so -> piup.so \n");
  puts("PIDemo_DynLink(): Executing make -f piusmak piup.so ");
  system("time make -f piusmak piup.so");
  SPLITTIME
  }

dlhandle =  dlopen("piup.so", RTLD_NOW);
if (dlhandle == NULL)  
  { printf("PIDemo_DynLink(), Erreur d'ouverture UserShLib piup.so \n");
  return(100); }
rc = 0;
printf("PIDemo_DynLink(): Searching for PIUserProc_1 (Rc=%d) \n", rc);
uf = (UsPrFunc) dlsym(dlhandle, "PIUserProc_1__FPt5Image1ZfiiiiPcT5");
if (uf != NULL)  userFunc[0] = uf;
else rc += 2;
printf("PIDemo_DynLink(): Searching for PIUserProc_3 (Rc=%d) \n", rc);
uf = (UsPrFunc) dlsym(dlhandle, "PIUserProc_2__FPt5Image1ZfiiiiPcT5");
if (uf != NULL)  userFunc[1] = uf;
else rc += 4;
printf("PIDemo_DynLink(): Searching for PIUserProc_3 (Rc=%d) \n", rc);
uf = (UsPrFunc) dlsym(dlhandle, "PIUserProc_3__FPt5Image1ZfiiiiPcT5");
if (uf != NULL)  userFunc[2] = uf;
else rc += 8;

if (rc != 0)  printf("PIDemo_DynLink() / Erreur, Rc = %d \n", rc);
return(rc);
#endif
}

/* ........................................................... */
/*                    Classe PIDemoApp                         */
/* ........................................................... */

/* --Methode-- */
PIDemoApp::PIDemoApp(char *path)
: PIApplication(400, 230)
{
for(int i=0; i<NMXWIN; i++)
  { awp[i] = NULL;  taw[i] = 0; }
mNwin = 0;   mTnw = 0;  mCurWin = NULL;  mCurPII = NULL;   

m[0] = new PIPDMenu((PIMsgHandler *)Menubar(),"Fichier");
m[0]->AppendItem("Options", 10110);
m[0]->AppendItem("Open", 10101);
m[0]->AppendItem("Close", 10102);
m[0]->AppendItem("Save", 10103);
m[0]->AppendItem("Relink", 10104);
m[0]->AppendItem("Exit", 10105);

m[1] = new PIPDMenu((PIMsgHandler *)Menubar(),"Visual.");
m[1]->AppendItem("Lut...", 10221);
m[1]->AppendItem("Size*1", 10211);
m[1]->AppendItem("Expand*2", 10212);
m[1]->AppendItem("Compress*2", 10208);
m[1]->AppendItem("Expand*4", 10214);
m[1]->AppendItem("Compress*4", 10206);
m[1]->AppendItem("CursorOFF", 10231);
m[1]->AppendItem("CursorON", 10232);
m[1]->AppendItem("PrintLut", 10222);

m[2] = new PIPDMenu((PIMsgHandler *)Menubar(),"Ope.Image");
m[2]->AppendItem("UserProc-1", 10301);
m[2]->AppendItem("UserProc-2", 10302);
m[2]->AppendItem("UserProc-3", 10303);
m[2]->AppendItem("PixelHisto", 10331);
m[2]->AppendItem("Info (dyn)", 10332);

m[3] = new PIPDMenu((PIMsgHandler *)Menubar(),"Ope.Pave");
m[3]->AppendItem("Extract", 10401);
m[3]->AppendItem("Coupe", 10410);
m[3]->AppendItem("Fit-PSF", 10420);
m[3]->AppendItem("PixelHisto", 10431);
m[3]->AppendItem("Print", 10432);

m[4] = NULL;

AppendMenu(m[0]);
AppendMenu(m[1]);   
AppendMenu(m[2]);
AppendMenu(m[3]);


zoom = new PIPixmap(this->MainWin(), "Zoom", 140,140,10,20);

mTlb[0] = new PILabel(this->MainWin(), "Img: ", 40, 25, 5, 200);
labimg = new PILabel(this->MainWin(), "PixelValue", 345, 25, 50, 200);
labimg->SetLabel("");
mTlb[1] = new PILabel(this->MainWin(), "Drw: ", 40, 25, 5, 170);
labdrw = new PILabel(this->MainWin(), "Coord", 140, 25, 50, 170);
labdrw->SetLabel("");

lab = NULL;
// lab =  new PILabel(this->MainWin(), "State", 60, 20, 150, 10);
// lab->SetBorderWidth(1);
 

pfc = new PIFileChooser(this,"FileChooser", 5000); 
if (path)
  pfc->SetPath(path);

mVisTC = new VisuTools(this, this->MainWin());
mCutTC = new CutTools(this, this->MainWin());

mVisTC->Show();
mTCId = 1;

mLutw = new LutWind(this);
mUP = new UserProcWind(this);
mOptw = new OptionWind(this);

SetReady();
}

/* --Methode-- */
PIDemoApp::~PIDemoApp()
{
int i;
for(i=0; i<5; i++)  delete m[i];

delete lab;

for(i=0; i<mNwin; i++)
  delete awp[i];

delete zoom;
delete labimg;
delete labdrw;
delete mTlb[0]; 
delete mTlb[1]; 

delete pfc;
delete mVisTC;
delete mCutTC;

delete mLutw;
delete mUP;
delete mOptw;

}  

/* --Methode-- */
void PIDemoApp::Process(long msg, PIMsgHandler* sender, void* data)
{
PIWdg *sndw;

if  ((GetState()) && (msg > 9999)) { PIBeep(); return; }

if ( (msg >= 5100) && (msg < 5200) )    MBProcess1(msg, sender, data);
else if ( (msg >= 10100) && (msg < 10200) )  MBProcess1(msg, sender, data);
else if ( (msg >= 10200) && (msg < 10300) )  MBProcess2(msg, sender, data);
else if ( (msg >= 10300) && (msg < 10400) )  MBProcess3(msg, sender, data);
else if ( (msg >= 10400) && (msg < 10500) )  MBProcess4(msg, sender, data);
else if (msg == PIMsg_ActiveWdg)
  {
  sndw = (PIWdg *)sender;
  switch(sndw->kind())
    {
    case PIWindow::ClassId :
      mCurWin = (PIWindow *)sender;
      break;
    case PIImage::ClassId :
      mCurPII = (PIImage *)sender;
      break;
    }
  }
else printf("PIDemoApp::Process() BUG?? Msg %d  \n", (int)msg);

/*   Changement palette outil  */

if (msg != 10410)   
  {
  if (mTCId != 1)  { mCutTC->Hide();  mVisTC->Show();  mTCId = 1; }
  }

return;
}

/* --Methode-- */
void PIDemoApp::MBProcess1(long msg, PIMsgHandler* /*sender*/, void* data)
{

  switch(msg)
    {
    case 10110:
      SetBlocked();
      mOptw->Show();
      break;

    case 10101 :
      pfc->AcceptNewFile(false); 
      pfc->SetMsg(5101);
      SetBlocked();
      pfc->Show();
      break;

    case 10102 :
      CloseCurrent();
      break;
        
    case 10103 :
      pfc->AcceptNewFile(true); 
      pfc->SetMsg(5103);
      SetBlocked();
      pfc->Show();
      break;

    case 10104:
      SetBusy();
      DynLink(true);
      SetReady();
      break;

    case 10105:
      Stop();
      break;

    case 5101 :
      SetBusy();
      if (data)  OpenImage(pfc->GetFileName());
      SetReady();
      break;

    case 5103 :
      SetBusy();
      if (data)  SaveCurrentImg(pfc->GetFileName());
      SetReady();
      break;      
  }
return;
}

/* --Methode-- */
void PIDemoApp::MBProcess2(long msg, PIMsgHandler* /*sender*/, void* /*data*/)
{
int snx,sny,sx,sy,zm,wt;

if (CurrentPIImage() == NULL) return;
wt = GetCurrentWType();
if ( (wt<1) || (wt>9) ) return;

switch (msg)
  {
  case 10221 :
    mLutw->Show();
    break;

  case 10222 :
    CurrentPIImage()->Lut()->Print();
    break;

  case 10231 :
    CurrentPIImage()->ShowCursor(false);
    break;

  case 10232 :
    CurrentPIImage()->ShowCursor(true);
    break;

  case 10211 :
  case 10212 :
  case 10214 :
  case 10208 :
  case 10206 :
    SetBusy();
    if (wt > 3) return;
    zm = msg-10210;
    CurrentPIImage()->SetZoom(zm, false);
    sx = CurrentWindow()->XSize();
    sy = CurrentWindow()->YSize();
    if (zm > 0)
      {
      snx = CurrentImage()->XSize()*zm;
      sny = CurrentImage()->YSize()*zm;
      }
    else 
      {
      snx = CurrentImage()->XSize()/(-zm);
      sny = CurrentImage()->YSize()/(-zm);
      }
    if ((snx != sx) || (sny != sy))
      {
      CurrentPIImage()->SetOffset(0, 0, false);
      CurrentWindow()->SetSize(snx, sny);
      }
    else   CurrentPIImage()->SetOffset(0, 0);
    SetReady();
    break;

  default:
    printf("PIDemoApp::MBProcess2() BUG?? Msg %d  \n", (int)msg);    
    break;

  }

       
}

/* --Methode-- */
void PIDemoApp::MBProcess3(long msg, PIMsgHandler* /*sender*/, void* /*data*/)
{
ImageR4 * pim;
Histo * pixelhis;
float xmn, xmx, vmn, vsg; 
int k;

if (CurrentPIImage() == NULL) return;

switch (msg)
  {
  case 10301:
  case 10302:
  case 10303:
    mUP->SelectUP(msg-10300);
    mUP->Show();
  break;
      
  case 10331:
    SetBusy();
    pim = (ImageR4 *)CurrentImage();
    if (his_ckd)
      {
      pim->MoySigma(vmn, vsg, his_min, his_max, 5);
//    pim->Print();
      xmn = vmn-4.*vsg;  xmx = vmn+4.*vsg;
      if (xmn < his_min) xmn = his_min;
      if (xmx > his_max) xmx = his_max;
      }
    else { xmn=his_min;  xmx = his_max; }
    if ((xmx-xmn) < 1.e-6)  xmx = xmn+1.e-3;
    pixelhis = new Histo(xmn, xmx, his_nbin); 
    for (k=0; k<pim->XSize()*pim->YSize(); k++)
      pixelhis->Add((*pim)[k]);
    AddHisto(pixelhis);
    SetReady();
    break;

  case 10332:
    SetBusy();
    printf("\n --- Info (Dynamique) de l'image %s ---- \n", 
           CurrentPIImage()->Nom().c_str());
    CurrentImage()->CheckDyn((double)mdynccd->MinADU, (double)mdynccd->MaxADU);
    CurrentImage()->Print();
    SetReady();
    break;

  default:
    printf("PIDemoApp::MBProcess3() BUG?? Msg %d  \n", (int)msg);    
    break;

  }

}

/* --Methode-- */
void PIDemoApp::MBProcess4(long msg, PIMsgHandler* /*sender*/, void* /*data*/)
{
ImageR4 * pim;
Histo * pixelhis;
float xmn, xmx, vmn, vsg; 
int zm, k;
int dx, dy;
float xc, yc;
char strg[128];
string s;
bool keep=false;

if (CurrentPIImage() == NULL) return;

if (rect_pav)
  {
  dx = CurrentPIImage()->XSzPave();
  dy = CurrentPIImage()->YSzPave();  
  }
else  { dx = dy = pav_sz; }

xc = CurrentPIImage()->XPave()+0.5;
yc = CurrentPIImage()->YPave()+0.5;

pim = NULL;
pim = new ImageR4(dx, dy);
keep = false;
CopiePave((ImageR4 &)(*pim), (ImageR4 &)(*CurrentImage()), xc, yc);

switch (msg)
  {
  case 10401:
    sprintf(strg,"P(%d,%d)%s",CurrentPIImage()->XPave(),
            CurrentPIImage()->YPave(),CurrentPIImage()->Nom().c_str());
    strg[32] = '\0';
    zm = vis_zoom+1;
    if (zm == 0)  zm = 1;
    AddImage(pim, strg, zm);
    keep = true;   
    break;
      
  case 10410:
    if (mTCId != 2)  { mVisTC->Hide();  mCutTC->Show();  mTCId = 2; } 
    break;

  case 10420:
    SetBusy();
    keep = FitPSF_Res(pim);
    SetReady();
    break;

  case 10431:
    SetBusy();
    if (his_ckd)
      {
      pim->MoySigma(vmn, vsg, his_min, his_max, 2);
//    pim->Print();
      xmn = vmn-4.*vsg;  xmx = vmn+4.*vsg;
      if (xmn < his_min) xmn = his_min;
      if (xmx > his_max) xmx = his_max;
      }
    else { xmn=his_min;  xmx = his_max; }
    if ((xmx-xmn) < 1.e-6)  xmx = xmn+1.e-3;
    pixelhis = new Histo(xmn, xmx, his_nbin); 
    for (k=0; k<pim->XSize()*pim->YSize(); k++)
      pixelhis->Add((*pim)[k]);
    AddHisto(pixelhis);
    SetReady();
    break;

  case 10432:
    SetBusy();
    pim->CheckDyn((double)mdynccd->MinADU, (double)mdynccd->MaxADU);
    printf("\n --- Pave en (%d,%d) de l'image %s ---- \n", 
           CurrentPIImage()->XPave(), CurrentPIImage()->YPave(),
           CurrentPIImage()->Nom().c_str());
     if (prt_pval) 
      pim->PrintImage(); 
    else pim->Print();
    SetReady();
    break;

  default:
    printf("PIDemoApp::MBProcess4() BUG?? Msg %d  \n", (int)msg);    
    break;

  }

if (!keep) delete pim;
return;
}

/* --Methode-- */
bool PIDemoApp::FitPSF_Res(ImageR4 *pim)
{
ImageR4 *nois, *resid, *pav;
PIImage *pii[2];
PILabel *lab[2];
PIWindow *win;
int rc;

if (pim == NULL)  return(false);

nois = resid = pav = 0;
if(typ_psf<1 || typ_psf>4) typ_psf = 1;
PSF mypsf(typ_psf,100.0);

TIMEF
printf("\n -------- Resultat PIDemoApp::FitPSF_Res() ----------- \n"); 

pav = pim;
nois = NoiseImage(pav, mdynccd);
PSFStar mypsfstar(&mypsf);
rc = mypsfstar.IniFit(*pav, *nois);
if(rc!=0)
  {
  printf("PIDemoApp::FitPSF_Res(), Echec IniFit (rc= %d) \n", rc);
  delete nois;  return(false); 
  }
rc = mypsfstar.Fit(*pav, *nois);
if(rc!=0)
  {
  printf("PIDemoApp::FitPSF_Res(), Echec Fit (rc= %d) \n", rc);
  delete nois;  return(false); 
  }

mypsfstar.Print(2);

float smax,axisrat,tiltdeg;
rc = paramga((float) mypsfstar.SigX(),(float) mypsfstar.SigY()
            ,(float) mypsfstar.Rho(),&smax,&axisrat,&tiltdeg);
if(rc==0) 
  printf("...   sa=%g sb=%g (%g) teta=%g\n",
         smax,smax*axisrat,axisrat,tiltdeg);
else puts("Erreur paramga ");

resid = new ImageR4(pav->XSize(), pav->YSize());
CopieImage((ImageR4 &)(*resid), (ImageR4 &)(*pav));
*resid -= mypsfstar;

SPLITTIME

char strg[256];
sprintf(strg, "FitPSF Pave[%d %d]_%s" ,CurrentPIImage()->XPave(),
            CurrentPIImage()->YPave(),CurrentPIImage()->Nom().c_str());

if ((win=GetWindow(340,230,9,strg)) == NULL)  
  { delete nois; delete resid; 
  return(false); }

lab[0] = new PILabel(win, "Info1", 330, 25, 5, 5);
sprintf(strg,"Sx= %5.2f Sy= %5.2f Rho=%4.2f Xi2Fit= %g",
        (float)mypsfstar.SigX(),(float) mypsfstar.SigY(),
        (float)mypsfstar.Rho(), mypsfstar.Xi2());
lab[0]->SetLabel((string)strg);
lab[1] = new PILabel(win, "Info2", 330, 25, 5, 35);
sprintf(strg,"Sa= %5.2f Sb= %5.2f Tet= %5.1f deg",
        smax, smax*axisrat, tiltdeg);
lab[1]->SetLabel((string)strg);

int zm;
zm = 150/pav->XSize();
if (zm < 1) zm = 1;

else zm++;

for(int i=0; i<2; i++)
  {
  pii[i] = new PIImage(win, "Pave", 160, 160, 5+170*i, 65);
  pii[i]->SetBinding(true, true, true, true);
  pii[i]->SetZoomWin(zoom);
  pii[i]->SetTextWin(labimg);
  pii[i]->SetZoom(zm, false);
  pii[i]->SetAutoDelImage(true);
  pii[i]->ShowCursor(false);
  }

pii[0]->SetImage(pav);
pii[1]->SetImage(resid);

delete nois;
return(true);
}



/* --Methode-- */
void PIDemoApp::OpenImage(string const & flnm)
{
char buff[128];
char * pn;
int i,j,k;
bool ok = true;
FitsImageR4 * myimg;

TIMEF

if (mNwin >= NMXWIN)
  {
  printf("PIDemoApp::OpenImage_Error Two many images (%d) opened ...\n",mNwin);
  printf("   Close some of the images ... ");
  return;
  }

pn = (char *)flnm.c_str();
printf("PIDemoApp::OpenImage Opening file %s \n", pn);

if ((k=strchr(pn, '.')-pn) < 0)  k = strlen(pn);
k--;
if (k < 0)  {printf("PIDemoApp::OpenImage_Error \n"); return;}

for(j=k; j>=0; j--)
  if (pn[j] == FILESEP)  break;
for(i=j+1; i<=k; i++)  buff[i-j-1] = pn[i];  
buff[i-j-1] = '\0';
printf("PIDemoApp::OpenImage ImageName= %s \n", buff);

TRY{
  myimg = new FitsImageR4();
  myimg->Read(flnm);
}  CATCH(merr) 
  { printf("PIDemoApp::OpenImage_Error Exception= %d (%s) \n", merr, PeidaExc(merr)); 
  ok = false; } ENDTRY;
if (ok)
  {
  string s(buff);
  AddImage(myimg, s, 0, 1);
  }
}

/* --Methode-- */
void PIDemoApp::AddImage(ImageR4 * nouv, string const & name, int zm, int typ)
{
PIImage *pii;
int sx, sy;

if (nouv == NULL)
  {
  printf("PIDemoApp::AddImage_Error  Cannot Add NULL image \n");
  return;
  }
if (mNwin >= NMXWIN)
  {
  printf("PIDemoApp::AddImage_Error Too many (%d) opened windows...\n",mNwin);
  printf("   Close some of the windows ... ");
  return;
  }

if ( (nouv->XSize() <= 0)  || (nouv->YSize() <= 0))
  {
  printf("PIDemoApp::AddImage_Error Pb lecture (FitsImage::Read ?) \n");
  return;
  }

if (zm == 0)  zm = vis_zoom;
sx = nouv->XSize()*zm;  sy = nouv->YSize()*zm;
if (sx > 512) sx = 512;
if (sy > 512) sy = 512;

awp[mNwin] = new PIWindow(this, (char *)name.c_str(), PIWK_normal, 
                          sx, sy, 200, 200);
pii = new PIImage(awp[mNwin], (char *)name.c_str(), sx, sy, 0, 0);
pii->SetBinding(true, true, true, true);
pii->SetZoomWin(zoom);
pii->SetTextWin(labimg);
pii->SetZoom(zm, false);
pii->SetAutoDelImage(true);
pii->ShowCursor(vis_cursshow);
pii->SetImage(nouv);
awp[mNwin]->SetAutoDelChilds(true);
awp[mNwin]->Show();
if ((typ < 0) || (typ > 9)) typ = 3;
taw[mNwin] = typ;
mNwin++;  mTnw++;
return; 
}


/* --Methode-- */
void PIDemoApp::AddHisto(Histo *h)
{
PIDrawWindow *  draw = NULL;
PIHisto *pih;
char strg[64];

if (h == NULL)
  {
  printf("PIDemoApp::AddHisto_Error  Cannot Add NULL Histo \n");
  return;
  }
if (mNwin >= NMXWIN)
  {
  printf("PIDemoApp::AddHisto_Error Too many (%d) opened windows...\n",mNwin);
  printf("   Close some of the windows ... ");
  return;
  }

mTnw++;
sprintf(strg,"Histo (W %d)",mTnw);
draw = new PIDrawWindow(this, strg, PIWK_normal, 300, 300, 300, 300);
pih = new PIHisto(h);
pih->SetAutoDelHisto(true);
draw->AddDrawer(pih);
draw->DrawWdg()->SetTextWin(labdrw);
awp[mNwin] = draw;
draw->Show();
draw->SetAutoDelChilds(true);
taw[mNwin] = 10;
mNwin++; 
return; 
}


/* --Methode-- */
void PIDemoApp::CloseCurrent()
{
int n;
if ((n=GetNumCurrent()) < 0)  return;
if ((taw[n] > 0) && (taw[n] < 10))
  {
  zoom->SetPixmap(NULL,0,0);
  zoom->EraseWindow();
  labimg->SetLabel("");
  mCurPII = NULL;
  }
else if ((taw[n] > 9) && (taw[n] < 20))
  labdrw->SetLabel("");

awp[n]->Hide();
delete awp[n];
awp[n] = awp[mNwin-1];
taw[n] = taw[mNwin-1];
mNwin--;
mCurWin = NULL;
return;
}

/* --Methode-- */
void PIDemoApp::SaveCurrentImg(string const & flnm)
{
FitsImageR4 *pim = NULL;
bool fgcr=false;

if (CurrentImage() == NULL)  return;
if (strlen(flnm.c_str()) <= 0) 
  { 
  printf("PIDemoApp::SaveCurrent_Error: bad filename (%s) \n", flnm.c_str());
  return;
  }

printf("PIDemoApp::SaveCurrent: Image %s saved to %s \n", 
       (char *)CurrentPIImage()->Nom().c_str(), (char *)flnm.c_str());
/*  $CHECK$ Ca ne marche pas ??? pb avec IsFits()
if (CurrentImage()->IsFits())  */    
if (GetCurrentWType() == 1)
  { pim = (FitsImageR4 *) CurrentImage(); 
  fgcr = false; }
else 
  { pim = new FitsImageR4(*CurrentImage(),1); 
  fgcr = true; }


TRY {
  pim->Save(flnm); 
}  CATCH(merr) 
  { 
  printf("PIDemoApp::SaveCurrent_Error Exception= %d (%s) \n", merr, PeidaExc(merr));  
  if (fgcr) { delete pim; fgcr=false; } 
  } ENDTRY;

if (fgcr)  delete pim;
return;
}

/* --Methode-- */
int PIDemoApp::GetNumCurrent()
{
int n=-1;
if (mNwin <= 0)  return(-1);
for(int i=0; i<mNwin; i++)
  if (mCurWin == awp[i])  { n = i; break; }

if (n < 0)  
  printf(" PIDemoApp::GetNumCurrent() Current Window not found (%lx)\n",(long)mCurWin);

return(n);  
}

/* --Methode-- */
int PIDemoApp::GetCurrentWType()
{
int k;
k = GetNumCurrent();
if (k < 0)  return(0);
else return(taw[k]); 
}

/* --Methode-- */
ImageR4 * PIDemoApp::CurrentImage()
{
if (mCurPII == NULL)  return(NULL);
return((ImageR4 *)mCurPII->Image());
}

/* --Methode-- */
PIWindow * PIDemoApp::GetWindow(int sx, int sy, int typ, char * nom)
{
PIWindow * win = NULL;

if (mNwin >= NMXWIN)
  {
  printf("PIDemoApp::GetWindow_Error Too many (%d) opened windows...\n",mNwin);
  printf("   Close some of the windows ... ");
  return(win);
  }

awp[mNwin] = new PIWindow(this, nom, PIWK_normal,
                          sx, sy, 250, 250);
awp[mNwin]->SetAutoDelChilds(true);
taw[mNwin] = typ;
win = awp[mNwin];
win->Show();
mNwin++; 
return(win);
}



/* ........................................................... */
/*       Classe VisuTools  (Controle de visualisation)         */
/* ........................................................... */

VisuTools::VisuTools(PIDemoApp *par, PIContainer *pw)
: PIContainer(pw, "visutools", 200, 160, 185, 5)
{
dap = par;
mTlb = new PILabel(this, "VisuTools", 100, 25, 50, 5); 

mOlb[0] = new PILabel(this, "AutoLut :", 70, 25, 5, 45);
mPum[0] = new PIPUMenu((PIMsgHandler *)this, "AutoLut");
mPum[0]->AppendItem("+3 Sig", 303);
mPum[0]->AppendItem("+2 Sig", 302);
mPum[0]->AppendItem("+1 Sig", 301);
mPum[0]->AppendItem("-1 Sig", 299);
mPum[0]->AppendItem("-2 Sig", 298);
mOpt[0] = new PIOptMenu(this, mPum[0], 90, 25, 80, 45);
mOpt[0]->SetValue(302);

mOlb[1] = new PILabel(this, "Zoom :", 70, 25, 5, 85);
mPum[1] = new PIPUMenu((PIMsgHandler *)this, "Zoom");
mPum[1]->AppendItem("Agr. * 8", 108);
mPum[1]->AppendItem("Agr. * 6", 106);
mPum[1]->AppendItem("Agr. * 5", 105);
mPum[1]->AppendItem("Agr. * 4", 104);
mPum[1]->AppendItem("Agr. * 3", 103);
mPum[1]->AppendItem("Agr. * 2", 102);
mPum[1]->AppendItem("* 1", 101);
mPum[1]->AppendItem("Red. / 2", 98);
mPum[1]->AppendItem("Red. / 3", 97);
mPum[1]->AppendItem("Red. / 4", 96);
mPum[1]->AppendItem("Red. / 5", 95);
mPum[1]->AppendItem("Red. / 6", 94);
mPum[1]->AppendItem("Red. / 8", 92);
mOpt[1] = new PIOptMenu(this, mPum[1], 90, 25, 80, 85);
mOpt[1]->SetValue(101);

mOlb[2] = new PILabel(this, "ColMap :", 70, 25, 5, 125);
mPum[2] = new PIPUMenu((PIMsgHandler *)this, "ColMap");
mPum[2]->AppendItem("Grey32", 201);
mPum[2]->AppendItem("GreyInv32", 202);
mPum[2]->AppendItem("ColRJ32", 203);
mPum[2]->AppendItem("ColBR32", 204);
mPum[2]->AppendItem("ColRV32", 205);
mOpt[2] = new PIOptMenu(this, mPum[2], 90, 25, 80, 125);
mOpt[2]->SetValue(203);

FinishCreate();
}


/* --Methode-- */
VisuTools::~VisuTools()
{

delete mTlb;
for(int i=0; i<3; i++)
  {
  delete mOpt[i];
  delete mPum[i];
  delete mOlb[i];
  }
}

/* --Methode-- */
void VisuTools::Process(long msg, PIMsgHandler* /*sender*/, void* /*data*/)
{
CMapId cmap[5] = { CMAP_GREY32, CMAP_GREYINV32, CMAP_COLRJ32, 
                   CMAP_COLBR32, CMAP_COLRV32 } ;

if (dap->CurrentPIImage() == NULL)  return;
dap->SetBusy();
if ((msg < 110) && (msg > 90))  // Zoom
  dap->CurrentPIImage()->SetZoom((int)(msg-100));
else if ((msg > 200) && (msg < 206)) // Changement de couleur 
  dap->CurrentPIImage()->SetColMap(cmap[msg-201]);
else if ((msg > 290) && (msg < 310))
  dap->CurrentPIImage()->SetLut( dap->CurrentImage()->minPix, dap->CurrentImage()->maxPix,
                                 kLutType_Lin, msg-300);
dap->SetReady();
return;
}


/* ........................................................... */
/*           Classe CutTools  (Controle de coupe)              */
/* ........................................................... */

/* --Methode-- */
CutTools::CutTools(PIDemoApp *par, PIContainer *pw)
: PIContainer(pw, "cuttools", 200, 160, 185, 5)
{
int i;

dap = par;

mOlb = new PILabel(this, "Coupe:", 70, 25, 5, 5);
mPum = new PIPUMenu((PIMsgHandler *)this, "Coupe");
mPum->AppendItem("H-V", 101);
mPum->AppendItem("Diagonal", 102);
mOpt = new PIOptMenu(this, mPum, 90, 25, 80, 5);
mOpt->SetValue(101);

mBut[0] = new PIButton(this, "Y-", 501, 30, 25, 85, 60);
mBut[1] = new PIButton(this, "Y+", 502, 30, 25, 85, 120);
mBut[2] = new PIButton(this, "X-", 503, 30, 25, 50, 90);
mBut[3] = new PIButton(this, "X+", 504, 30, 25, 120, 90);

fgpb = true;
fgdiag = false;

for(i=0; i<2; i++)
  { mDrw[i] = NULL;  mPIH[i] = NULL; }
 
FinishCreate();

}


/* --Methode-- */
CutTools::~CutTools()
{
int i;

for(i=0; i<4; i++)  delete mBut[i];
delete mOpt;
delete mPum;
delete mOlb;
}

/* --Methode-- */
void CutTools::Show()
{
PIWindow *win;

PIContainer::Show();
fgpb = true;

if (dap->CurrentPIImage() == NULL) return;
if (dap->CurrentImage() == NULL) return;

mPx = dap->CurrentPIImage()->XPave();
mPy = dap->CurrentPIImage()->YPave();
if (rect_pav)
  {
  mDx = dap->CurrentPIImage()->XSzPave();
  mDy = dap->CurrentPIImage()->YSzPave();
  }
else  { mDx = mDy = pav_sz; }
if( mDx%2 == 0 ) mDx++; 
if( mDy%2 == 0 ) mDy++;
mDxy = ( mDx > mDy ) ? mDx : mDy;


char strg[128];
sprintf(strg, "Coupe Pave_%s" ,dap->CurrentPIImage()->Nom().c_str());

if ((win=dap->GetWindow(600,330,12,strg)) == NULL)  
  { fgpb=true;  return; }
mLab = new PILabel(win, "infc", 590, 25, 5, 5);
for(int i=0; i<2; i++)
  {
  mDrw[i] = new PIScDrawWdg(win, "Coupe", 300, 300, 300*i, 30);
  mPIH[i] = NULL;
  }  
fgpb = false;
FillHistos();
return;
}


/* --Methode-- */
void CutTools::Process(long msg, PIMsgHandler* /*sender*/, void* /*data*/)
{
if ((fgpb) || (dap->CurrentPIImage() == NULL))
  {  printf("CutTools::Process, Msg= %d , --PB--\n", (int)msg);
  return; }


switch(msg)
  {
  case 101:
    if (fgdiag)
      { fgdiag = false;   FillHistos(); }
    break;

  case 102:
    if (!fgdiag)
      { fgdiag = true;   FillHistos(); }
    break;

  case 501:
  case 502:
  case 503:
  case 504:
    switch(msg)
      {
      case 501:
        mPy--;
        break;
      case 502:
        mPy++;
        break;
      case 503:
        mPx--;
        break;
      case 504:
        mPx++;
        break;
      }
    dap->CurrentPIImage()->SetPave(mPx, mPy);  
    mPx = dap->CurrentPIImage()->XPave();
    mPy = dap->CurrentPIImage()->YPave();
    FillHistos();
    break;

  default:
    printf("CutTools::Process/BUG ??? Msg = %d \n", (int)msg);
    break;
  }
return;
}

/* --Methode-- */
void CutTools::FillHistos()
{
int i;
int xp,yp;
int dx,dy,dxy;
Histo * his[2];
float xmin,xmax;
int ip,jp,imax,jmax;
ImageR4 *myimg;
char buff[256];
char *txt[2] = {"H-V ","Diag"};

xp = mPx; yp = mPy;
dx = mDx; dy = mDy;  dxy = mDxy;

myimg = dap->CurrentImage();

/*  Recherche du pixel maxi  */
imax = xp;
jmax = yp;
xmax = (float) (*myimg)(imax,jmax);
for(i=0;i<dx;i++) {
  ip = xp -(dx-1)/2 + i;
  if( ip < 0 || ip >= myimg->XSize() ) continue;
  for(int j=0;j<dy;j++) {
    jp = yp -(dy-1)/2 + j;
    if( jp < 0 || jp >= myimg->YSize() ) continue;
    if( (float) (*myimg)(ip,jp) < xmax ) continue;
    imax = ip;
    jmax = jp;
    xmax = (float) (*myimg)(imax,jmax);
  }
}

i = (fgdiag) ? 1 : 0;
sprintf(buff,"Coupe %s en (%d %d) PixMax= %g en (%d %d)", 
        txt[i], xp, yp, xmax, imax, jmax);
mLab->SetLabel((string)buff);

for(i=0; i<2; i++)  delete mPIH[i];

if (!fgdiag)   // Histos H-V
  {
  xmin = (float) (xp - (dx-1)/2) - 0.5;
  xmax = (float) (xp + (dx-1)/2) + 0.5;
  his[0] = new Histo(xmin,xmax,dx);
  xmin = (float) (yp - (dy-1)/2) - 0.5;
  xmax = (float) (yp + (dy-1)/2) + 0.5;
  his[1] = new Histo(xmin,xmax,dy);

  for(i=0;i<dx;i++) {
    ip = xp -(dx-1)/2 + i;
    if( ip < 0 || ip >= myimg->XSize() ) continue;
    his[0]->Add((float) ip,(float) (*myimg)(ip,yp));
    }
  for(i=0;i<dy;i++) {
    ip = yp -(dy-1)/2 + i;
    if( ip < 0 || ip >= myimg->YSize() ) continue;
    his[1]->Add((float) ip,(float) (*myimg)(xp,ip));
    }  
  }
else    // Histo diagonals....
  {
  xmin = (float) -(dxy-1)/2 - 0.5;
  xmax = (float)  (dxy-1)/2 + 0.5;
  his[0] = new Histo(xmin,xmax,dxy);
  his[1] = new Histo(xmin,xmax,dxy);
  for(i=0;i<dxy;i++) {
    ip = xp -(dxy-1)/2 + i;
    jp = yp -(dxy-1)/2 + i;
    if( ip < 0 || ip >= myimg->XSize() ) continue;
    if( jp >= 0 && jp < myimg->YSize() )
           his[0]->Add((float) ip-xp,(float) (*myimg)(ip,jp));
    jp = yp +(dxy-1)/2 - i;
    if( jp >= 0 && jp < myimg->YSize() )
           his[1]->Add((float) ip-xp,(float) (*myimg)(ip,jp));
    }
  
  }
for(i=0; i<2; i++)
  {
  mPIH[i] = new PIHisto(his[i]);
  mPIH[i]->SetAutoDelHisto(true);
  mDrw[i]->AddDrawer(mPIH[i]);
  mDrw[i]->SetTextWin(dap->DrawLabelWdg());
  mPIH[i]->Refresh();
  }

return;
}

/* ........................................................... */
/*       Classe LutWind  (Changement de Lut d'image)           */
/* ........................................................... */

/* --Methode-- */
LutWind::LutWind(PIDemoApp *par)
: PIWindow((PIMsgHandler *)par, "ChangeLut", PIWK_dialog, 240, 220, 150, 150)
{
dap = par;

mLab[0] = new PILabel(this, "MinPixel", 60, 30, 30, 20); 
mLab[1] = new PILabel(this, "MaxPixel", 60, 30, 30, 60); 

mText[0] = new PIText(this, "MinVal", 100, 30, 110, 20);
mText[0]->SetText("1");
mText[1] = new PIText(this, "MaxVal", 100, 30, 110, 60);
mText[1]->SetText("32000");

mOlb[0] = new PILabel(this, "LutType", 60, 25, 30, 100); 
mPum[0] = new PIPUMenu((PIMsgHandler *)this, "LutType");
mPum[0]->AppendItem("Linear", 1100);
mPum[0]->AppendItem("Log.", 1101);
mOpt[0] = new PIOptMenu(this, mPum[0], 100, 25, 110, 100);
mOpt[0]->SetValue(1100);

mOlb[1] = new PILabel(this, "AutoLut", 60, 25, 30, 135); 
mPum[1] = new PIPUMenu((PIMsgHandler *)this, "AutoLut");
mPum[1]->AppendItem("+3 Sig", 1203);
mPum[1]->AppendItem("+2 Sig", 1202);
mPum[1]->AppendItem("+1 Sig", 1201);
mPum[1]->AppendItem("NoAuto", 1200);
mPum[1]->AppendItem("-1 Sig", 1199);
mPum[1]->AppendItem("-2 Sig", 1198);
mPum[1]->AppendItem("-3 Sig", 1197);
mOpt[1] = new PIOptMenu(this, mPum[1], 100, 25, 110, 135);
mOpt[1]->SetValue(1202);

mBut[0] = new PIButton(this, "Apply", 1500, 70, 30, 30, 170);
mBut[1] = new PIButton(this, "Dismiss", 1600, 70, 30, 140, 170);

FinishCreate();
}

/* --Methode-- */
LutWind::~LutWind()
{
for(int i=0; i<2; i++)
  {
  delete mLab[i];
  delete mBut[i];
  delete mText[i];
  delete mOpt[i];
  delete mPum[i];
  delete mOlb[i];
  }
}
/* --Methode-- */
void LutWind::Show()
{
char buff[32];
PIImage *mpii;
mpii = dap->CurrentPIImage();
if (mpii == NULL)  return;
sprintf(buff,"%g", (mpii->Lut())->Min());
mText[0]->SetText(buff);
sprintf(buff,"%g", (mpii->Lut())->Max());
mText[1]->SetText(buff);
if ( (mpii->Lut())->Type() == kLutType_Lin ) 
  mOpt[0]->SetValue(1100);
else mOpt[0]->SetValue(1101);
string s("NoAuto");
mOpt[1]->SetValueStr(s);
dap->SetBlocked();
PIWindow::Show();
return;
}


/* --Methode-- */
void LutWind::Process(long msg, PIMsgHandler* /*sender*/, void* /*data*/)
{
float min, max;
int lauto, typ;
int typlut[2] = {kLutType_Lin, kLutType_Log} ; 

switch (msg)
  {
  case 1600:
    dap->SetReady();
    this->Hide();
    break;
  case 1500:
    if (dap->CurrentPIImage() == NULL)  return;
    min = atof(mText[0]->GetText().c_str());
    max = atof(mText[1]->GetText().c_str());
    lauto = mOpt[1]->GetValue() - 1200;
    typ = mOpt[0]->GetValue() - 1100;
    if ( (typ < 0) || (typ > 1) )  typ = 0;
    (dap->CurrentPIImage())->SetLut(min, max, typlut[typ], lauto);
//    ((dap->CurrentPIImage())->Lut())->Print();
    break;
  default:
//    printf("LutWind::Process Msg %d received \n", (int)msg);
    break;
  }
}


/* ........................................................... */
/*       Classe UserProcWindow  (Appel UserProc Function)      */
/* ........................................................... */


/* --Methode-- */
UserProcWind::UserProcWind(PIDemoApp *par)
: PIWindow((PIMsgHandler *)par, "UserProc", PIWK_dialog, 260, 200, 150, 150)
{
dap = par;
mUpr = 0;

mLab[0] = new PILabel(this, "OutImageName:", 100, 35, 20, 10); 
mLab[1] = new PILabel(this, "UserArg(1):", 100, 35, 20, 55);
mLab[2] = new PILabel(this, "UserArg(2):", 100, 35, 20, 100);
 
mText[0] = new PIText(this, "OutName", 130, 35, 120, 10);
mText[0]->SetText("ImgOut");
mText[1] = new PIText(this, "UserArg1", 130, 35, 120, 55);
mText[1]->SetText("");
mText[2] = new PIText(this, "UserArg2", 130, 35, 120, 100);
mText[2]->SetText("");

mBut[0] = new PIButton(this, "Process", 2500, 70, 30, 30, 160);
mBut[1] = new PIButton(this, "Cancel", 2600, 70, 30, 160, 160);
FinishCreate();

}

/* --Methode-- */
UserProcWind::~UserProcWind()
{
for(int i=0; i<3; i++)
  {
  delete mLab[i];
  delete mText[i];
  }

delete mBut[0]; 
delete mBut[1]; 
}

/* --Methode-- */
void UserProcWind::Show()
{
dap->SetBlocked();
PIWindow::Show();
return;
}


/* --Methode-- */
void UserProcWind::Process(long msg, PIMsgHandler* /*sender*/, void* /*data*/)
{
ImageR4 *mimg, *oimg;
int xp, yp, dx, dy;

switch (msg)
  {
  case 2600:
    this->Hide();
    dap->SetReady();
    break;

  case 2500:
    if ((mUpr < 1) || (mUpr > 3))  mUpr=1;
    if (userFunc[mUpr-1] == NULL)
      { printf("UserProcWind::Process()/Warning: pas de UserProcFunc%d \n", mUpr);
      this->Hide(); dap->SetReady(); return; }
    mimg = dap->CurrentImage();
    if (mimg == NULL)  return;
    xp = (dap->CurrentPIImage())->XPave();
    yp = (dap->CurrentPIImage())->YPave();
    dx = (dap->CurrentPIImage())->XSzPave();
    dy = (dap->CurrentPIImage())->YSzPave();
    this->Hide();
    dap->SetBusy();
    oimg = NULL;
    switch (mUpr)
      {
      case 1 :
      case 2 :
      case 3 :
        oimg = userFunc[mUpr-1] (mimg, xp, yp, dx, dy,
                            (char *) (mText[1]->GetText().c_str()), 
                            (char *) (mText[2]->GetText().c_str()));
        break;
      }    
    if (oimg)  dap->AddImage(oimg,mText[0]->GetText());
    dap->SetReady();
    break;
  }
    
return;
}

// Le main  ....

/* ........................................................... */
/*    Classe OptionWind  Options et valeurs de parametres      */
/* ........................................................... */


/* --Methode-- */
OptionWind::OptionWind(PIDemoApp *par)
: PIWindow((PIMsgHandler *)par, "Options (PIDemo)", PIWK_dialog, 
           360, 550, 150, 150)
{
dap = par;

mLab[0] = new PILabel(this, "PaveSz", 60, 30, 20, 60); 

mLab[1] = new PILabel(this, "MinADU", 60, 30, 20, 190); 
mLab[2] = new PILabel(this, "MaxADU", 60, 30, 185, 190); 
mLab[3] = new PILabel(this, "Gain", 60, 30, 20, 230); 
mLab[4] = new PILabel(this, "RONoise", 60, 30, 185, 230); 

mLab[5] = new PILabel(this, "NBinHis", 60, 30, 20, 320); 
mLab[6] = new PILabel(this, "MinHis", 60, 30, 20, 360); 
mLab[7] = new PILabel(this, "MaxHis", 60, 30, 185, 360); 

mText[0] = new PIText(this, "PaveSz", 90, 30, 85, 60);
mText[0]->SetText("15");
mText[1] = new PIText(this, "MinADU", 90, 30, 85, 190);
mText[1]->SetText("1.");
mText[2] = new PIText(this, "MaxADU", 90, 30, 250, 190);
mText[2]->SetText("32000.");
mText[3] = new PIText(this, "Gain", 90, 30, 85, 230);
mText[3]->SetText("3.");
mText[4] = new PIText(this, "RONoise", 90, 30, 250, 230);
mText[4]->SetText("10.");
mText[5] = new PIText(this, "NBin", 90, 30, 85, 320);
mText[5]->SetText("200");
mText[6] = new PIText(this, "MinHis", 90, 30, 85, 360);
mText[6]->SetText("0.");
mText[7] = new PIText(this, "MaxHis", 90, 30, 250, 360);
mText[7]->SetText("2000.");

mTlb[0] = new PILabel(this, "--- Fit/Coupe/PrintPave ---", 160, 25, 100, 20);
mTlb[1] = new PILabel(this, "--- DynCCD ---", 160, 25, 100, 150);
mTlb[2] = new PILabel(this, "--- Histogramme ---", 160, 25, 100, 280);
mTlb[3] = new PILabel(this, "--- Visualisation  ---", 160, 25, 100, 410);

mOlb[0] = new PILabel(this, "TypePSF", 60, 25, 20, 100); 
mPum[0] = new PIPUMenu((PIMsgHandler *)this, "TypPSF");
mPum[0]->AppendItem("Gaussienne", 3101);
mPum[0]->AppendItem("Gauss.Int.", 3102);
mPum[0]->AppendItem("DL-Gauss.", 3103);
mPum[0]->AppendItem("DL-GauInt", 3104);
mOpt[0] = new PIOptMenu(this, mPum[0], 90, 25, 85, 100);
mOpt[0]->SetValue(3101);

mOlb[1] = new PILabel(this, "Def.Zoom", 60, 25, 20, 450); 
mPum[1] = NULL;
mOpt[1] = new PIOptMenu(this, dap->VisTC()->ZoomOptMenu(), 90, 25, 85, 450);
mOpt[1]->SetValue(101);

mCkb[0] = new PICheckBox(this,"ou Rect.Sel.",3001,140, 30, 200, 60); 
mCkb[1] = new PICheckBox(this,"PrintPave-PixVal",3002,140, 30, 200, 100); 
mCkb[2] = new PICheckBox(this,"AutoMin/Max",3003,140, 30, 200, 320); 
mCkb[3] = new PICheckBox(this,"ShowCursor",3004,140, 30, 200, 450); 
for(int i=0; i<4; i++) mCkv[i] = true;

mBut[0] = new PIButton(this, "Apply", 3500, 70, 30, 90, 500);
mBut[1] = new PIButton(this, "Cancel", 3600, 70, 30, 200, 500);

FinishCreate();
}

/* --Methode-- */
OptionWind::~OptionWind()
{
int i;
for(i=0; i<2; i++)
  {
  delete mBut[i];
  delete mOpt[i];
  delete mPum[i];
  delete mOlb[i];
  }
for(i=0; i<8; i++)
  {
  delete mLab[i];
  delete mText[i];
  }
for(i=0; i<4; i++)  
  {
  delete mTlb[i];
  delete mCkb[i];
  }
}

/* --Methode-- */
void OptionWind::Show()
{
char buff[64];

dap->SetBlocked();
sprintf(buff,"%d", pav_sz);
mText[0]->SetText(buff);
sprintf(buff,"%g", mdynccd->MinADU);
mText[1]->SetText(buff);
sprintf(buff,"%g", mdynccd->MaxADU);
mText[2]->SetText(buff);
sprintf(buff,"%g", mdynccd->Gain);
mText[3]->SetText(buff);
sprintf(buff,"%g", mdynccd->RONoise);
mText[4]->SetText(buff);
sprintf(buff,"%d", his_nbin);
mText[5]->SetText(buff);
sprintf(buff,"%g", his_min);
mText[6]->SetText(buff);
sprintf(buff,"%g", his_max);
mText[7]->SetText(buff);

mOpt[0]->SetValue(3100+typ_psf);
mOpt[1]->SetValue(100+vis_zoom);
mCkv[0] = rect_pav;
mCkv[1] = prt_pval;
mCkv[2] = his_ckd;
mCkv[3] = vis_cursshow;
for(int i=0; i<4; i++)
  mCkb[i]->SetState(mCkv[i]);

PIWindow::Show();
return;
}


/* --Methode-- */
void OptionWind::Process(long msg, PIMsgHandler* /*sender*/, void* data)
{

switch (msg)
  {
  case 3001:
  case 3002:
  case 3003:
  case 3004:
    if (data) mCkv[msg-3001] = true;   // J'ai un pb avec les CheckBox->GetState()  Reza ??
    else mCkv[msg-3001] = false;
    break;

  case 3600:
    dap->SetReady();
    this->Hide();
    break;

  case 3500:
    pav_sz = atoi(mText[0]->GetText().c_str());
    mdynccd->MinADU = atof(mText[1]->GetText().c_str());
    mdynccd->MaxADU = atof(mText[2]->GetText().c_str());
    mdynccd->Gain = atof(mText[3]->GetText().c_str());
    mdynccd->RONoise = atof(mText[4]->GetText().c_str());
    his_nbin = atoi(mText[5]->GetText().c_str());
    his_min = atof(mText[6]->GetText().c_str());
    his_max = atof(mText[7]->GetText().c_str());

    typ_psf = mOpt[0]->GetValue() - 3100;
    vis_zoom = mOpt[1]->GetValue() - 100;

/*
  Je ne sais pas pourquoi ca ne marche pas comme ca Reza $CHECK$ ??? 
    rect_pav = mCkb[0]->GetState();
    prt_pval = mCkb[1]->GetState();
    his_ckd = mCkb[2]->GetState();
    vis_cursshow = mCkb[3]->GetState();
*/
    rect_pav = mCkv[0];
    prt_pval = mCkv[1];
    his_ckd = mCkv[2];
    vis_cursshow = mCkv[3];
/*
    printf("\n-- %d %d %d %d -- \n", (int)rect_pav, (int)prt_pval, (int)his_ckd,
           (int)vis_cursshow);
    printf("OptionWind::Process(OK) : %d %d (%d) %d %g %g - %d \n",
            typ_psf, pav_sz, (int)rect_pav, his_nbin, his_min, his_max, vis_zoom);
    for(int i=0; i<4; i++)
       printf("ckb[%d] = %d (%d) - ", i, (int)mCkb[i]->GetState(),mCkv[i]); 
    puts(" ... ");        
    mdynccd->Print();
*/
    dap->SetReady();
    this->Hide();

    break;
  default:
//    printf("OptionWind::Process Msg %d received data= %ld\n", (int)msg, (long)data);
    break;
  }

}


int main(int narg, char *arg[])
{

char *path;
int i, rc, ofa;
char strg[512];

PeidaStarRecoInitiator InitStarReco;

ofa = 1;   path = NULL; 
if (narg > 1)
  {
  if (strcmp(arg[1],"-h") == 0) 
    {
    puts("\n piapp: Programme d analyse interactive EROS-2 (Version demo)");
    puts("Usage: piapp [-p ImagePath] [img1 img2 ...]");
    exit(0);
    }

  if (strcmp(arg[1],"-p") == 0)
    {
    if (narg == 2)  
      { puts("piapp_Erreur: Pb. d argument (piapp -h) ");  exit(1); }
    else { path = arg[2];  ofa = 3; }
    }
  }


mdynccd = new DynCCD(1, 1., 32000., 3., 10.);
PIDemoApp * app = new PIDemoApp(path);
app->SetBusy();
rc = DynLink(false);
for(i=ofa; i<narg; i++)
  {
  if (path)  sprintf(strg,"%s/%s", path, arg[i]);
  else strcpy(strg, arg[i]);
  string s(strg);
  app->OpenImage(s);
  }
puts("appel de Application.Run() ... ");
app->SetReady();
app->Run();

delete app;
#ifndef C_NO_SHLIBS
dlclose(dlhandle);
#endif
exit(0);
}


