// This may look like C code, but it is really -*- C++ -*-

// Operations non elementaires sur les images.
// Les operations elementaires sont des methodes de la classe.

//    C. Magneville  (Version C)  E. Aubourg / R. Ansari C++

// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef IMAGEOP_H_SEEN
#define IMAGEOP_H_SEEN

#include "cimage.h"
#include "cspline.h"

template <class T>
void CleanImages(int nImg, Image<T>** imgTab, double nSig=1,
                 double lowbad=-1e20, double highbad=1e20);


template <class T>
float ImgFondCielHisto(Image<T> const& img, float binWidth=1, int degre=2, 
                       float frac=0.5f,
                       float low=-999999.0, float high=999999.0,
                       int debug=0);
template <class T>
float ImgSigmaCiel(Image<T> const& img, int ndata, int binWidth, int taille,
                   float frac=0.5f, int degre=2,
                   float low=-999999.0, float high=999999.0,
                   int debug=0);

int CalFondImage(RzImage *pim, double low, double high, int action);

int FondSigmaCiel(RzImage *pim, float low, float high, int pvsz=100
              ,float nbsig1=3.5f,float nbsig2=7.f,float nbsig3=5.f
              ,float binsg=0.5f,float frac=0.33f,int modu=1,int deb=0);

int RzFondSig2Ciel(RzImage * pim, int vitesse, float FracMax, int NbSigmas, int NBin, 
	               float *MinPix, float *MaxPix, float *Fond, float *SigFond,
                   float *MinAff, float *MaxAff, float *FracNul, float *FracSature);

template <class T>
float FondLocal(Image<T> const & image, float xcentre, float ycentre,
                float rayon1, float rayon2, float fraclow, float frachigh, int lp=0);

// Filtrage / convolution d'images 

template <class T>
Image<T> * FilterImage(Image<T> const * pim, Image<T> * pom, ImageR4 *matx);

///////////////////////////////////////////////////////////////////
//// Filtre statistique d'images
template <class T>
Image<T> * FilterStat(Image<T> const * pim, Image<T> * pom
                     ,int N,int M,float lowbad,float highbad);
///////////////////////////////////////////////////////////////////
//// Spline d'images
template <class T>
Image<T> * CSplineImage(Image<T> const& f1,double pxsz=1.,double x0=0.,double y0=0.
                       ,int natural=(int)CSpline::NaturalAll);
///////////////////////////////////////////////////////////////////



#endif
