/*  Fonctions de manipulation de matrices et de vecteurs    */
/*  Resolution de systemes lineaires                        */

/*                              R. Ansari  Juillet 1993     */
/*  Note: 07/94 Fonction GausPiv(Inversion Matrice) CMV     */
/*        est utilisee pour  R/DFitLinErr()                 */

#ifndef MATXOP_H_SEEN
#define MATXOP_H_SEEN

#ifdef __cplusplus
extern "C" {
#endif

/*   Declaration des fonctions   */

/*  Operation Vecteurs/ Matrices   */
int IVecxVec(int *v1, int *v2, int n);
float RVecxVec(float *v1, float *v2, int n);
double DVecxVec(double *v1, double *v2, int n);
void  IMatxVec(int *mx, int *vi, int *vo, int n);
void  RMatxVec(float *mx, float *vi, float *vo, int n);
void  DMatxVec(double *mx, double *vi, double *vo, int n);

/*  Resolution  de systemes lineaires  */
float SolveRLinSyst(float *mx, float *b, float *x, int n);
double SolveDLinSyst(double *mx, double *b, double *x, int n);


/*  Ajustement de Chi2   */

/*  Ajustement avec vecteurs de depart Reels  */
int InitRFitLin(int nstmx, int szv);
void EndRFitLin(void);
float **GetRFitVect(int nvar, int vsz);
void FreeRFitVect(void);
float RFitLin(int nd, int vsz, float *XVar);
float RFitLinErr(int nd, int vsz, float *XVar, float *Err);

/*  Ajustement avec vecteurs de depart double  */
int InitDFitLin(int nstmx, int szv);
void EndDFitLin(void);
double **GetDFitVect(int nvar, int vsz);
void FreeDFitVect(void);
double DFitLin(int nd, int vsz, double *XVar);
double DFitLinErr(int nd, int vsz, double *XVar, double *Err);

#ifdef __cplusplus
}
#endif

#endif





