// Classe d'initialisation du module Outils++ 
#include <unistd.h>

#include "outilsinit.h"

#include "matrix.h"
#include "cvector.h"
#include "poly.h"
#include "dvlist.h"
#include "histos.h"
#include "histos2.h"
#include "hisprof.h"
#include "ntuple.h"
#include "generaldata.h"

#include "cimage.h"

#include "tabmath.h"
#include "dates.h"
#include "datime.h"

int PeidaOutilsInitiator::FgInit = 0;

PeidaOutilsInitiator::PeidaOutilsInitiator()
  : PeidaInitiator()
{
  FgInit++;
  if (FgInit > 1)  return;

//   Enregistrement des classes PPersist du modules Outils++
  
  PPRegister(Matrix);
  PPRegister(Vector);
  PPRegister(Poly);
  PPRegister(Poly2);
  PPRegister(DVList);
  PPRegister(Histo);
  PPRegister(Histo2D);
  PPRegister(HProf);
  PPRegister(NTuple);
  PPRegister(GeneralFitData);

  PPersistMgr::RegisterClass(RzImage::classId,  RzImage::Create);
  { ImageU2 iu2;
  PPersistMgr::RegisterClass(iu2.ClassId(),  ImageU2::Create); }
  { ImageI2 ii2;
  PPersistMgr::RegisterClass(ii2.ClassId(),  ImageI2::Create); }
  { ImageI4 ii4;
  PPersistMgr::RegisterClass(ii4.ClassId(),  ImageI4::Create); }
  { ImageR4 ir4;
  PPersistMgr::RegisterClass(ir4.ClassId(),  ImageR4::Create); }

  //PPersistMgr::RegisterClass(Matrix::classId,  Matrix::Create);

  int pnice;
  char* snice = getenv("PEIDANICE");
  if (!snice) pnice=8;
  else pnice = atoi(snice);
  nice(pnice);

//  TSidSetupLaSilla();    Old-Eros

  gTimeZone = new TimeZone;

  ptabFExp = new TabFExp;

}

PeidaOutilsInitiator::~PeidaOutilsInitiator()
{
  FgInit--;
}


// On met un objet initiator en statique, pour les loaders qui savent 
// appeler le constructeur des objets statiques   Reza 08/98
static PeidaOutilsInitiator poutilsinit;

