// This may look like C code, but it is really -*- C++ -*-
#ifndef RK4CDIFEQ_H_SEEN
#define RK4CDIFEQ_H_SEEN

#include "difeq.h"

// <summary> Runge-Kutta ordre 4 adaptatif </summary>
// Runge-Kutta ordre 4 adaptatif, avec correction du pas d'integration
class RK4CDiffEq : public RK4DiffEq {
public:
  // Constructeurs. Voir <linkto class=DiffEqSolver>DiffEqSolver</linkto>
  // <group>
  RK4CDiffEq();
  RK4CDiffEq(DiffEqFunction*);
  RK4CDiffEq(DIFEQFCN1);
  // </group>

  // Precision souhaitee, en absolu ou relatif, independamment pour chaque
  // fonction ou globalement
  // <group>
  RK4CDiffEq& Accuracy(double);
  RK4CDiffEq& AbsAccuracy(Vector const& vScal);
  RK4CDiffEq& AbsAccuracy(double scal);
  RK4CDiffEq& RelAccuracy();
  // </group>
  
  // Implementation RK4 adaptatif
  virtual void SolveArr(Matrix& y, double* t, double tf, int n);

protected:
  // Un pas adaptatif
  void RKCStep(Vector& newY, Vector const& y0, Vector const& yScale, 
	       double dttry, double& dtdone, double& dtnext);

  double eps;
  bool   relAccuracy;
  Vector accScale;
  Vector yTemp; // Pour ne pas reallouer
  Vector ySave;
};

#endif
