/*    Fonction d'impression de temps de calcul et de temps passe  */
/*                               R.Ansari    Juin 93              */

/*
++
  Module	Temps CPU, pass (C)
  Lib	LibsUtil
  include	timing.h

	Fonctions permettant d'imprimer le temps CPU consomm et le temps 
	pass.
--
*/ 

/*
++
  void InitTim()
	Initialisation des chronomtres
  void PrtTim(char *comm)
	Imprime le temps CPU, et le temps pass depuis 
	le dernier appel  "PrtTim()" avec le commentaire
	"comm". Imprime aussi le cumul du temps CPU et du 
	temps pass depuis l'appel  "InitTim()".
--
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

#include "timing.h"

static clock_t CPUT0, CPUT;
static time_t ELT0, ELT;
 
 
/* Nouvelle-Fonction */
/*!
   \ingroup SysTools
   Initializes CPU and elapsed time timer (C function).
   The values of the CPU and elapsed time can then be printed 
   using \b PrtTim() 
*/
void InitTim(void)
{
CPUT0 = CPUT = clock();
ELT0 = ELT = time(NULL);
return;
}
 
/* Nouvelle-Fonction */
/*!
   \ingroup SysTools
   Prints the values of the CPU and elapsed time, since call to \b InitTim().
*/
void PrtTim(const char * Comm)
{
float tcal,tcalt;
clock_t cput;
time_t elt;
int etm,etmt;
 
elt = time(NULL);  cput = clock();
tcalt = ( (float)(cput) - (float)(CPUT0) ) / (float)(CLOCKS_PER_SEC);
tcal = ( (float)(cput) - (float)(CPUT) ) / (float)(CLOCKS_PER_SEC);
etm = elt - ELT;
etmt = elt - ELT0;
printf("%s CPUTime: Total= %g  (Partial= %g) Sec. \n",
       Comm, tcalt, tcal);
printf("ElapsedTime(hh:mm:ss): Total= %02d:%02d:%02d ",
       etmt/3600, (etmt%3600)/60, etmt%60);
printf(" (Partial= %02d:%02d:%02d)\n",
       etm/3600, (etm%3600)/60, etm%60);
 
ELT = elt;
CPUT = cput;
return;
}
