#include "picontainerx.h"

#include <Xm/Form.h>

/* --Methode-- */
PIContainerX::PIContainerX(PIContainerGen *par, char *nom, 
                           int sx, int sy, int px, int py) 
: PIContainerGen(par, nom, sx, sy, px, py)
{
if ((sx > 0) && (sy > 0)) 
  CreateXtWdg(nom, xmFormWidgetClass , NULL, sx, sy, px, py);
//  CreateXtWdg(nom, xmBulletinBoardWidgetClass , NULL, sx, sy, px, py);
mTopWdg = NULL;
}

// constructeur special a utiliser par PIApplicationX ...
PIContainerX::PIContainerX(PIMsgHandler *par, PIWdgX *parwdg, char *nom,  
                           int sx, int sy, int px, int py) 
: PIContainerGen(NULL, nom, sx, sy, px, py)
{
SetMsgParent(par);
if ((sx > 0) && (sy > 0)) 
  CreateXtWdg(nom, xmFormWidgetClass , parwdg->XtWdg(), sx, sy, px, py);
mTopWdg = parwdg;
}

/* --Methode-- */
PIContainerX::~PIContainerX()
{}


/* --Methode-- */
void PIContainerX::Process(PIMessage msg, PIMsgHandler* sender, void* data)
{
// Traitement specifique pour le top-container de PIApplicationX
if ((mTopWdg != NULL) && (ModMsg(msg) == PIMsg_ResizeRequest)) {
  // On change la taille de la fenetre - data est un pointeur sur entier
  // data[0] represente l'increment (positif ou negatif) en X, data[1] en Y
  int* nsz = (int*) data;
  mTopWdg->SetSize(mTopWdg->XSize()+nsz[0], mTopWdg->YSize()+nsz[1]);
  return;
  }  
else ReSend(msg, sender, data);
}

/* --Methode-- 
void PIContainerX::Show()
{
PIContainerGen::Show();
Manage();
}

void PIContainerX::Hide()
{
PIContainerGen::Hide();
UnManage();
}

*/
