// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive     PIGraphic3D
// Trace graphiques 3D               R. Ansari  06/98
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PIGRAPHIC3D_H_SEEN
#define PIGRAPHIC3D_H_SEEN

#include "pisysdep.h"
#include "pigraphuc.h"


class PIGraphic3D : public PIGraphicUC 
{
public:
                     PIGraphic3D(PIGraphicGen* g, PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual           ~PIGraphic3D();

  virtual int        kind();

//  Definition du systeme de projection 3D-2D
  virtual void       Set3DCS_Obs(double xo, double yo, double zo, double teta, double phi, double psi, 
                                 double dax, double day, double co, double dco=0.2);
  virtual void       Set3DCS(double xc, double yc, double zc, double xo, double yo, double zo, 
                             double dax, double day, double dco=0.2, double psi=0.);
  virtual bool       Get3DCS(double& xc, double& yc, double& zc, double& xo, double& yo, double& zo,  
                             double& teta, double& phi, double& psi, double& dax, double& day, double& co, double& dco);

  virtual void       PrintCS();  // Pour debugger
  virtual void       RotateObserver(double teta, double phi, double psi=0., bool rel=true);
  virtual void       RotateObject(double teta, double phi, bool rel=true);
  virtual void       ZoomInOut(double fco, double fdax, double fday, bool rel=true);

  virtual void       C3DC2ObsCS(double x, double y, double z, double& xp, double& yp, double& zp);
  virtual void       Proj3DC2GrC(double x, double y, double z, double& xpix, double& ypix);
  
  virtual void       DrawString3D(PIGrCoord x0, PIGrCoord y0, PIGrCoord z0, const char* s);
  virtual void       DrawOpaqueString3D(PIGrCoord x0, PIGrCoord y0, PIGrCoord z0, const char* s);
  virtual void       DrawLine3D(PIGrCoord x1, PIGrCoord y1, PIGrCoord z1, 
                                PIGrCoord x2, PIGrCoord y2, PIGrCoord z2);
  virtual void       DrawPolygon3D(PIGrCoord *x, PIGrCoord *y, PIGrCoord *z, int n);  
  virtual void       DrawFPolygon3D(PIGrCoord *x, PIGrCoord *y, PIGrCoord *z, int n);  
  virtual void       DrawMarker3D(PIGrCoord x0, PIGrCoord y0, PIGrCoord z0);
  virtual void       DrawMarkers3D(PIGrCoord *x, PIGrCoord *y, PIGrCoord *z, int n);
  
protected:
  double xO, yO, zO;  // Position observateur = camera
  double xC, yC, zC;  // Position centre du champ
  double tO,fO,pO;    // Orientation observateur (Teta, Phi, Psi, Angles d Euler)
  double daxO, dayO;  // Demi-ouverture de la camera suivant les deux axes de projection (xp/zp, yp/zp) 
  double lCO, dlCO;   // Distance Camera-Centre du champ et profondeur de champ 
  double RE[3][3];    // Matrice de rotation  
  bool sO;            // Vrai si fait par Set3DCS_Obs()
};

#endif
