// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive     PIGraphicX
// Trace graphiques- Implementation X11  R. Ansari  97
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PIGRAPHICX_H_SEEN
#define PIGRAPHICX_H_SEEN

#include "pisysdep.h"
#include "pigraphgen.h"

class PIGraphicX : public PIGraphicGen
{
public:
                     PIGraphicX(PIWdg* wdg);
                     PIGraphicX(PIScreenBuffer* grb);
  virtual           ~PIGraphicX();

  virtual int        kind();

//  Trace graphiques
  virtual void       Erase(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual void       DrawString(PIGrCoord x, PIGrCoord y, const char* s, int pos = 0);
  virtual void       DrawOpaqueString(PIGrCoord x, PIGrCoord y, const char* s, int pos = 0);
  virtual void       DrawLine(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2);
  virtual void       DrawBox(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual void       DrawFBox(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual void       DrawCircle(PIGrCoord x0, PIGrCoord y0, PIGrCoord r);
  virtual void       DrawFCircle(PIGrCoord x0, PIGrCoord y0, PIGrCoord r);
  virtual void       DrawOval(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual void       DrawFOval(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual void       DrawPolygon(PIGrCoord *x, PIGrCoord *y, int n, bool cinc=true);  
  virtual void       DrawFPolygon(PIGrCoord *x, PIGrCoord *y, int n, bool cinc=true);  
  virtual void       DrawArc(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy,
                             double degdeb, double degfin);
  virtual void       DrawFArc(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy, 
                              double degdeb, double degfin);
  virtual void       DrawMarker(PIGrCoord x0, PIGrCoord y0);
  virtual void       DrawMarkers(PIGrCoord *x, PIGrCoord *y, int n);
  virtual void       DrawPixmap(PIGrCoord x, PIGrCoord y, unsigned char *pix, 
                                int sx, int sy, PIColorMap* cmap);

// Modifications attributs graphiques
  virtual void       SelForeground(PIColors col=PI_Black);
  virtual void       SelBackground(PIColors col=PI_White);
  virtual void       SelForeground(PIColorMap& cmap, int cid);
  virtual void       SelBackground(PIColorMap& cmap, int cid);
  virtual void       SelGOMode(PIGOMode mod=PI_GOCopy);
  virtual void       SelFont(PIFontSize sz=PI_NormalSizeFont, 
                             PIFontAtt att=PI_RomanFont);
  virtual void       SelFontSzPt(int npt=12, PIFontAtt att=PI_RomanFont);
  virtual void       SelLine(PILineAtt att=PI_NormalLine);
  virtual void       SelMarker(int msz=3, PIMarker mrk=PI_DotMarker);

// Selection de zone de trace (clip)
  virtual void       SetClipRectangle(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual void       ClearClipRectangle();

// Acces aux attributs graphiques 
  virtual PIColors   GetForeground();
  virtual PIColors   GetBackground();
  virtual PIGOMode   GetGOMode();
  virtual PIFontAtt  GetFontAtt();
  virtual int        GetFontSize();
  virtual PILineAtt  GetLineAtt();
  virtual PIMarker   GetMarker();
  virtual int        GetMarkerSize();

  virtual int        GetFontHeight(int& asc, int& desc);
  virtual PIGrCoord  CalcStringWidth(char const* s);

// Sauvegarde des attributs graphiques 
  virtual void       SaveGraphicAtt();
  virtual void       RestoreGraphicAtt();

//  Pour recuperer le pixcol d une couleur  (pour X) 
  PIXColor           GetPixelValueforColor(PIColors col);
//  Pour initialiser mWId apres creation de fenetre
  virtual void	     TerminateInit();

protected:
  static void    GlInit();
  void           Init();
  void           SelectFont(int isz, int jat);
  inline  GC     DefGC() { return mDefGC; }
  inline SysDWdg MyWdg()  {return(myWdg->XtWdg()); }
  inline void    SelectBCol(PIXColor col) 
    {XSetBackground(mDisp, DefGC(), col);  mBCol = PI_ColorFromMap; mBCfMap = col; }
  inline void    SelectFCol(PIXColor col) 
    {XSetForeground(mDisp, DefGC(), col);  mFCol = PI_ColorFromMap; mFCfMap = col; }

//  Structure et identificateur XWindow  associe
  GC mDefGC;
  Display* mDisp;  // Display X associe
  Drawable mWId;   // Identificateur Window/Drawable X

  PIColors  mFCol, mBCol;
  PIGOMode mGOm;
  PIFontAtt mFAtt;
  PILineAtt mLAtt;
  int mFSize;
  XFontStruct *mFSt;
  PIMarker mMrk;
  int mMrkSz;
  PIXColor mFCfMap, mBCfMap;
  PIXColor sFCfMap, sBCfMap;
};

typedef PIGraphicX PIGraphicWin;

#endif
