<?xml version="1.0"?> 
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="text" omit-xml-declaration="no" indent="no"/>
<xsl:strip-space elements="*"/>

<xsl:template match="processors">	

	<xsl:variable name="lstproc">
	<xsl:for-each select="processor">
	<xsl:value-of select="@name"/>
	<xsl:if test="last() > position()"> | </xsl:if>
	</xsl:for-each>
	</xsl:variable>
	
	<xsl:variable name="lstinput">
	<xsl:for-each select="//input">
	<xsl:value-of select="@name"/>
	<xsl:if test="last() > position()"> | </xsl:if>
	</xsl:for-each>
	</xsl:variable>
	
	<xsl:variable name="lstoutput">
	<xsl:for-each select="//output">
	<xsl:value-of select="@name"/>
	<xsl:if test="last() > position()"> | </xsl:if>
	</xsl:for-each>
	</xsl:variable>

	<xsl:text>
	&lt;!ELEMENT connect EMPTY>
	<!-- &lt;!ATTLIST connect input ( </xsl:text><xsl:value-of select="$lstinput"/><xsl:text> ) #REQUIRED> -->
	&lt;!ATTLIST connect input NMTOKEN #REQUIRED>
	&lt;!ATTLIST connect name NMTOKEN #REQUIRED>
	<!-- &lt;!ATTLIST connect output ( </xsl:text><xsl:value-of select="$lstoutput"/><xsl:text> ) #REQUIRED> -->
	&lt;!ATTLIST connect output NMTOKEN #REQUIRED>
	</xsl:text>
	<xsl:text>
	&lt;!ATTLIST connect procin NMTOKEN #REQUIRED>
	&lt;!ATTLIST connect procout NMTOKEN #REQUIRED>
	
	&lt;!ELEMENT constraint EMPTY>
	&lt;!ATTLIST constraint max NMTOKEN #REQUIRED>
	&lt;!ATTLIST constraint min NMTOKEN #REQUIRED>
	&lt;!ATTLIST constraint proc NMTOKEN #REQUIRED>
 	
	&lt;!ELEMENT start EMPTY>

	&lt;!ELEMENT toipipe ( (</xsl:text><xsl:value-of select="$lstproc"/><xsl:text> | connect | constraint | start )* )>
	&lt;!ATTLIST toipipe name NMTOKEN #IMPLIED>
	</xsl:text>

	<!-- recherche des processeurs -->
	<xsl:apply-templates/>
	<xsl:text>

	</xsl:text>
</xsl:template>


<xsl:template match="processor">

	<xsl:variable name="nomproc" select="@name"/>
	
	<!-- liste des methodes -->
	<xsl:variable name="lstmethod">
	<xsl:for-each select="attribute">
	<xsl:value-of select="@name"/>
	<xsl:if test="last() > position()"> | </xsl:if>
	</xsl:for-each>
	</xsl:variable>
	
	<!-- sortie -->
	<xsl:if test="$lstmethod=''">
	<xsl:text>
	&lt;!ELEMENT </xsl:text><xsl:value-of select="$nomproc"/><xsl:text> EMPTY></xsl:text>
	</xsl:if>
	<xsl:if test="$lstmethod!=''">
	<xsl:text>

	&lt;!ELEMENT </xsl:text><xsl:value-of select="$nomproc"/><xsl:text> ( (</xsl:text><xsl:value-of select="$lstmethod"/><xsl:text>)* )></xsl:text>
	</xsl:if>
	<xsl:text>
	&lt;!ATTLIST </xsl:text><xsl:value-of select="$nomproc"/><xsl:text> id NMTOKEN #REQUIRED></xsl:text>

	<xsl:for-each select="init/param">
	<xsl:text>
	&lt;!ATTLIST </xsl:text><xsl:value-of select="$nomproc"/><xsl:text> </xsl:text><xsl:value-of select="@name"/><xsl:text> NMTOKEN #IMPLIED></xsl:text>
	</xsl:for-each>

	<!-- recherche des attributs -->
	<xsl:apply-templates/>

</xsl:template>

<xsl:template match="attribute">

	<xsl:variable name="nomatt" select="@name"/>

	<xsl:text>
	&lt;!ELEMENT </xsl:text><xsl:value-of select="$nomatt"/><xsl:text> EMPTY></xsl:text>

	<xsl:for-each select="param">
	<xsl:text>
	&lt;!ATTLIST </xsl:text><xsl:value-of select="$nomatt"/><xsl:text> </xsl:text><xsl:value-of select="@name"/><xsl:text> NMTOKEN #IMPLIED>
	</xsl:text>
	</xsl:for-each>

</xsl:template>

</xsl:stylesheet>











