<?xml version="1.0"?> 
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="text" omit-xml-declaration="no" indent="no"/>
<xsl:strip-space elements="*"/>

<xsl:template match="processors">	

<xsl:text>
// main genere automatiquement par xsl
// ne pas modifier
// derniere mise a jour : VF le 22/10/2002

// inclusions expat
#include &lt;stdio.h>
#include "expat.h"

// inclusions c++
#include &lt;string>
#include "config.h"
#include &lt;map>
using namespace std;
#include &lt;iostream.h>
#include "toi.h"
#include "toiprocessor.h"
#include "toimanager.h"
#include "toisegment.h"
#include "sophyainit.h"
#include &lt;stdexcept>

#ifndef MAXINT
#define MAXINT 2147483647
#endif
</xsl:text>

<xsl:for-each select="processor">
	<xsl:text>
#include "</xsl:text><xsl:value-of select="@include"/><xsl:text>"</xsl:text>
</xsl:for-each>

<xsl:text>

// classe de gestion des balises en design patern object call-back
class ToiPipe
{
public:
  ToiPipe(void);
  virtual ~ToiPipe();
  static void startElement(void *userData, const char *name, const char **atts);
  static void endElement(void *userData, const char *name);
private:
  // pour concordances instances - nom
  map&lt;string,TOIProcessor*> toiProc;
  string id; 
  // gestionnaire de TOI
  TOIManager* mgr;
  void startElementC(const char *name, const char **atts);
  void endElementC(const char *name);
};



ToiPipe::ToiPipe()
{
 // Ouverture du gestionnaire de TOI.
 mgr = TOIManager::getManager();
 // initialisation du processeur courant
 id="";

}

ToiPipe::~ToiPipe()
{

}

void ToiPipe::startElement(void *userData, const char *name, const char **atts)
{
  ToiPipe *toiPipe = (ToiPipe*) userData;
  toiPipe->startElementC(name, atts);
}

void ToiPipe::endElement(void *userData, const char *name)
{
  ToiPipe* toiPipe = (ToiPipe*) userData;
  toiPipe->endElementC(name);
}


void ToiPipe::startElementC(const char *name, const char **atts)
{
  int i;
  //puts(name);

  // filtrage des balises
  if ((string)name == "connect") {
    // mise en ordre des arguments
    string nom;
    TOIProcessor* procin=NULL;
    TOIProcessor* procout=NULL;
    string input;
    string output;
    int taille = 1024;
    bool writeflag = false;
    for (i=0; atts[i]; i+=2) {
      if ((string)atts[i] == "name") {
	nom=atts[i+1];
      }
      if ((string)atts[i] == "procin") {
	map&lt;string,TOIProcessor*>::iterator j=toiProc.find(atts[i+1]);
	if (j != toiProc.end()) { 
	  procin = (*j).second;
	} else {
	   throw ParmError("Connect error: processor in not found");
	}
      }
      if ((string)atts[i] == "procout") {
	map&lt;string,TOIProcessor*>::iterator j=toiProc.find(atts[i+1]);
	if (j != toiProc.end()) {
	  procout = (*j).second;
	} else {
	   throw ParmError("Connect error: processor out not found");
	}
      }
      if ((string)atts[i] == "input") {
	input = atts[i+1];
      }
      if ((string)atts[i] == "output") {
	output = atts[i+1];
      }
    }    
    // connection automatique des toiprocesseurs    
    if (procin != NULL &amp;&amp; procout != NULL ) {
      cout &lt;&lt; "connect " &lt;&lt; output &lt;&lt; " " &lt;&lt; input &lt;&lt; endl;
      mgr->connect(*procout, output, *procin, input, nom, taille, writeflag);
       cout &lt;&lt; "connect done" &lt;&lt; endl;
    }

  } else if ((string)name == "constraint") {                                // si balise de contrainte     
    TOIProcessor* proc=NULL;
    int min=0;
    int max=MAXINT;
    for (i=0; atts[i]; i+=2) {
      if ((string)atts[i] =="proc") {
        map&lt;string,TOIProcessor*>::iterator j=toiProc.find(atts[i+1]);
	if (j != toiProc.end()) { 
	  proc = (*j).second;
	} else {
	  throw ParmError("Constraint error: processor not found");
	}
      }
      if ((string)atts[i] == "min") {
        min = atoi(atts[i+1]);
      }
      if ((string)atts[i] == "max") {
        max = atoi(atts[i+1]);
      } 
    }
    cout &lt;&lt; "setting " &lt;&lt; proc &lt;&lt; " " &lt;&lt; min &lt;&lt; " " &lt;&lt; max &lt;&lt; endl;
    proc->setRequestedSample(min, max);
    cout &lt;&lt; "constraint done" &lt;&lt; endl;
  
  } else if ((string)name == "start") {                                     // si balise de demarrage 
    cout &lt;&lt; "***** Starting execution *****" &lt;&lt; endl;
    mgr->startAll();
    // Gestion de la re-connection des threads
    cout&lt;&lt;"***** Joining threads *****"&lt;&lt;endl;
    mgr->joinAll();
    cout&lt;&lt;"***** End threads *****"&lt;&lt;endl; 
    // destruction du toimanager et des processeurs a implementer dans toimanager pour l'utilisation de plusieurs start
    //TOIManager::~toimanager();
    //toiProc.clear();
  
  } else if (id == "") {                                            // si nouveau processeur
</xsl:text>
<xsl:for-each select="processor">
  if ((string)name == "<xsl:value-of select="@name"/>") {
    <xsl:for-each select="init/param">
    <xsl:value-of select="@type"/><xsl:text> </xsl:text><xsl:value-of select="@name"/>;
    </xsl:for-each>
    <xsl:variable name="lstparam">
    <xsl:for-each select="init/param">
    <xsl:value-of select="@name"/>
    <xsl:if test="last() > position()">, </xsl:if>
    </xsl:for-each>
    </xsl:variable>
	
    // gestion des arguments du constructeur
    for (i=0; atts[i]; i+=2) {
      // var pour instanciation
        if ((string)atts[i] == "id") {
            id=atts[i+1];
      	}
	
	//initialisation des arguments par defaut si existants
	<xsl:for-each select="init/param">
	   <xsl:variable name="typearg">
	   <xsl:value-of select="@type"/>
	   </xsl:variable>
	   <xsl:variable name="defaut">
	   <xsl:value-of select="@default"/>
	   </xsl:variable>
	   <xsl:if test="$defaut!=''">  
	   <xsl:if test="$typearg='int' or $typearg='long' or $typearg='float' or $typearg='double' or $typearg='uint_4' or $typearg='int_4' or $typearg='uint_8' or $typearg='int_8'">
	   <xsl:value-of select="@name"/> = <xsl:value-of select="$defaut"/>;
	   </xsl:if>
	   <xsl:if test="$typearg='string' or $typearg='char*' or $typearg='char'">
	   <xsl:value-of select="@name"/> = "<xsl:value-of select="$defaut"/>";
	   </xsl:if>
	   </xsl:if>
	</xsl:for-each>

	// mise a jour des arguments
	<xsl:for-each select="init/param">
	if ((string)atts[i] == "<xsl:value-of select="@name"/>") {
	   <xsl:variable name="typearg">
	   <xsl:value-of select="@type"/>
	   </xsl:variable>
	    <xsl:if test="$typearg='int' or $typearg='long' or $typearg='int_4' or $typearg='uint_4' or $typearg='int_8' or $typearg='uint_8'">
	   <xsl:value-of select="@name"/> = atoi(atts[i+1]);
	   </xsl:if> 
	   <xsl:if test="$typearg='float' or $typearg='double'">
	   <xsl:value-of select="@name"/> = atof(atts[i+1]);
	   </xsl:if>
	   <xsl:if test="$typearg='char' or $typearg='char*' or $typearg='string'">
	   <xsl:value-of select="@name"/> = atts[i+1];
	   </xsl:if>  
	}
    	</xsl:for-each>
      }
   
    // creation du toiprocesseur
    toiProc[id] = new <xsl:value-of select="@class"/> (<xsl:value-of select="$lstparam"/>);
  }
</xsl:for-each>  

  } else {                                           // sinon c une methode
    // gestion des methodes 
<xsl:for-each select="processor">
  if (id == "<xsl:value-of select="@name"/>") {
    <xsl:variable name="casttype">
    <xsl:value-of select="@class"/>
    </xsl:variable>
    <xsl:for-each select="attribute">
    if ((string)name == "<xsl:value-of select="@name"/>") {
    <xsl:for-each select="param">
    <xsl:value-of select="@type"/><xsl:text> </xsl:text><xsl:value-of select="@name"/>;
    </xsl:for-each>
    <xsl:variable name="lstparam">
    <xsl:for-each select="param">
    <xsl:value-of select="@name"/>
    <xsl:if test="last() > position()">, </xsl:if>
    </xsl:for-each>
    </xsl:variable>
	
    // gestion des arguments de la methode
    for (i=0; atts[i]; i+=2) {     
	//initialisation des arguments par defaut si existants
	<xsl:for-each select="param">
	   <xsl:variable name="typearg">
	   <xsl:value-of select="@type"/>
	   </xsl:variable>
	   <xsl:variable name="defaut">
	   <xsl:value-of select="@default"/>
	   </xsl:variable>
	   <xsl:if test="$defaut!=''">
	   <xsl:if test="$typearg='int' or $typearg='long' or $typearg='float' or $typearg='double' or $typearg='uint_4' or $typearg='int_4' or $typearg='uint_8' or $typearg='int_8'">
	   <xsl:value-of select="@name"/> = <xsl:value-of select="$defaut"/>;
	   </xsl:if>
	   <xsl:if test="$typearg='string' or $typearg='char*' or $typearg='char'">
	   <xsl:value-of select="@name"/> = "<xsl:value-of select="$defaut"/>";
	   </xsl:if>
	   </xsl:if>
	</xsl:for-each>

	// mise a jour des arguments
	<xsl:for-each select="param">
	if ((string)atts[i] == "<xsl:value-of select="@name"/>") {
	   <xsl:variable name="typearg">
	   <xsl:value-of select="@type"/>
	   </xsl:variable>
	   <xsl:if test="$typearg='int' or $typearg='long' or $typearg='int_4' or $typearg='uint_4' or $typearg='int_8' or $typearg='uint_8'">
	   <xsl:value-of select="@name"/> = atoi(atts[i+1]);
	   </xsl:if> 
	   <xsl:if test="$typearg='float' or $typearg='double'">
	   <xsl:value-of select="@name"/> = atof(atts[i+1]);
	   </xsl:if>
	   <xsl:if test="$typearg='char' or $typearg='char*' or $typearg='string'">
	   <xsl:value-of select="@name"/> = atts[i+1];
	   </xsl:if>
	}
    	</xsl:for-each>
      }
   
    // appelle de la methode du processeur concerne
    ((<xsl:value-of select="$casttype"/>*)toiProc[id])-><xsl:value-of select="@methode"/> (<xsl:value-of select="$lstparam"/>); 
    }
    </xsl:for-each>
  }
</xsl:for-each>
  
  }
  
}


void ToiPipe::endElementC(const char *name)
{
  // verification si une balise processeur est fermee pour la gestion des methodes d'initialisation
  <xsl:for-each select="processor">
  if ((string)name == "<xsl:value-of select="@name"/>") {
    id="";
  }
  </xsl:for-each>

  // execution du pipeline
  if ((string)name == "toipipe") { 
    cout &lt;&lt; "***** Starting execution *****" &lt;&lt; endl;
    mgr->startAll();
    // Gestion de la re-connection des threads
    cout&lt;&lt;"***** Joining threads *****"&lt;&lt;endl;
    mgr->joinAll();
    cout&lt;&lt;"***** End threads *****"&lt;&lt;endl; 
  }
}


int main(int argc, char *argv[])
{
  char buf[BUFSIZ];
  XML_Parser parser = XML_ParserCreate(NULL);
  int done;
  FILE* fich=fopen(argv[1],"r");

  ToiPipe* toiPipe = new ToiPipe();
  
  // Initialisation de Sophya
  SophyaInit();
  cout &lt;&lt; "-- Application start --" &lt;&lt; endl;
  XML_SetUserData(parser, toiPipe);
  XML_SetElementHandler(parser, ToiPipe::startElement, ToiPipe::endElement);
  if (fich != NULL) {
    cout &lt;&lt; "-- Reading file --" &lt;&lt; endl;
    // traitement des balises
    do {
      try {
	size_t len = fread(buf, 1, sizeof(buf), fich);
	done = len &lt; sizeof(buf);
	if (!XML_Parse(parser, buf, len, done)) {
	  fprintf(stderr,
	      "%s at line %d\n",
              XML_ErrorString(XML_GetErrorCode(parser)),
              XML_GetCurrentLineNumber(parser));
	  return 1;
	}
      } catch (PThrowable &amp; exc) {    // Sophya exceptions
	cout &lt;&lt; "\ntstdemopipe: Catched Exception \n" &lt;&lt; (string)typeid(exc).name() 
	&lt;&lt; " - Msg= " &lt;&lt; exc.Msg() &lt;&lt; endl;
      } catch (const std::exception &amp; sex) {    // Standard exceptions
	cout &lt;&lt; "\ntstdemopipe: Catched std::exception \n" 
      &lt;&lt; (string)typeid(sex).name() &lt;&lt; endl; 
      } catch (...) {    // Other exceptions
	cout &lt;&lt; "\ntstdemopipe: some other exception was caught ! " &lt;&lt; endl;
      }
    } while (!done);
    XML_ParserFree(parser);
    fclose(fich);
  } else {
     fprintf(stderr,"file not found");
     return 1;
  }
  return(0);
}

</xsl:template>

</xsl:stylesheet>



































