// This may look like C code, but it is really -*- C++ -*-

// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: toimanager.h,v 1.16 2002-10-23 21:05:18 aubourg Exp $


#ifndef TOIMANAGER_H
#define TOIMANAGER_H

#include "config.h"
#include <string>
#include <vector>

#include "toiprocessor.h"


// -----------ajout cgt vf 19/08/2002

#include "toi.h"

#include <typeinfo>
#include "toiseqbuff.h"
#include "toisegment.h"
#include "fitstoiwtr.h"

#ifdef WITH_SOPHYA
#include "pexceptions.h"
#else
#include "apexceptions.h"
#endif

#include <pthread.h>
// ----------fin ajout cgt



using namespace std;

class TOIManager {
public:
  static TOIManager* getManager();
  void setRequestedSample(int begin, int end);
  int getRequestedBegin();
  int getRequestedEnd();
  
  // ajout vf 25/07/2002
  void startAll();
  bool checkSamplesLimits(int pass);

  void waitForAll();

  void joinAll();  // deprecated. Use waitForAll();
   
  
  // ajout cgt vf 19/08/2002
  
  void    selectTOISegmented(int bufsz=1024, int maxseg=20);
  void    selectTOISeqBuffered(int wsz=8192);

  virtual TOI& connect(TOIProcessor& prout, string out, 
		       TOIProcessor& prin, string in, string nom="", 
		       int wbsz=0, bool withFlag=false);
  virtual TOI& connect(TOIProcessor& prout, const char* out, 
		       TOIProcessor& prin, const char* in, string nom="", 
		       int wbsz=0, bool withFlag=false); 

  // fin ajout cgt




protected:
  TOIManager();
  static TOIManager* instance;
  long reqBegin;
  long reqEnd;

  vector<pthread_t*> threads;
  void addThread(pthread_t*);

  // ajout vf 25/07/2002
  
  vector<TOIProcessor*> processors;
  void registerProcessor(TOIProcessor* proc);

  friend class TOIProcessor;

  // ajout cgt vf 19/08/2002
   
  bool fgSegmented;     // type de toi
  int segBuffsz, segMaxseg;

  // fin ajout cgt

};

// -----------------------------------------------------------------
//    Classe pour affichage de l'avancement des TOIProcessors 
//                         Reza 08/2001 
// -----------------------------------------------------------------

class RzProcSampleCounter {
public:
  RzProcSampleCounter();
  virtual       ~RzProcSampleCounter();
  virtual long  ProcessedSampleCount() = 0;
  virtual long  SampleBegin() = 0;
  virtual long  SampleEnd() = 0;
  virtual long  PrintStats();
  inline int &  PrintRate(int pr) { return _rate; } 
  inline string& InfoMessage() { return _msg; } 
protected:
  int _rate;
  string _msg;
};

template <class T>
class ProcSampleCounter : public RzProcSampleCounter {
public:
  ProcSampleCounter(T & t) { _t = &t; } 
  virtual long  ProcessedSampleCount()
  { return _t->ProcessedSampleCount(); }
  virtual long  SampleBegin() { return _t->getMinIn(); }
  virtual long  SampleEnd() { return _t->getMaxIn(); }
protected:
  T * _t;
};




#endif























