// Module PI : Peida Interactive     PIDrawer
// Classe de traceurs pouvant tre attachs  une PIBaseWdg
//	      E. Aubourg , R.Ansari     96-98
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include "machdefs.h"
#include <strings.h>
#include <iostream.h>
#include "pidrawer.h"
#include "pidrwtools.h"

#include "ucckprot.h"


//++
// Class	PIDrawer
// Lib		PI
// include	pidrawer.h
//
//	Classe pour la cration d'objets, capables de se dessiner
//	dans une composante graphique ("PIBaseWdg").
//--
//++
// Links	Voir
// PIBaseWdg
//--

//++
// Titre	Constructeurs et mthodes
//--

//++
// PIDawer()
//	Constructeur.
//--

PIDrawer::PIDrawer()
{
  mFgDeleteOnDetach = false;
  mFgRefreshOnDelete = false;
  mBWdg = NULL; 
  mGrUC = NULL;
  xW0 = yW0 = 0; xWd = yWd = 100; 
  aXdir = false;  // Vrai si Axe X de Droite vers Gauche 
  aYdir = false;  // Vrai si Axe Y de Haut vers Bas
  aXlog = aYlog = false;   // Vrai -> echelle axe logarithmique
  SetLimits(-1, 1, -1, 1, kAxeDirLtoR, kAxeDirDownUp);
  limitsFixed = 0;
  SetAxesFlags(kAxesNone);   // Pas de trace d'axes par defaut 
  SetAxesAutoFontSize();

  mDndfg = false;  // Pour controle de l'appel de Detach() si delete

  mFgHighLight = false;  // Flag de control d'affichage en mode HighLight


  // Nom par defaut : Le nom de la classe
  //  mName = typeid(*this).name();
  mName = "PIDrawer";
  // Par defaut, pas de fenetre de controle specifique
  mFgSpecContWind = false;
}

PIDrawer::~PIDrawer()
{
  // Desactivation totale de la fenetre de controle specialise 
  // ---> parametre d'appel PIBaseWdgGen* wdg=NULL
  // DeactivateControlWindow(NULL);
  // Il semble qu'a ce niveau d'appel du desctructeur,
  // la table des fonctions virtuelles soit alterees et 
  // la fonction virtuelle DeactivateControlWindow() pointe sur celle
  // de base - DeactivateControlWindow(NULL) doit donc etre appele
  // ds le destructeur de la classe derivee 
  //                    Reza - Octobre 2002 

  // Mise a jour eventuelle de la fenetre PIDrwTools
  bool ckdeact = (PIDrwTools::GetActiveDrawer() == this) ? true : false;

  list<DrwBWId>::iterator it;
  mDndfg = true;
  for(it = mBWdgList.begin(); it != mBWdgList.end(); it++) {
    (*it).wdg->RemoveDrawer((*it).id);
    if (mFgRefreshOnDelete) (*it).wdg->Refresh();
  }
  if (mGrUC)  delete mGrUC;
  if (ckdeact) PIDrwTools::UpdateActiveDrawer();
}

//++
// Titre	Les axes
//--
//++
// void  SetLimits(double xmin, double xmax, double ymin, double ymax, -
//                 int axrl=kAxeDirSame, int ayud=kAxeDirSame)
//	Dfinit les limites du systme de coordonnes.
//|	kAxeDirSame , kAxeDirAuto
//|	kAxeDirLtoR , kAxeDirRtoL  (Axe X)
//|	kAxeDirDownUp , kAxeDirUpDown (Axe Y)	
// void  SetLogScale(bool logx, bool logy) 
//	Dfinition d'chelle logarithmique pour les axes X,Y.
// void  GetAxesConfig(int& xa, int& ya) 
//	Renvoie la configuration des axes.
// bool  isLogScaleX()   isLogScaleY() 
//	Renvoie "true" si chelle logarithmique pour axe X , Y
// double XMin()  XMax()
//	Limites de l'axe X
// double YMin()  YMax()
//	Limites de l'axe Y
// void  SetAxesFlags(unsigned int flags=kAxesNone)
//	Attributs de trac d'axes
//|	kStdAxes , kBoxAxes , kTicks , kIntTicks , kExtTicks 
//|	kMajTicks , kMinTicks , kLabels , kGridOn
//|	kAxesDflt , kAxesNone
// unsigned int GetAxesFlags()
//	Renvoie les attributs de trac d'axes  
// void  DrawAxes(PIGraphicUC* g)
//	Mthode de trac des axes
//--

void
PIDrawer::SetLimits(double xmin, double xmax, double ymin, double ymax,
                    int axrl, int ayud)
{
  if (axrl == kAxeDirAuto) {
    double ff;
    if (xmax < xmin)  { axrl = kAxeDirRtoL;   ff=xmin;  xmin=xmax;  xmax=ff; }
    else  axrl = kAxeDirLtoR;
  }
  if (ayud == kAxeDirAuto) {
    double ff;
    if (ymax < ymin)  { ayud = kAxeDirUpDown;   ff=ymin;  ymin=ymax;  ymax=ff; }
    else  ayud = kAxeDirDownUp;
  }
//  if (xmax <= xmin || ymax <= ymin) {  
//    cerr << "PIDrawer::SetLimits() Error - xmax <= xmin  || ymax <= ymin ! " << endl;
//    return; 
//    }
  
  if (!UC_CheckFinite(xmin, xmax) || !UC_CheckFinite(ymin, ymax)) {
    cerr << "PIDrawer::SetLimits() Error - Non finite value for x/ymin-max ! " << endl;
    return; 
    }

  if (axrl == kAxeDirLtoR)  aXdir = false;
  else if (axrl == kAxeDirRtoL)  aXdir = true;
  if (ayud == kAxeDirDownUp)  aYdir = false;
  else if (ayud == kAxeDirUpDown)  aYdir = true;
  //  cerr << " DBG-SetLimits xmax-xmin= " << xmax-xmin << " xmin,max=" 
  //     << xmin << "," << xmax << endl;
  UC_CheckMinMaxDiff(xmin, xmax);
  //cerr << " DBG-SetLimits ymax-ymin= " << ymax-ymin << " ymin,max=" 
  //     << ymin << "," << ymax << endl;
  UC_CheckMinMaxDiff(ymin, ymax);
  xMin = xmin;
  xMax = xmax;
  yMin = ymin;
  yMax = ymax;
  aXFlg = axrl;  aYFlg = ayud;
  limitsFixed = 1;
}


void
PIDrawer::GetAxesConfig(int& xa, int& ya)
{
xa = (aXdir) ? kAxeDirRtoL : kAxeDirLtoR;
ya = (aYdir) ? kAxeDirUpDown : kAxeDirDownUp;
}

//++
//  void  Draw(PIGraphicUC* g, double xmin, double ymin, double xmax, double ymax)
//	Mthode qui est appel lorsquer l'objet PIDrawer doit rafraichir la zone
//	dfinie par "xmin-xmax" , "ymin-ymax" dans le systme de coordonnes du
//	PIDrawer.
//  void  Refresh()
//	Rafrachit le dessin du PIDrawer sur tous les PIBaseWdg auxquel il est attach.
//  void  UpdateLimits()
//	Cette mthode doit calculer les limites (X/Y Min-Max) prferes par l'objet
//	et doit appeler "SetLimits()". L'implementation par dfaut ne fait rien.
//  void  HighLight(bool fgh)
//      Rafraichit le dessin du PIDrawer sur tous les PIBaseWdg auxquel il est attach,
//	en mode "HighLight" si "fgh==true", en mode normal sinon.
//  void  AppendTextInfo(string& info, double xmin, double ymin, double xmax, double ymax)
//	Mthode qui met  jour la chane "info", avec les informations (textuelles) de 
//	la zone dfinie par "xmin-xmax" , "ymin-ymax".
//--

void
PIDrawer::UpdateLimits()
{
// Ne fait rien !
  return;
}

void
PIDrawer::Refresh()
{
  list<DrwBWId>::iterator it;
  for(it = mBWdgList.begin(); it != mBWdgList.end(); it++)
         (*it).wdg->CallDrawer((*it).id);

}
void
PIDrawer::HighLight(bool fgh)
{
  mFgHighLight = fgh;
  Refresh();
  mFgHighLight = false;
}

//++
// Titre	Les attributs graphiques
//--
//++
// void  SetColAtt(PIColors fg=PI_NotDefColor, PIColors bg=PI_NotDefColor)
//	Modifie la couleur d'avant-plan et de fond par dfaut
// void  SetLineAtt(PILineAtt lat=PI_NotDefLineAtt)
//	Modifie l'attribut type de ligne
// void  SetFontAtt(PIFontSize fsz=PI_NotDefFontSize, PIFontAtt fat=PI_NotDefFontAtt)
//	Selection taille et attribut de fonte 
// void  SetFont(PIFontName fn, PIFontSize fsz=PI_NotDefFontSize, PIFontAtt fat=PI_NotDefFontAtt)
//	Selection de type, taile et attribut de fonte
// void  SetMarkerAtt(int sz=-1, PIMarker mrk=PI_NotDefMarker)
//	L'attribut type et taille de marker
// void  SetColMapId(CMapId cid=CMAP_OTHER, bool rev=false)
//	L'attribut choix de la table de couleurs, et son flag d'inversion
// void  SelGraAtt(PIGraphicUC* g)
//	Modifie les attributs graphiques de "g"  partir des attributs courant
//	de l'objet "PIDrawer"
// 
// PIColors  GetFgColAtt()
//	Renvoie l'attribut de couleur d'avant-plan
// PIColors  GetBgColAtt()
//	Renvoie l'attribut de couleur d'arrire-plan
// PILineAtt  GetLineAtt()
//	Renvoie l'attribut de ligne
// PIFontSize GetFontSz()
//	Renvoie l'attribut de taille de fonte
// PIFontAtt  GetFontAtt()
//	Renvoie l'attribut de type de fonte
// int  GetMarkerSz()
//	Renvoie l'attribut de taille de marker
// PIMarker GetMarker()
//	Renvoie l'attribut de type de marker
// CMapId GetColMapId()
//	Renvoie l'attribut de type de table de couleur
// CMapId GetColMapId(bool & rev)
//	Renvoie l'attribut de type de table de couleur, 
//	et le flag d'inversion de la table de couleur
//--


void 
PIDrawer::SelGraAtt(PIGraphicUC* g)
{
  PIColors fcol = GetGraphicAtt().GetFgColor(); 
  if (fcol != PI_NotDefColor)    g->SelForeground(fcol);
  PIColors bcol = GetGraphicAtt().GetBgColor(); 
  if (bcol != PI_NotDefColor)    g->SelBackground(bcol);
  if (GetGraphicAtt().GetLineAtt() != PI_NotDefLineAtt)  
    g->SelLine(GetGraphicAtt().GetLineAtt());
  if ( (GetGraphicAtt().GetFontName() != PI_DefaultFont) ||
       (GetGraphicAtt().GetFontAtt() != PI_NotDefFontAtt) )
    g->SelFont(GetGraphicAtt().GetFont());
  if (GetGraphicAtt().GetMarker() != PI_NotDefMarker) 
    g->SelMarker(GetGraphicAtt().GetMarkerSize(), GetGraphicAtt().GetMarker());
  if (GetGraphicAtt().GetArrowMarker() !=  PI_NotDefArrowMarker) 
    g->SelArrowMarker(GetGraphicAtt().GetArrowMarkerSize(), 
		      GetGraphicAtt().GetArrowMarker());
}


void
PIDrawer::Attach(PIBaseWdgGen* wdg, int id)
{
  if (!wdg) return;
  DrwBWId bwi;
  bwi.id = id;  bwi.wdg = wdg;
  mBWdgList.push_back(bwi);
  return;
}

void
PIDrawer::Detach(PIBaseWdgGen* wdg, int id)
{
  if (mDndfg) return;
  if (!wdg) return;

  // Desactivation de la fenetre de controle specialisee pour la 
  // base-widget duquel on se detache 
  DeactivateControlWindow(wdg);
  
  // Mise a jour eventuelle de la fenetre PIDrwTools
  bool ckdeact = (PIDrwTools::GetActiveDrawer() == this) ? true : false;

  list<DrwBWId>::iterator it;
  for(it = mBWdgList.begin(); it != mBWdgList.end(); it++)
     if ( ((*it).id == id) && ((*it).wdg == wdg) ) { mBWdgList.erase(it);  break; }
  if (mFgDeleteOnDetach && (mBWdgList.size() == 0))  delete this;

  if (ckdeact) PIDrwTools::UpdateActiveDrawer();
  return;
}

void
PIDrawer::ShowControlWindow(PIBaseWdgGen* wdg)
{
  // On affiche par defaut la fenetre de gestion des attributs graphiques
   PIDrwTools::ShowPIDrwTools(wdg);
}

//--------------------------------------------------------------
// Methode de desactivation de la fenetre de controle specialise
// Cette methode est appellee dans deux cas :
// 1/ lors de la destruction du drawer
//    Dans ce cas, le parametre PIBaseWdgGen* wdg = NULL
// 2/ Lorsque le drawer est detache d'un PIBaseWdg 
//    Dans ce cas, le parametre PIBaseWdgGen* wdg pointe vers le 
//    PIBaseWdg duquel le drawer est detache
// Evidemment, "this" pointe toujours sur le drawer qui est 
// en cours de destruction ou de detachement
//--------------------------------------------------------------
void
PIDrawer::DeactivateControlWindow(PIBaseWdgGen* wdg)
{
  // La mise a jour eventuelle de PIDrwTools se fait 
  // directement lors de Detach() ou delete 
  // La methode par defaut ne fait donc rien 
}

int
PIDrawer::DecodeOptionString(vector<string> & opt, bool rmdecop)
{
  if (opt.size() < 1)  return(0);  
  PIGraphicAtt gratt;
  int ndec = gratt.DecodeAttStrings(opt, rmdecop);
  UpdateGraphicAtt(gratt);
  return(ndec);
}

void
PIDrawer::GetOptionsHelpInfo(string& info)
{
  info += " ------- PIDrawer options help info ---------- \n";
  info += ">> Colors: defcol black white grey red blue green yellow \n";
  info += "           magenta cyan turquoise navyblue orange siennared purple \n";
  info += "           limegreen gold violet violetred blueviolet darkviolet \n";
  info += ">> Lines:  defline normalline thinline thickline dashedline thindashedline \n";
  info += "           thickdashedline dottedline thindottedline thickdottedline \n";
  info += ">> Font Att: deffontatt normalfont boldfont italicfont bolditalicfont  \n";
  info += "             smallfont smallboldfont smallitalicfont smallbolditalicfont \n";
  info += "             bigfont bigboldfont bigitalicfont bigbolditalicfont \n";
  info += "             hugefont  hugeboldfont hugeitalicfont hugebolditalicfont \n";
  info += ">> Font Names: deffont courierfont helveticafont timesfont symbolfont  \n";
  info += ">> Marker: dotmarker<S>  plusmarker<S>  crossmarker<S> circlemarker <S> \n";
  info += "           fcirclemarker<S> boxmarker<S> fboxmarker<S> trianglemarker<S> \n";
  info += "           ftrianglemarker<S>  starmarker<S>  fstarmarker<S> \n";
  info += "   with <S> = 1 3 5 7 9 , Example fboxmarker5 , plusmarker9 ... \n";
  info += ">> ColorTables: defcmap  grey32  invgrey32  colrj32  colbr32 \n";
  info += "                grey128  invgrey128  colrj128  colbr128 \n";
  info += "                midas_pastel midas_heat midas_rainbow3 midas_bluered\n";
  info += "                midas_bluewhite midas_redwhite \n";
  info += "                rainbow16 \n";
  info += "   revcmap : This flag reverses ColorMap indexing \n";
  return;
}

PIGraphicUC*
PIDrawer::SetDrwWdg(PIBaseWdgGen* drw, int x0, int y0, int dx, int dy, PIGraphicGen* g)
{
  mBWdg = drw;
  xW0 = x0;   yW0 = y0;
  xWd = dx;   yWd = dy;
  if (mGrUC)  delete mGrUC;
  mGrUC = new PIGraphicUC(g, x0, y0, dx, dy);
  mGrUC->SetUCS(xMin, xMax, yMin, yMax, aXFlg, aYFlg);
  if (aXlog || aYlog) mGrUC->SetLogScale(aXlog, aYlog);
  if (mFgHighLight) mGrUC->SelGOMode(PI_GOInvert); // $CHECK$ A changer , Reza 07/2001
  return(mGrUC);
}

void
PIDrawer::SetAxesFlags(unsigned int flags)
{
  axesFlags = flags;
  if (axesFlags & (kIntTicks | kExtTicks | kMajTicks | kMinTicks))
    axesFlags |= kTicks;
  if ((axesFlags & (kTicks | kIntTicks | kExtTicks)) == kTicks)
    axesFlags |= kIntTicks | kExtTicks;
  if ((axesFlags & (kTicks | kMajTicks | kMinTicks)) == kTicks)
    axesFlags |= kMajTicks;
}


void
PIDrawer::DrawAxes(PIGraphicUC* g)
{
  g->NoClip();
  PIAxes axes;
  axes.DrawXYAxes(g, mGrAtt, axesFlags, axesAFSz, XMin(), XMax(), YMin(), YMax()); 
  g->Clip();
}

  

void
PIDrawer::Draw(PIGraphicUC* g, double /*xmin*/, double /*ymin*/, double /*xmax*/, double /*ymax*/)
{
}

void
PIDrawer::AppendTextInfo(string& info, double /*xmin*/, double /*ymin*/, double /*xmax*/, double /*ymax*/)
{
}

void
PIDrawer::GetClickInfo(string& info,double x,double y,double x0,double y0,bool fgdiff)
{
}
