
// main genere automatiquement par xsl
// ne pas modifier
// derniere mise a jour : VF le 29/10/2002 -- derniere version

// inclusions expat
#include <stdio.h>
#include "expat.h"

// inclusions c++
#include <string>
#include "config.h"
#include <map>
using namespace std;
#include <iostream.h>
#include "toi.h"
#include "toiprocessor.h"
#include "toimanager.h"
#include "toisegment.h"
#include "sophyainit.h"
#include <stdexcept>

#ifndef MAXINT
#define MAXINT 2147483647
#endif

#include "fitstoirdr.h"
#include "fitstoiwtr.h"
#include "smoothtoi.h"
#include "toi2map.h"
#include "map2toi.h"
#include "flag2map.h"
#include "rztoi.h"
#include "rztoi.h"
#include "noisegen.h"
#include "noisegen.h"
#include "noisegen.h"
#include "meanvarestim.h"
#include "demopipe.h"

// classe de gestion des balises en design patern object call-back
class ToiPipe
{
public:
  ToiPipe(void);
  virtual ~ToiPipe();
  static void startElement(void *userData, const char *name, const char **atts);
  static void endElement(void *userData, const char *name);
private:
  // pour concordances instances - nom
  map<string,TOIProcessor*> toiProc;
  string id; 
  // gestionnaire de TOI
  TOIManager* mgr;
  void startElementC(const char *name, const char **atts);
  void endElementC(const char *name);
};



ToiPipe::ToiPipe()
{
 // Ouverture du gestionnaire de TOI.
 mgr = TOIManager::getManager();
 // initialisation du processeur courant
 id="";

}

ToiPipe::~ToiPipe()
{

}

void ToiPipe::startElement(void *userData, const char *name, const char **atts)
{
  ToiPipe *toiPipe = (ToiPipe*) userData;
  toiPipe->startElementC(name, atts);
}

void ToiPipe::endElement(void *userData, const char *name)
{
  ToiPipe* toiPipe = (ToiPipe*) userData;
  toiPipe->endElementC(name);
}


void ToiPipe::startElementC(const char *name, const char **atts)
{
  int i;
  //puts(name);

  // filtrage des balises
  if ((string)name == "connect") {
    // mise en ordre des arguments
    string nom;
    TOIProcessor* procin=NULL;
    TOIProcessor* procout=NULL;
    string input;
    string output;
    int taille = 1024;
    bool writeflag = false;
    for (i=0; atts[i]; i+=2) {
      if ((string)atts[i] == "name") {
	nom=atts[i+1];
      }
      if ((string)atts[i] == "procin") {
	map<string,TOIProcessor*>::iterator j=toiProc.find(atts[i+1]);
	if (j != toiProc.end()) { 
	  procin = (*j).second;
	} else {
	   throw ParmError("Connect error: processor in not found");
	}
      }
      if ((string)atts[i] == "procout") {
	map<string,TOIProcessor*>::iterator j=toiProc.find(atts[i+1]);
	if (j != toiProc.end()) {
	  procout = (*j).second;
	} else {
	   throw ParmError("Connect error: processor out not found");
	}
      }
      if ((string)atts[i] == "input") {
	input = atts[i+1];
      }
      if ((string)atts[i] == "output") {
	output = atts[i+1];
      }
    }    
    // connection automatique des toiprocesseurs    
    if (procin != NULL && procout != NULL ) {
      cout << "connect " << output << " " << input << endl;
      mgr->connect(*procout, output, *procin, input, nom, taille, writeflag);
       cout << "connect done" << endl;
    }

  } else if ((string)name == "constraint") {                                // si balise de contrainte     
    TOIProcessor* proc=NULL;
    int min=0;
    int max=MAXINT;
    for (i=0; atts[i]; i+=2) {
      if ((string)atts[i] =="proc") {
        map<string,TOIProcessor*>::iterator j=toiProc.find(atts[i+1]);
	if (j != toiProc.end()) { 
	  proc = (*j).second;
	} else {
	  throw ParmError("Constraint error: processor not found");
	}
      }
      if ((string)atts[i] == "min") {
        min = atoi(atts[i+1]);
      }
      if ((string)atts[i] == "max") {
        max = atoi(atts[i+1]);
      } 
    }
    cout << "setting " << proc << " " << min << " " << max << endl;
    proc->setRequestedSample(min, max);
    cout << "constraint done" << endl;
  
  } else if ((string)name == "start") {                                     // si balise de demarrage 
    cout << "***** Starting execution *****" << endl;
    mgr->startAll();
    // Gestion de la re-connection des threads
    cout<<"***** Joining threads *****"<<endl;
    mgr->joinAll();
    cout<<"***** End threads *****"<<endl; 
    // destruction du toimanager et des processeurs a implementer dans toimanager pour l'utilisation de plusieurs start
    //TOIManager::~toimanager();
    //toiProc.clear();
  
  } else if (id == "") {                                            // si nouveau processeur

  if ((string)name == "fitsreader") {
    string fn;
    
	
    // gestion des arguments du constructeur
    for (i=0; atts[i]; i+=2) {
      // var pour instanciation
        if ((string)atts[i] == "id") {
            id=atts[i+1];
      	}
	
	//initialisation des arguments par defaut si existants
	fn = "test.fits";
	   

	// mise a jour des arguments
	
	if ((string)atts[i] == "fn") {
	   fn = atts[i+1];
	     
	}
    	
      }
   
    // creation du toiprocesseur
    toiProc[id] = new FITSTOIReader (fn);
  }

  if ((string)name == "fitswriter") {
    string fn;
    
	
    // gestion des arguments du constructeur
    for (i=0; atts[i]; i+=2) {
      // var pour instanciation
        if ((string)atts[i] == "id") {
            id=atts[i+1];
      	}
	
	//initialisation des arguments par defaut si existants
	

	// mise a jour des arguments
	
	if ((string)atts[i] == "fn") {
	   fn = atts[i+1];
	     
	}
    	
      }
   
    // creation du toiprocesseur
    toiProc[id] = new FITSTOIWriter (fn);
  }

  if ((string)name == "smooth") {
    uint_4 lsm;
    uint_4 deg;
    
	
    // gestion des arguments du constructeur
    for (i=0; atts[i]; i+=2) {
      // var pour instanciation
        if ((string)atts[i] == "id") {
            id=atts[i+1];
      	}
	
	//initialisation des arguments par defaut si existants
	

	// mise a jour des arguments
	
	if ((string)atts[i] == "lsm") {
	   lsm = atoi(atts[i+1]);
	     
	}
    	
	if ((string)atts[i] == "deg") {
	   deg = atoi(atts[i+1]);
	     
	}
    	
      }
   
    // creation du toiprocesseur
    toiProc[id] = new DataSmooth (lsm, deg);
  }

  if ((string)name == "toi2map") {
    string map;
    string wmap;
    
	
    // gestion des arguments du constructeur
    for (i=0; atts[i]; i+=2) {
      // var pour instanciation
        if ((string)atts[i] == "id") {
            id=atts[i+1];
      	}
	
	//initialisation des arguments par defaut si existants
	wmap = "NULL";
	   

	// mise a jour des arguments
	
	if ((string)atts[i] == "map") {
	   map = atts[i+1];
	     
	}
    	
	if ((string)atts[i] == "wmap") {
	   wmap = atts[i+1];
	     
	}
    	
      }
   
    // creation du toiprocesseur
    toiProc[id] = new TOI2Map (map, wmap);
  }

  if ((string)name == "map2toi") {
    string sph;
    
	
    // gestion des arguments du constructeur
    for (i=0; atts[i]; i+=2) {
      // var pour instanciation
        if ((string)atts[i] == "id") {
            id=atts[i+1];
      	}
	
	//initialisation des arguments par defaut si existants
	

	// mise a jour des arguments
	
	if ((string)atts[i] == "sph") {
	   sph = atts[i+1];
	     
	}
    	
      }
   
    // creation du toiprocesseur
    toiProc[id] = new Map2TOI (sph);
  }

  if ((string)name == "flag2map") {
    string map;
    string wmap;
    
	
    // gestion des arguments du constructeur
    for (i=0; atts[i]; i+=2) {
      // var pour instanciation
        if ((string)atts[i] == "id") {
            id=atts[i+1];
      	}
	
	//initialisation des arguments par defaut si existants
	wmap = "NULL";
	   

	// mise a jour des arguments
	
	if ((string)atts[i] == "map") {
	   map = atts[i+1];
	     
	}
    	
	if ((string)atts[i] == "wmap") {
	   wmap = atts[i+1];
	     
	}
    	
      }
   
    // creation du toiprocesseur
    toiProc[id] = new FLAG2Map (map, wmap);
  }

  if ((string)name == "rztoiproc") {
    int w1;
    int w2;
    int nmax;
    
	
    // gestion des arguments du constructeur
    for (i=0; atts[i]; i+=2) {
      // var pour instanciation
        if ((string)atts[i] == "id") {
            id=atts[i+1];
      	}
	
	//initialisation des arguments par defaut si existants
	w1 = 4096;
	   w2 = 128;
	   nmax = 20;
	   

	// mise a jour des arguments
	
	if ((string)atts[i] == "w1") {
	   w1 = atoi(atts[i+1]);
	     
	}
    	
	if ((string)atts[i] == "w2") {
	   w2 = atoi(atts[i+1]);
	     
	}
    	
	if ((string)atts[i] == "nmax") {
	   nmax = atoi(atts[i+1]);
	     
	}
    	
      }
   
    // creation du toiprocesseur
    toiProc[id] = new RzTOIProc (w1, w2, nmax);
  }

  if ((string)name == "rzsimpletoiproc") {
    int wsz;
    double fact;
    
	
    // gestion des arguments du constructeur
    for (i=0; atts[i]; i+=2) {
      // var pour instanciation
        if ((string)atts[i] == "id") {
            id=atts[i+1];
      	}
	
	//initialisation des arguments par defaut si existants
	wsz = 1024;
	   fact = 1.0;
	   

	// mise a jour des arguments
	
	if ((string)atts[i] == "wsz") {
	   wsz = atoi(atts[i+1]);
	     
	}
    	
	if ((string)atts[i] == "fact") {
	   fact = atof(atts[i+1]);
	     
	}
    	
      }
   
    // creation du toiprocesseur
    toiProc[id] = new RzSimpleTOIProc (wsz, fact);
  }

  if ((string)name == "noisegen") {
    
	
    // gestion des arguments du constructeur
    for (i=0; atts[i]; i+=2) {
      // var pour instanciation
        if ((string)atts[i] == "id") {
            id=atts[i+1];
      	}
	
	//initialisation des arguments par defaut si existants
	

	// mise a jour des arguments
	
      }
   
    // creation du toiprocesseur
    toiProc[id] = new NoiseGen ();
  }

  if ((string)name == "noisegengauss") {
    float sigma;
    
	
    // gestion des arguments du constructeur
    for (i=0; atts[i]; i+=2) {
      // var pour instanciation
        if ((string)atts[i] == "id") {
            id=atts[i+1];
      	}
	
	//initialisation des arguments par defaut si existants
	

	// mise a jour des arguments
	
	if ((string)atts[i] == "sigma") {
	   sigma = atof(atts[i+1]);
	     
	}
    	
      }
   
    // creation du toiprocesseur
    toiProc[id] = new NoiseGenGauss (sigma);
  }

  if ((string)name == "noisegen00F") {
    float fknee;
    float sigma;
    
	
    // gestion des arguments du constructeur
    for (i=0; atts[i]; i+=2) {
      // var pour instanciation
        if ((string)atts[i] == "id") {
            id=atts[i+1];
      	}
	
	//initialisation des arguments par defaut si existants
	

	// mise a jour des arguments
	
	if ((string)atts[i] == "fknee") {
	   fknee = atof(atts[i+1]);
	     
	}
    	
	if ((string)atts[i] == "sigma") {
	   sigma = atof(atts[i+1]);
	     
	}
    	
      }
   
    // creation du toiprocesseur
    toiProc[id] = new NoiseGenOOF (fknee, sigma);
  }

  if ((string)name == "meanvarestimator") {
    int nsamp;
    
	
    // gestion des arguments du constructeur
    for (i=0; atts[i]; i+=2) {
      // var pour instanciation
        if ((string)atts[i] == "id") {
            id=atts[i+1];
      	}
	
	//initialisation des arguments par defaut si existants
	

	// mise a jour des arguments
	
	if ((string)atts[i] == "nsamp") {
	   nsamp = atoi(atts[i+1]);
	     
	}
    	
      }
   
    // creation du toiprocesseur
    toiProc[id] = new MeanVarEstimator (nsamp);
  }

  if ((string)name == "demopipe") {
    
	
    // gestion des arguments du constructeur
    for (i=0; atts[i]; i+=2) {
      // var pour instanciation
        if ((string)atts[i] == "id") {
            id=atts[i+1];
      	}
	
	//initialisation des arguments par defaut si existants
	

	// mise a jour des arguments
	
      }
   
    // creation du toiprocesseur
    toiProc[id] = new DemoPipe ();
  }
  

  } else {                                           // sinon c une methode
    // gestion des methodes 

  if (id == "fitsreader") {
    
  }

  if (id == "fitswriter") {
    
  }

  if (id == "smooth") {
    
    if ((string)name == "DoNotLookAt") {
    uint_8 flag;
    
	
    // gestion des arguments de la methode
    for (i=0; atts[i]; i+=2) {     
	//initialisation des arguments par defaut si existants
	flag = FlgToiAll;
	   

	// mise a jour des arguments
	
	if ((string)atts[i] == "flag") {
	   flag = atoi(atts[i+1]);
	   
	}
    	
      }
   
    // appelle de la methode du processeur concerne
    ((DataSmooth*)toiProc[id])->DoNotLookAt (flag); 
    }
    
    if ((string)name == "SetFlagFailed") {
    uint_8 flag;
    
	
    // gestion des arguments de la methode
    for (i=0; atts[i]; i+=2) {     
	//initialisation des arguments par defaut si existants
	flag = FlgToiInterp;
	   

	// mise a jour des arguments
	
	if ((string)atts[i] == "flag") {
	   flag = atoi(atts[i+1]);
	   
	}
    	
      }
   
    // appelle de la methode du processeur concerne
    ((DataSmooth*)toiProc[id])->SetFlagFailed (flag); 
    }
    
    if ((string)name == "SetBuff") {
    uint_4 bupd;
    
	
    // gestion des arguments de la methode
    for (i=0; atts[i]; i+=2) {     
	//initialisation des arguments par defaut si existants
	bupd = 100;
	   

	// mise a jour des arguments
	
	if ((string)atts[i] == "bupd") {
	   bupd = atoi(atts[i+1]);
	   
	}
    	
      }
   
    // appelle de la methode du processeur concerne
    ((DataSmooth*)toiProc[id])->SetBuffUpd (bupd); 
    }
    
    if ((string)name == "MinSmoothLength") {
    uint_4 lsmin;
    
	
    // gestion des arguments de la methode
    for (i=0; atts[i]; i+=2) {     
	//initialisation des arguments par defaut si existants
	lsmin = 0;
	   

	// mise a jour des arguments
	
	if ((string)atts[i] == "lsmin") {
	   lsmin = atoi(atts[i+1]);
	   
	}
    	
      }
   
    // appelle de la methode du processeur concerne
    ((DataSmooth*)toiProc[id])->MinSmoothLength (lsmin); 
    }
    
  }

  if (id == "toi2map") {
    
    if ((string)name == "SetEquinox") {
    double actualyear;
    
	
    // gestion des arguments de la methode
    for (i=0; atts[i]; i+=2) {     
	//initialisation des arguments par defaut si existants
	actualyear = 2000;
	   

	// mise a jour des arguments
	
	if ((string)atts[i] == "actualyear") {
	   actualyear = atof(atts[i+1]);
	   
	}
    	
      }
   
    // appelle de la methode du processeur concerne
    ((TOI2Map*)toiProc[id])->SetEquinox (actualyear); 
    }
    
    if ((string)name == "SetCoorIn") {
    long mfg;
    
	
    // gestion des arguments de la methode
    for (i=0; atts[i]; i+=2) {     
	//initialisation des arguments par defaut si existants
	mfg = TypCoordGalStd;
	   

	// mise a jour des arguments
	
	if ((string)atts[i] == "mfg") {
	   mfg = atoi(atts[i+1]);
	   
	}
    	
      }
   
    // appelle de la methode du processeur concerne
    ((TOI2Map*)toiProc[id])->SetCoorIn (mfg); 
    }
    
    if ((string)name == "SetCoorInChr") {
    char* ctype;
    
	
    // gestion des arguments de la methode
    for (i=0; atts[i]; i+=2) {     
	//initialisation des arguments par defaut si existants
	

	// mise a jour des arguments
	
	if ((string)atts[i] == "ctype") {
	   ctype = atts[i+1];
	   
	}
    	
      }
   
    // appelle de la methode du processeur concerne
    ((TOI2Map*)toiProc[id])->SetCoorIn (ctype); 
    }
    
    if ((string)name == "SetCoorMap") {
    long mfg;
    
	
    // gestion des arguments de la methode
    for (i=0; atts[i]; i+=2) {     
	//initialisation des arguments par defaut si existants
	mfg = TypCoordGal;
	   

	// mise a jour des arguments
	
	if ((string)atts[i] == "mfg") {
	   mfg = atoi(atts[i+1]);
	   
	}
    	
      }
   
    // appelle de la methode du processeur concerne
    ((TOI2Map*)toiProc[id])->SetCoorMap (mfg); 
    }
    
    if ((string)name == "SetCoorMapChr") {
    char* ctype;
    
	
    // gestion des arguments de la methode
    for (i=0; atts[i]; i+=2) {     
	//initialisation des arguments par defaut si existants
	

	// mise a jour des arguments
	
	if ((string)atts[i] == "ctype") {
	   ctype = atts[i+1];
	   
	}
    	
      }
   
    // appelle de la methode du processeur concerne
    ((TOI2Map*)toiProc[id])->SetCoorMap (ctype); 
    }
    
    if ((string)name == "SetCalibrationFactor") {
    double fac;
    
	
    // gestion des arguments de la methode
    for (i=0; atts[i]; i+=2) {     
	//initialisation des arguments par defaut si existants
	fac = 1.;
	   

	// mise a jour des arguments
	
	if ((string)atts[i] == "fac") {
	   fac = atof(atts[i+1]);
	   
	}
    	
      }
   
    // appelle de la methode du processeur concerne
    ((TOI2Map*)toiProc[id])->SetCalibrationFactor (fac); 
    }
    
    if ((string)name == "SetTestFlag") {
    bool tflg;
    long badflg;
    
	
    // gestion des arguments de la methode
    for (i=0; atts[i]; i+=2) {     
	//initialisation des arguments par defaut si existants
	tflg = "false";
	   badflg = FlgToiAll;
	   

	// mise a jour des arguments
	
	if ((string)atts[i] == "tflg") {
	   tflg = atts[i+1];
	   
	}
    	
	if ((string)atts[i] == "badflg") {
	   badflg = atoi(atts[i+1]);
	   
	}
    	
      }
   
    // appelle de la methode du processeur concerne
    ((TOI2Map*)toiProc[id])->SetTestFlag (tflg, badflg); 
    }
    
    if ((string)name == "SetTestMin") {
    bool tmin;
    double vmin;
    
	
    // gestion des arguments de la methode
    for (i=0; atts[i]; i+=2) {     
	//initialisation des arguments par defaut si existants
	tmin = "false";
	   vmin = -1.e30;
	   

	// mise a jour des arguments
	
	if ((string)atts[i] == "tmin") {
	   tmin = atts[i+1];
	   
	}
    	
	if ((string)atts[i] == "vmin") {
	   vmin = atof(atts[i+1]);
	   
	}
    	
      }
   
    // appelle de la methode du processeur concerne
    ((TOI2Map*)toiProc[id])->SetTestMin (tmin, vmin); 
    }
    
    if ((string)name == "SetTestMax") {
    bool tmax;
    double vmax;
    
	
    // gestion des arguments de la methode
    for (i=0; atts[i]; i+=2) {     
	//initialisation des arguments par defaut si existants
	tmax = "false";
	   vmax = +1.e30;
	   

	// mise a jour des arguments
	
	if ((string)atts[i] == "tmax") {
	   tmax = atts[i+1];
	   
	}
    	
	if ((string)atts[i] == "vmax") {
	   vmax = atof(atts[i+1]);
	   
	}
    	
      }
   
    // appelle de la methode du processeur concerne
    ((TOI2Map*)toiProc[id])->SetTestMax (tmax, vmax); 
    }
    
  }

  if (id == "map2toi") {
    
    if ((string)name == "SetBad") {
    long flg;
    
	
    // gestion des arguments de la methode
    for (i=0; atts[i]; i+=2) {     
	//initialisation des arguments par defaut si existants
	flg = FlgToiOut;
	   

	// mise a jour des arguments
	
	if ((string)atts[i] == "flg") {
	   flg = atoi(atts[i+1]);
	   
	}
    	
      }
   
    // appelle de la methode du processeur concerne
    ((Map2TOI*)toiProc[id])->SetBad (flg); 
    }
    
    if ((string)name == "SetEquinox") {
    double actualyear;
    
	
    // gestion des arguments de la methode
    for (i=0; atts[i]; i+=2) {     
	//initialisation des arguments par defaut si existants
	actualyear = 2000;
	   

	// mise a jour des arguments
	
	if ((string)atts[i] == "actualyear") {
	   actualyear = atof(atts[i+1]);
	   
	}
    	
      }
   
    // appelle de la methode du processeur concerne
    ((Map2TOI*)toiProc[id])->SetEquinox (actualyear); 
    }
    
    if ((string)name == "SetCoorIn") {
    long mfg;
    
	
    // gestion des arguments de la methode
    for (i=0; atts[i]; i+=2) {     
	//initialisation des arguments par defaut si existants
	mfg = TypCoordGalStd;
	   

	// mise a jour des arguments
	
	if ((string)atts[i] == "mfg") {
	   mfg = atoi(atts[i+1]);
	   
	}
    	
      }
   
    // appelle de la methode du processeur concerne
    ((Map2TOI*)toiProc[id])->SetCoorIn (mfg); 
    }
    
    if ((string)name == "SetCoorInChr") {
    char* ctype;
    
	
    // gestion des arguments de la methode
    for (i=0; atts[i]; i+=2) {     
	//initialisation des arguments par defaut si existants
	

	// mise a jour des arguments
	
	if ((string)atts[i] == "ctype") {
	   ctype = atts[i+1];
	   
	}
    	
      }
   
    // appelle de la methode du processeur concerne
    ((Map2TOI*)toiProc[id])->SetCoorIn (ctype); 
    }
    
    if ((string)name == "SetCoorMap") {
    long mfg;
    
	
    // gestion des arguments de la methode
    for (i=0; atts[i]; i+=2) {     
	//initialisation des arguments par defaut si existants
	mfg = TypCoordGal;
	   

	// mise a jour des arguments
	
	if ((string)atts[i] == "mfg") {
	   mfg = atoi(atts[i+1]);
	   
	}
    	
      }
   
    // appelle de la methode du processeur concerne
    ((Map2TOI*)toiProc[id])->SetCoorMap (mfg); 
    }
    
    if ((string)name == "SetCoorMapChr") {
    char* ctype;
    
	
    // gestion des arguments de la methode
    for (i=0; atts[i]; i+=2) {     
	//initialisation des arguments par defaut si existants
	

	// mise a jour des arguments
	
	if ((string)atts[i] == "ctype") {
	   ctype = atts[i+1];
	   
	}
    	
      }
   
    // appelle de la methode du processeur concerne
    ((Map2TOI*)toiProc[id])->SetCoorMap (ctype); 
    }
    
  }

  if (id == "flag2map") {
    
    if ((string)name == "SetEquinox") {
    double actualyear;
    
	
    // gestion des arguments de la methode
    for (i=0; atts[i]; i+=2) {     
	//initialisation des arguments par defaut si existants
	actualyear = 2000;
	   

	// mise a jour des arguments
	
	if ((string)atts[i] == "actualyear") {
	   actualyear = atof(atts[i+1]);
	   
	}
    	
      }
   
    // appelle de la methode du processeur concerne
    ((FLAG2Map*)toiProc[id])->SetEquinox (actualyear); 
    }
    
    if ((string)name == "SetCoorIn") {
    long mfg;
    
	
    // gestion des arguments de la methode
    for (i=0; atts[i]; i+=2) {     
	//initialisation des arguments par defaut si existants
	mfg = TypCoordGalStd;
	   

	// mise a jour des arguments
	
	if ((string)atts[i] == "mfg") {
	   mfg = atoi(atts[i+1]);
	   
	}
    	
      }
   
    // appelle de la methode du processeur concerne
    ((FLAG2Map*)toiProc[id])->SetCoorIn (mfg); 
    }
    
    if ((string)name == "SetCoorInChr") {
    char* ctype;
    
	
    // gestion des arguments de la methode
    for (i=0; atts[i]; i+=2) {     
	//initialisation des arguments par defaut si existants
	

	// mise a jour des arguments
	
	if ((string)atts[i] == "ctype") {
	   ctype = atts[i+1];
	   
	}
    	
      }
   
    // appelle de la methode du processeur concerne
    ((FLAG2Map*)toiProc[id])->SetCoorIn (ctype); 
    }
    
    if ((string)name == "SetCoorMap") {
    long mfg;
    
	
    // gestion des arguments de la methode
    for (i=0; atts[i]; i+=2) {     
	//initialisation des arguments par defaut si existants
	mfg = TypCoordGal;
	   

	// mise a jour des arguments
	
	if ((string)atts[i] == "mfg") {
	   mfg = atoi(atts[i+1]);
	   
	}
    	
      }
   
    // appelle de la methode du processeur concerne
    ((FLAG2Map*)toiProc[id])->SetCoorMap (mfg); 
    }
    
    if ((string)name == "SetCoorMapChr") {
    char* ctype;
    
	
    // gestion des arguments de la methode
    for (i=0; atts[i]; i+=2) {     
	//initialisation des arguments par defaut si existants
	

	// mise a jour des arguments
	
	if ((string)atts[i] == "ctype") {
	   ctype = atts[i+1];
	   
	}
    	
      }
   
    // appelle de la methode du processeur concerne
    ((FLAG2Map*)toiProc[id])->SetCoorMap (ctype); 
    }
    
    if ((string)name == "SetCalibrationFactor") {
    double fac;
    
	
    // gestion des arguments de la methode
    for (i=0; atts[i]; i+=2) {     
	//initialisation des arguments par defaut si existants
	fac = 1.;
	   

	// mise a jour des arguments
	
	if ((string)atts[i] == "fac") {
	   fac = atof(atts[i+1]);
	   
	}
    	
      }
   
    // appelle de la methode du processeur concerne
    ((FLAG2Map*)toiProc[id])->SetCalibrationFactor (fac); 
    }
    
    if ((string)name == "SetTestFlag") {
    bool tflg;
    long badflg;
    
	
    // gestion des arguments de la methode
    for (i=0; atts[i]; i+=2) {     
	//initialisation des arguments par defaut si existants
	tflg = "false";
	   badflg = FlgToiAll;
	   

	// mise a jour des arguments
	
	if ((string)atts[i] == "tflg") {
	   tflg = atts[i+1];
	   
	}
    	
	if ((string)atts[i] == "badflg") {
	   badflg = atoi(atts[i+1]);
	   
	}
    	
      }
   
    // appelle de la methode du processeur concerne
    ((FLAG2Map*)toiProc[id])->SetTestFlag (tflg, badflg); 
    }
    
    if ((string)name == "SetTestMin") {
    bool tmin;
    double vmin;
    
	
    // gestion des arguments de la methode
    for (i=0; atts[i]; i+=2) {     
	//initialisation des arguments par defaut si existants
	tmin = "false";
	   vmin = -1.e30;
	   

	// mise a jour des arguments
	
	if ((string)atts[i] == "tmin") {
	   tmin = atts[i+1];
	   
	}
    	
	if ((string)atts[i] == "vmin") {
	   vmin = atof(atts[i+1]);
	   
	}
    	
      }
   
    // appelle de la methode du processeur concerne
    ((FLAG2Map*)toiProc[id])->SetTestMin (tmin, vmin); 
    }
    
    if ((string)name == "SetTestMax") {
    bool tmax;
    double vmax;
    
	
    // gestion des arguments de la methode
    for (i=0; atts[i]; i+=2) {     
	//initialisation des arguments par defaut si existants
	tmax = "false";
	   vmax = +1.e30;
	   

	// mise a jour des arguments
	
	if ((string)atts[i] == "tmax") {
	   tmax = atts[i+1];
	   
	}
    	
	if ((string)atts[i] == "vmax") {
	   vmax = atof(atts[i+1]);
	   
	}
    	
      }
   
    // appelle de la methode du processeur concerne
    ((FLAG2Map*)toiProc[id])->SetTestMax (tmax, vmax); 
    }
    
  }

  if (id == "rztoiproc") {
    
    if ((string)name == "SetOutPPF") {
    string ppfname;
    
	
    // gestion des arguments de la methode
    for (i=0; atts[i]; i+=2) {     
	//initialisation des arguments par defaut si existants
	

	// mise a jour des arguments
	
	if ((string)atts[i] == "ppfname") {
	   ppfname = atts[i+1];
	   
	}
    	
      }
   
    // appelle de la methode du processeur concerne
    ((RzTOIProc*)toiProc[id])->SetOutPPF (ppfname); 
    }
    
  }

  if (id == "rzsimpletoiproc") {
    
  }

  if (id == "noisegen") {
    
  }

  if (id == "noisegengauss") {
    
  }

  if (id == "noisegen00F") {
    
  }

  if (id == "meanvarestimator") {
    
    if ((string)name == "doNotLookAt") {
    long flag;
    
	
    // gestion des arguments de la methode
    for (i=0; atts[i]; i+=2) {     
	//initialisation des arguments par defaut si existants
	flag = FlgToiAll;
	   

	// mise a jour des arguments
	
	if ((string)atts[i] == "flag") {
	   flag = atoi(atts[i+1]);
	   
	}
    	
      }
   
    // appelle de la methode du processeur concerne
    ((MeanVarEstimator*)toiProc[id])->doNotLookAt (flag); 
    }
    
  }

  if (id == "demopipe") {
    
  }

  
  }
  
}


void ToiPipe::endElementC(const char *name)
{
  // verification si une balise processeur est fermee pour la gestion des methodes d'initialisation
  
  if ((string)name == "fitsreader") {
    id="";
  }
  
  if ((string)name == "fitswriter") {
    id="";
  }
  
  if ((string)name == "smooth") {
    id="";
  }
  
  if ((string)name == "toi2map") {
    id="";
  }
  
  if ((string)name == "map2toi") {
    id="";
  }
  
  if ((string)name == "flag2map") {
    id="";
  }
  
  if ((string)name == "rztoiproc") {
    id="";
  }
  
  if ((string)name == "rzsimpletoiproc") {
    id="";
  }
  
  if ((string)name == "noisegen") {
    id="";
  }
  
  if ((string)name == "noisegengauss") {
    id="";
  }
  
  if ((string)name == "noisegen00F") {
    id="";
  }
  
  if ((string)name == "meanvarestimator") {
    id="";
  }
  
  if ((string)name == "demopipe") {
    id="";
  }
  

  // execution du pipeline
  if ((string)name == "toipipe") { 
    cout << "***** Starting execution *****" << endl;
    mgr->startAll();
    // Gestion de la re-connection des threads
    cout<<"***** Joining threads *****"<<endl;
    mgr->joinAll();
    cout<<"***** End threads *****"<<endl; 
  }
}


int main(int argc, char *argv[])
{
  char buf[BUFSIZ];
  XML_Parser parser = XML_ParserCreate(NULL);
  int done;
  FILE* fich=fopen(argv[1],"r");

  ToiPipe* toiPipe = new ToiPipe();
  
  // Initialisation de Sophya
  SophyaInit();
  cout << "-- Application start --" << endl;
  XML_SetUserData(parser, toiPipe);
  XML_SetElementHandler(parser, ToiPipe::startElement, ToiPipe::endElement);
  if (fich != NULL) {
    cout << "-- Reading file --" << endl;
    // traitement des balises
    do {
      try {
	size_t len = fread(buf, 1, sizeof(buf), fich);
	done = len < sizeof(buf);
	if (!XML_Parse(parser, buf, len, done)) {
	  fprintf(stderr,
	      "%s at line %d\n",
              XML_ErrorString(XML_GetErrorCode(parser)),
              XML_GetCurrentLineNumber(parser));
	  return 1;
	}
      } catch (PThrowable & exc) {    // Sophya exceptions
	cout << "\ntstdemopipe: Catched Exception \n" << (string)typeid(exc).name() 
	<< " - Msg= " << exc.Msg() << endl;
      } catch (const std::exception & sex) {    // Standard exceptions
	cout << "\ntstdemopipe: Catched std::exception \n" 
      << (string)typeid(sex).name() << endl; 
      } catch (...) {    // Other exceptions
	cout << "\ntstdemopipe: some other exception was caught ! " << endl;
      }
    } while (!done);
    XML_ParserFree(parser);
    fclose(fich);
  } else {
     fprintf(stderr,"file not found");
     return 1;
  }
  return(0);
}

