// This may look like C code, but it is really -*- C++ -*-
// PIElDrawer - 
//                             R. Ansari  97-02
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA
#ifndef PIELDRW_H
#define PIELDRW_H

#include "pidrawer.h"

//  Classe avec gestion d une liste d elements a tracer 

class PIElDrwMgr
{
public:
  enum { PIDEL_Line = 1, PIDEL_Text = 2,
         PIDEL_Rect = 3, PIDEL_FRect = 4, 
         PIDEL_Circ = 5, PIDEL_FCirc = 6,
         PIDEL_Arc = 7,  PIDEL_FArc = 8,
         PIDEL_Poly = 9, PIDEL_FPoly = 10,
	 PIDEL_Mark = 11, PIDEL_Arrow = 12,
         PIDEL_CText = 13  } ; 

		PIElDrwMgr();
  virtual	~PIElDrwMgr();

  virtual void  DrawElements(PIGraphicUC* g, double xmin, double ymin, double xmax, double ymax);

  // ---- Ajout de lignes
  inline int    ElAddLine(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2)
    { PIGraphicAtt gatt; return( ElAdd(PIDEL_Line, x1, y1, x2, y2, NULL, gatt) ); }  
  inline int    ElAddLine(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2, 
			  PIGraphicAtt const & gatt)
    { return( ElAdd(PIDEL_Line, x1, y1, x2, y2, NULL, gatt) ); }  

  // ---- Ajout de fleches 
  inline int    ElAddArrow(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2)
    { PIGraphicAtt gatt; return( ElAdd(PIDEL_Arrow, x1, y1, x2, y2, NULL, gatt) ); }  
  inline int    ElAddArrow(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2, 
			   PIGraphicAtt const & gatt)
    { return( ElAdd(PIDEL_Arrow, x1, y1, x2, y2, NULL, gatt) ); }  

  // ---- Ajout de marker 
  inline int    ElAddMarker(PIGrCoord x, PIGrCoord y)
    { PIGraphicAtt gatt; return( ElAdd(PIDEL_Circ, x, y, 0, 0, NULL, gatt) ); }  
  inline int    ElAddMarker(PIGrCoord x, PIGrCoord y, PIGraphicAtt const & gatt)
    { return( ElAdd(PIDEL_Mark, x, y, 0, 0, NULL, gatt) ); }  

  // ---- Ajout de texte
  inline int    ElAddText(PIGrCoord x, PIGrCoord y, const char* s)
    { PIGraphicAtt gatt; return( ElAdd(PIDEL_Text, x, y, 0, 0, s, gatt) ); }  
  inline int    ElAddText(PIGrCoord x, PIGrCoord y, const char* s, 
			  PIGraphicAtt const & gatt, unsigned long tpd)
    { return( ElAdd(PIDEL_Text, x, y, 0, 0, s, gatt, tpd) ); }  
  inline int    ElAddText(PIGrCoord x, PIGrCoord y, string const & s)
    { PIGraphicAtt gatt; return( ElAdd(PIDEL_Text, x, y, 0, 0, s.c_str(), gatt) ); }  
  inline int    ElAddText(PIGrCoord x, PIGrCoord y, string const & s, 
			  PIGraphicAtt const & gatt, unsigned long tpd)
    { return( ElAdd(PIDEL_Text, x, y, 0, 0, s.c_str(), gatt, tpd) ); }  

  // ---- Ajout de rectangles 
  inline int    ElAddRect(PIGrCoord x, PIGrCoord y, PIGrCoord dx, PIGrCoord dy)
    { PIGraphicAtt gatt; return( ElAdd(PIDEL_Rect, x, y, dx, dy, NULL, gatt) ); }  
  inline int    ElAddRect(PIGrCoord x, PIGrCoord y, PIGrCoord dx, PIGrCoord dy, 
			  PIGraphicAtt const & gatt)
    { return( ElAdd(PIDEL_Rect, x, y, dx, dy, NULL, gatt) ); }  

  inline int    ElAddFRect(PIGrCoord x, PIGrCoord y, PIGrCoord dx, PIGrCoord dy)
    { PIGraphicAtt gatt; return( ElAdd(PIDEL_FRect, x, y, dx, dy, NULL, gatt) ); }  
  inline int    ElAddFRect(PIGrCoord x, PIGrCoord y, PIGrCoord dx, PIGrCoord dy, 
			   PIGraphicAtt const & gatt)
    { return( ElAdd(PIDEL_FRect, x, y, dx, dy, NULL, gatt) ); }  

  // ---- Ajout de cercles
  inline int    ElAddCirc(PIGrCoord x, PIGrCoord y, PIGrCoord r)
    { PIGraphicAtt gatt; return( ElAdd(PIDEL_Circ, x, y, r, r, NULL, gatt) ); }  
  inline int    ElAddCirc(PIGrCoord x, PIGrCoord y, PIGrCoord r, PIGraphicAtt const & gatt)
    { return( ElAdd(PIDEL_Circ, x, y, r, r, NULL, gatt) ); }  

  inline int    ElAddFCirc(PIGrCoord x, PIGrCoord y, PIGrCoord r)
    { PIGraphicAtt gatt; return( ElAdd(PIDEL_FCirc, x, y, r, r, NULL, gatt) ); }  
  inline int    ElAddFCirc(PIGrCoord x, PIGrCoord y, PIGrCoord r, PIGraphicAtt const & gatt)
    { return( ElAdd(PIDEL_FCirc, x, y, r, r, NULL, gatt) ); }  

  // ---- Ajout d' arcs 
  inline int    ElAddArc(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2,
			 PIGrCoord x3, PIGrCoord y3)
    { PIGraphicAtt gatt; PIGrCoord x[3], y[3]; 
      x[0] = x1; x[1] = x2; x[2] = x3; 
      y[0] = y1; y[1] = y2; y[2] = y3; 
      return( ElAdd(PIDEL_Arc, x, y, 3, gatt) ); }  

  inline int    ElAddArc(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2,
			 PIGrCoord x3, PIGrCoord y3, PIGraphicAtt const & gatt)
    { PIGrCoord x[3], y[3]; 
      x[0] = x1; x[1] = x2; x[2] = x3; 
      y[0] = y1; y[1] = y2; y[2] = y3; 
      return( ElAdd(PIDEL_Arc, x, y, 3, gatt) ); }  

  inline int    ElAddFArc(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2,
			  PIGrCoord x3, PIGrCoord y3)
    { PIGraphicAtt gatt; PIGrCoord x[3], y[3]; 
      x[0] = x1; x[1] = x2; x[2] = x3; 
      y[0] = y1; y[1] = y2; y[2] = y3; 
      return( ElAdd(PIDEL_FArc, x, y, 3, gatt) ); }  

  inline int    ElAddFArc(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2,
			  PIGrCoord x3, PIGrCoord y3, PIGraphicAtt const & gatt)
    { PIGrCoord x[3], y[3]; 
      x[0] = x1; x[1] = x2; x[2] = x3; 
      y[0] = y1; y[1] = y2; y[2] = y3; 
      return( ElAdd(PIDEL_FArc, x, y, 3, gatt) ); }  

  // ---- Ajout de polygones 
  inline int    ElAddPoly(vector<PIGrCoord>& x, vector<PIGrCoord>& y)
    { PIGraphicAtt gatt; return( ElAdd(PIDEL_Poly, x, y, gatt) ); }  
  inline int    ElAddPoly(vector<PIGrCoord>& x, vector<PIGrCoord>& y, PIGraphicAtt const & gatt)
    { return( ElAdd(PIDEL_Poly, x, y, gatt) ); } 
 
  inline int    ElAddFPoly(vector<PIGrCoord>& x, vector<PIGrCoord>& y)
    { PIGraphicAtt gatt; return( ElAdd(PIDEL_FPoly, x, y, gatt) ); }  
  inline int    ElAddFPoly(vector<PIGrCoord>& x, vector<PIGrCoord>& y, PIGraphicAtt const & gatt)

    { return( ElAdd(PIDEL_FPoly, x, y, gatt) ); }  

  void               ElDel(int id);
  void               ElDelAll();

protected:
  int                ElAdd(int typ, PIGrCoord x, PIGrCoord y, PIGrCoord dx, PIGrCoord dy, 
                           const char* s, PIGraphicAtt const & att,
			   unsigned long txtposdir=0);
  int                ElAdd(int typ, vector<PIGrCoord>& x, vector<PIGrCoord>& y, 
			   PIGraphicAtt const & att);
  int                ElAdd(int typ, PIGrCoord* x, PIGrCoord* y, int n,
			   PIGraphicAtt const & att);

  struct TxtEl {
    string txt;
    unsigned long txtpd;
  };

  struct DrwEl{
    int eid, etyp;
    PIGrCoord ex,ey;
    PIGrCoord edx,edy;
    PIGraphicAtt gatt;
    TxtEl* es;
    PIGrCoord* xpol;
    PIGrCoord* ypol;
    int npol;
  };

  typedef list<DrwEl> DrwElList;
  DrwElList mElist;
  int mEn;
  
};

class PIElDrawer : public PIDrawer 
{
public:
                     PIElDrawer();
  virtual           ~PIElDrawer();

//   Methode de decodage des options
  virtual int        DecodeOptionString(vector<string> & opt, bool rmdecopt=true);

  virtual void       DrawAxes(PIGraphicUC* g); // Trace d'axes avec label axe X,Y

  virtual void       Draw(PIGraphicUC* g, double xmin, double ymin, double xmax, double ymax); 

  inline PIElDrwMgr& ElDrwMgr()    { return eltsMgr; }

  inline void        SetTitles(string tt, string tb)   { titleT = tt;  titleB = tb; }
  inline void        SetTitles(string tt, string tb, PIGraphicAtt const& att) 
                        { titleT = tt;  titleB = tb; titleAtt = att; }
  inline void        ShowTitles(bool fg=true) { showTitles = fg; }

  inline void        SetAxesLabels(string xl, string yl) { xLabel = xl;  yLabel = yl; }
  inline void        SetAxesLabels(string xl, string yl, PIGraphicAtt const& att) 
                        { xLabel = xl;  yLabel = yl; labelAtt = att; }
  inline void        ShowAxesLabels(bool fg=true) { showAxesLabels = fg; }

// -- Pour compatibilite avec l'interface precedente , Reza 08/2002 
  inline void        ElDel(int id) { eltsMgr.ElDel(id); }
  inline void        ElDelAll()    { eltsMgr.ElDelAll(); }
  
  inline int	     ElAddText(PIGrCoord x, PIGrCoord y, const char* s)
                                   { return eltsMgr.ElAddText(x, y, s); }

protected:
  PIElDrwMgr eltsMgr;
  string titleT, titleB;       // Titre Haut - Bas
  PIGraphicAtt titleAtt;       // Attributs graphiques de trace de titre
  bool showTitles;             // Affichage des titres si true
  string xLabel, yLabel;       // Label x, label y
  PIGraphicAtt labelAtt;       // Attributs graphiques de trace de label d'axes
  bool showAxesLabels;         // Affichage des labels d'axes si true

};


#endif
