// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive     PIGraphic 
// Primitives de trace graphiques    R. Ansari  97
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PIGRAPHICGEN_H_SEEN
#define PIGRAPHICGEN_H_SEEN

#include "pisysdep.h"

#include PIWDG_H
#include PICMAP_H
#include PIFONT_H

#include "picolist.h"  // enum PIColors
#include "pigrcoord.h"  // Class PIGrCoord

#include "pilineatt.h"  // Class PILineAtt


// Marker types
enum PIMarker  { PI_NotDefMarker = -1,
                 PI_DotMarker = 0, PI_PlusMarker=1, PI_CrossMarker=2,  
                 PI_CircleMarker=3, PI_FCircleMarker=4,
                 PI_BoxMarker=5, PI_FBoxMarker=6,
                 PI_TriangleMarker=7, PI_FTriangleMarker=8,
                 PI_StarMarker=9, PI_FStarMarker=10 };

// ArrowMarker types (oriented markers)
enum PIArrowMarker { PI_NotDefArrowMarker, PI_BasicArrowMarker, 
		     PI_TriangleArrowMarker, PI_FTriangleArrowMarker,
		     PI_ArrowShapedArrowMarker, PI_FArrowShapedArrowMarker };

// Flag de positionnement 
enum PIGrPosHorizontal // Flags de positionnement horizontal
// PI_HorizontalPosition regroupe l'ensemble des bits utilisables
     { PI_HorizontalLeft = 0x1, PI_HorizontalCenter = 0x2, 		 
       PI_HorizontalRight = 0x3, PI_HorizontalPosition = 0xF };

enum PIGrPosVertical  // Flags de positionnement vertical
// PI_VerticalPosition regroupe l'ensemble des bits utilisables
     { PI_VerticalBottom = 0x10, PI_VerticalBaseLine = 0x20, 
       PI_VerticalCenter = 0x30, PI_VerticalTop = 0x40, 
       PI_VerticalPosition = 0xF0 };

// Orientation de trace de chaines 
enum PIGrTextDirection  
     { PI_TextDirectionHorizontal = 0, 
       PI_TextDirectionVerticalUp = 0x100,
       PI_TextDirectionVerticalDown = 0x200,
       PI_TextDirection = 0xF00};

// Les differents modes de trace graphique disponible
enum PIGOMode { PI_GOCopy = 0, PI_GOXOR = 1, PI_GOInvert = 2 }; 



// Les differents types de classes PIGraphic
enum PIGraphicsType { PI_UnknownGraphics = 0, 
                      PI_ScrWindowGraphics = 2, PI_ScrBufferGraphics = 3, 
                      PI_PSFileGraphics = 8, 
                      PI_UCGraphics = 32, PI_3DGraphics = 36 };

// Classe generique de trace graphique de base :

class PIGraphicGen
{
public:
                     PIGraphicGen();
                     PIGraphicGen(PIWdg* wdg);
                     PIGraphicGen(PIScreenBuffer* grb);
  virtual           ~PIGraphicGen();

  virtual int        kind();

//  Espace des coordonnees
  virtual void       GetGrSpace(PIGrCoord& xmin, PIGrCoord& xmax, PIGrCoord& ymin, PIGrCoord& ymax); 

//  Trace graphiques
  virtual void       Erase(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy)     = 0;

  virtual void       DrawString(PIGrCoord x, PIGrCoord y, const char* s, unsigned long pos = 0) = 0;
  virtual void       DrawOpaqueString(PIGrCoord x, PIGrCoord y, const char* s, unsigned long pos = 0) = 0;
  virtual void       DrawCompString(PIGrCoord x, PIGrCoord y, const char* s, 
                                    const char* s_up, const char* s_dn, 
				    PIFont const & fntss, unsigned long pos = 0);
  inline  void       DrawCompString(PIGrCoord x, PIGrCoord y, const char* s, 
                                    const char* s_up, const char* s_dn, 
				    unsigned long pos = 0)
                     { DrawCompString(x, y, s, s_up, s_dn, GetFont(), pos); }

  virtual void       DrawLine(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2)  = 0;
  virtual void       DrawBox(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy)   = 0;
  virtual void       DrawFBox(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy)  = 0;
  virtual void       DrawCircle(PIGrCoord x0, PIGrCoord y0, PIGrCoord r)               = 0;
  virtual void       DrawFCircle(PIGrCoord x0, PIGrCoord y0, PIGrCoord r)              = 0;
  virtual void       DrawOval(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy)  = 0;
  virtual void       DrawFOval(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy) = 0;
  virtual void       DrawPolygon(PIGrCoord *x, PIGrCoord *y, int n, bool cinc=true)    = 0;  
  virtual void       DrawFPolygon(PIGrCoord *x, PIGrCoord *y, int n, bool cinc=true)   = 0;  
  virtual void       DrawArc(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy,
                             double degdeb, double degfin)                             = 0;
  virtual void       DrawFArc(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy, 
                              double degdeb, double degfin)                            = 0;

  virtual void       Draw3PtArc(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2,
				PIGrCoord x3, PIGrCoord y3);
  virtual void       Draw3PtFArc(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2,
				 PIGrCoord x3, PIGrCoord y3);
  static  int        ComputeArcFrom3Pt(double x1, double y1, double x2, double y2,
				       double x3, double y3, double& x0, double& y0, 
				       double& dx, double& dy, double& degdeb, double& degfin);
 

  virtual void       DrawMarker(PIGrCoord x0, PIGrCoord y0)                            = 0;
  virtual void       DrawMarkers(PIGrCoord *x, PIGrCoord *y, int n)                    = 0;
  virtual void       DrawArrowMarker(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2, 
				     bool fgline=true);

  virtual void       DrawPixmap(PIGrCoord x, PIGrCoord y, unsigned char *pix, 
                                int sx, int sy, PIColorMap* cmap)              = 0;

// Modifications attributs graphiques
  virtual void       SelForeground(PIColors col=PI_Black)                      = 0;
  virtual void       SelBackground(PIColors col=PI_White)                      = 0;
  virtual void       SelForeground(PIColorMap& cmap, int cid)                  = 0;
  virtual void       SelBackground(PIColorMap& cmap, int cid)                  = 0;
  virtual void       SelGOMode(PIGOMode mod=PI_GOCopy)                         = 0;
  virtual void       SelLine(PILineAtt const& att)                             = 0;
  inline  void       SelLine(PILineTypes lt=PI_NormalLine) 
                             { SelLine(PILineAtt(lt)); }
  virtual void       SelMarker(int msz=3, PIMarker mrk=PI_DotMarker)           = 0;
  virtual void       SelArrowMarker(int arrsz=5, 
                                    PIArrowMarker arrmrk=PI_BasicArrowMarker);

  inline  void       LockForegroundColor() { myLockFCol = true; }
  inline  void       UnLockForegroundColor() { myLockFCol = false; }

// Modifications de fonte
  virtual void	     SelFont(PIFont & fnt)				       = 0; 
  virtual void       SelFont(PIFontSize sz=PI_NormalSizeFont, 
                             PIFontAtt att=PI_RomanFont)		       = 0;
  virtual void       SelFontSzPt(int npt=12, PIFontAtt att=PI_RomanFont)       = 0; 

// Selection de zone de trace (clip)
  virtual void       SetClipRectangle(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy)  = 0;
  virtual void       ClearClipRectangle()                                      = 0;

// Acces aux attributs graphiques 
  virtual PIColors   GetForeground()    = 0;
  virtual PIColors   GetBackground()    = 0;
  virtual PIGOMode   GetGOMode()        = 0;
  virtual PILineAtt  GetLineAtt()       = 0;
  virtual PIMarker   GetMarker()        = 0;
  virtual int        GetMarkerSize()    = 0;
  virtual PIArrowMarker    GetArrowMarker();
  virtual int        GetArrowMarkerSize();

// Acces a la fonte et ses attributs
  inline  PIFont     GetFont() { return (myFont) ; }
  virtual PIGrCoord  GetFontHeight(PIGrCoord& asc, PIGrCoord& desc);
  virtual PIGrCoord  CalcStringWidth(char const* s);
  virtual bool       CalcStringPositionShift(char const* s, unsigned long pos,  
					     int& dx, int& dy);

// Sauvegarde des attributs graphiques 
  virtual void       SaveGraphicAtt();
  virtual void       RestoreGraphicAtt();

protected:
// Pour Save/Restore des attributs graphiques 
  PIWdg* myWdg;
  PIScreenBuffer* myGrb;

  PIFont myFont;
  PIArrowMarker myArrowMrk;
  int myArrowMrkSz;
  PIColors  sFCol, sBCol;
  PIGOMode sGOm;
  PIFont sFont;
  PILineAtt sLAtt;
  int sFSize;
  PIMarker sMrk;
  int sMrkSz;
  PIArrowMarker sArrowMrk;
  int sArrowMrkSz;
  bool myLockFCol;
};

typedef PIGraphicGen PIGraphic;

// hierarchie apparente
//   PIGraphic               ( == Gen, mais pas visible de l'utilisateur).
//     PIGraphicWin   ( == X ou Mac)
//     PIGraphicPS
//     PIGraphicUC

#endif      // PIGRAPHGEN_H_SEEN
