//--------------------------------------------------------------------------
//
// Description:
// 	class ProxTuple :
//
// un proxy pour ntuple sophya pour une interface + user friendly
// example d'utilisation:
/*

  ProxTuple tupleCl;
  for (i=0;i<N;i++){
    tupleCl.fill(cl.l(i),"l");
    tupleCl.fill(i,"i");
    // etc...
    
    tupleCl.dump();
  }
   POutPersist pos(string("ct.ppf"));
  pos.PutObject(tupleCl.tuple(),"tupleCl");
*/
//
// Author List:
//	S.Plaszczynski 
//
// History (add to end):
//	S.Plaszczynski  sam oct 26 16:22:27 CEST 2002 (creation)
//
// Contact: 
//	plaszczy@lal.in2p3.fr
//------------------------------------------------------------------------
#ifndef ProxTuple_hh
#define ProxTuple_hh

//forward declarations

#include "ntuple.h"
#include <string>

class ProxTuple
{

public:

  //constructors
  ProxTuple():_tuple(0){};

  // destructor
  ~ProxTuple() {delete _tuple;};

  //member functions
  void fill(float v,const char*);
  inline void fill(double v,const char* c) {return fill((float)v,c);}
  inline void fill(int v,const char* c){return fill((float)v,c);}
  void dump();
  
  //acces au ntuple
  inline NTuple& tuple(){return *_tuple;}
  

private:
  NTuple* _tuple;
  vector<string> _name;
  vector<float> _val;
  
};

#endif

