// This may look like C code, but it is really -*- C++ -*-
// Outils de manipulation des Contours  O. Perdereau 11/2001
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

// #include <stdlib.h>

#include "machdefs.h"
#include <string>
#include <iostream.h>

#include "picntools.h"
#include "pigncont.h"

//++
// Class	PICnTools
// Lib		PIGcont
// include	pidcntools.h
//
//	Classe de fentre de dialogue permettant de modifier interactivement
//	les attributs graphique des "PIContourDrawer" ainsi que 
//	les parametres de calcul des contours. 
//--
// Links	Parents
// PIWindow
//--
//++
// Links	Voir aussi
// PIDrawer
// PIBaseWdg
// PIContourDrawer
//--
//++
// Links	Ainsi que
// PIScDrawWdg
// PIImage
// PIDraw3DWdg
//--

//++
// Titre	Mthodes statiques
//--
//++
// void  ShowPICnTools() 	
//	Mthode statique permettant l'affichage de la fentre de contrle des
//	attributs graphiques des "PIContourDrawer". L'instance de la classe
//	"PICnTools" est cre si ncessaire. Un seul "PIContourDrawer" est gere.      
// void  HidePICnTools() 
//	Dsactive (cache) la fentre "PICnTools" (mthode statique).
// void  SetCurrentBaseWdg(PIBaseWdgGen* cbw)
//	Mthode statique permettant de s'attacher au "PIBaseWdg" courant.
// PIBaseWdgGen*  GetCurrentBaseWdg()
//	Retourne le "PIBaseWdg" courant (mthode statique).
// void  SetCurrentCnDrw( PIContourDrawer* pcd) 
//	Mthode statique permettant de s'attacher au "PIContourDrawer".
// PIBaseWdgGen*  :GetCurrentCnDrw()
//	Retourne le "PIContourDrawer" (mthode statique).
//--


PICnTools* PICnTools::cwdrwt = NULL;
PIBaseWdgGen* PICnTools::mCurBW = NULL;
PIContourDrawer* PICnTools::mCurCDrw = NULL;

/* --Methode-- */
void PICnTools::ShowPICnTools() 
{
if (cwdrwt == NULL)  cwdrwt = new PICnTools(PIApplicationGetApp());
// cout << " from PICnTools::ShowPICnTools() - hello "<<endl;
cwdrwt->Show();
}


/* --Methode-- */
void PICnTools::HidePICnTools() 
{
if (cwdrwt == NULL)  return; 
cwdrwt->Hide();
}

void PICnTools::SetCurrentBaseWdg(PIBaseWdgGen* cbw)
{
if (mCurBW == cbw) return;
mCurBW = cbw;
}

/* --Methode-- */
PIBaseWdgGen* PICnTools::GetCurrentBaseWdg()
{
return(mCurBW);
}
/* --Methode-- */
void PICnTools::SetCurrentCnDrw( PIContourDrawer* pcd) 
{ 
 
    mCurCDrw = pcd ; 
}

/* --Methode-- */
PIContourDrawer*  PICnTools::GetCurrentCnDrw()
{
return(mCurCDrw);
}

/* --Methode-- */
PICnTools::PICnTools(PIApplication* par)
: PIWindow((PIMsgHandler*)par, "PIContourTools", PIWK_normal, 240, 240, 150, 150)
{
int bsx, bsy, spx, spy;

// On definit la taille a partir de la taille par defaut des composantes 
// PIApplicationPrefCompSize(bsx, bsy);
par->PrefCompSize(bsx, bsy);

// Espacements entre elts 
spx = bsx/10;
spy = bsy/4;

int wszx = 5*spx+5.5*bsx; 
int wszy = (1+8*0.85)*bsy+12*(1.85)*spy+15;
SetSize(wszx, wszy);

//int cpx = spx*2;
//int offy = cpy+bsy+spy*2;

//  Option-Menu  Marker, Line, couleur, etc...
int cpx = 2*spx; // current position 
int cpy = 2*spy;

int bsyo = bsy;  
int spyo = spy; 
bsy = 0.85*bsy;   spy = 0.85*spy;

mLab[0] = new PILabel(this, " Couleurs ", 2*bsx, 1.25*bsy, cpx, cpy);
mLab[0]->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);


cpx += spx+2*bsx; 
mOpt[1] = new PIOptMenu(this, "cwt-opt-1", bsx*1.75, bsy, cpx, cpy);
mOpt[1]->AppendItem("No.CMap", 200);
int kcc;
//  Groupement des tables de couleurs
mCasc[0] = new PIMenu(mOpt[1]->Menu(), "PIStd-128Col");
mCasc[1] = new PIMenu(mOpt[1]->Menu(), "MIDAS-CMap");

int nsct1,nsct2,nsct3;
//  D'abord les tables standard de PI  32 couleurs
nsct1 = 5;   // Les 5 premieres tables
for(kcc=0; kcc<nsct1; kcc++) 
  mOpt[1]->AppendItem(PIColorMap::GetStandardColorMapName(kcc).c_str(), 201+kcc);
//  Ensuite les tables standard de PI  128 couleurs
nsct2 = 9;   // Les 4 tables suivantes
for(kcc=nsct1; kcc<nsct2; kcc++) 
  mCasc[0]->AppendItem(PIColorMap::GetStandardColorMapName(kcc).c_str(), 201+kcc);
mOpt[1]->AppendPDMenu(mCasc[0]);
//  Apres les tables importees de MIDAS
nsct3 = PIColorMap::NumberStandardColorMaps()-1; // Les reste jusqu'a l'avant derniere
for(kcc=nsct2; kcc<nsct3; kcc++) 
  mCasc[1]->AppendItem(PIColorMap::GetStandardColorMapName(kcc).c_str(), 201+kcc);

mOpt[1]->AppendPDMenu(mCasc[1]);
// Les tables qui restent ( Col16 , ... )
for(kcc=nsct3; kcc<PIColorMap::NumberStandardColorMaps(); kcc++) 
mOpt[1]->AppendItem(PIColorMap::GetStandardColorMapName(kcc).c_str(), 201+kcc);

mOpt[1]->SetValue(200);
mOpt[1]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);
cpx += spx+1.75*bsx;

mOpt[0] = new PIOptMenu(this, "cwt-opt-0", bsx*1.75, bsy, cpx, cpy);
mOpt[0]->AppendItem("Def.Col", 100);
mOpt[0]->AppendItem("Black", 101);
mOpt[0]->AppendItem("White", 102);
mOpt[0]->AppendItem("Grey", 103);
mOpt[0]->AppendItem("Red", 104);
mOpt[0]->AppendItem("Blue", 105);
mOpt[0]->AppendItem("Green", 106);
mOpt[0]->AppendItem("Yellow", 107);
mOpt[0]->AppendItem("Magenta", 108);
mOpt[0]->AppendItem("Cyan", 109);
mOpt[0]->AppendItem("Turquoise", 110);
mOpt[0]->AppendItem("NavyBlue", 111);
mOpt[0]->AppendItem("Orange", 112);
mOpt[0]->AppendItem("SiennaRed", 113);
mOpt[0]->AppendItem("Purple", 114);
mOpt[0]->AppendItem("LimeGreen", 115);
mOpt[0]->AppendItem("Gold", 116);
mOpt[0]->AppendItem("Violet", 117);
mOpt[0]->AppendItem("VioletRed", 118);
mOpt[0]->AppendItem("BlueViolet", 119);
mOpt[0]->AppendItem("DarkViolet", 120);
mOpt[0]->SetValue(100);
mOpt[0]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);


cpx = 2*spx;
cpy += spy+bsyo;

cmapv = new PICMapView(this, "CMapView",wszx-4*spx,20 ,cpx,cpy); 
cmapv->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);


cpx = 2*spx; // current position 
cpy += spy+bsy;

// check boxes : lines on/off ; marker on/off 
mCkb[0] = new PICheckBox(this,"LineON", 2001, bsx, bsy, cpx, cpy);
mCkb[0]->SetState(false); 
mCkb[0]->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);

// type de ligne pour les niveaux
cpx += spx+1.75*bsx; 
mOpt[5] = new PIOptMenu(this, "bwt-opt-5", bsx*1.75, bsy, cpx, cpy);
mOpt[5]->AppendItem("Def.Line", 600);
mOpt[5]->AppendItem("Thin-Line", 601);
mOpt[5]->AppendItem("Normal-Line", 602);
mOpt[5]->AppendItem("Thick-Line", 603);
mOpt[5]->AppendItem("ThinDashed", 604);
mOpt[5]->AppendItem("Dashed-Line", 605);
mOpt[5]->AppendItem("ThickDashed", 606);
mOpt[5]->AppendItem("ThinDotted", 607);
mOpt[5]->AppendItem("Dotted-Line", 608);
mOpt[5]->AppendItem("ThickDotted", 609);
mOpt[5]->SetValue(600);
mOpt[5]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);

if(mCkb[0]->GetState()==false) 
  mOpt[5]->SetUnSensitive();


cpx = 2*spx;
cpy += spy+bsy;
//cpx += spx+bsx; 

mCkb[1] = new PICheckBox(this,"MarkerON", 2002, bsx, bsy, cpx, cpy);
mCkb[1]->SetState(true); 
mCkb[1]->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);
cpx += spx+1.75*bsx; 

mOpt[2] = new PIOptMenu(this, "bwt-opt-2", bsx*1.75, bsy, cpx, cpy);
mOpt[2]->AppendItem("Def.Mrk", 300);
mOpt[2]->AppendItem("Mrk Dot(.)", 301);
mOpt[2]->AppendItem("Mrk Plus(+)", 302);
mOpt[2]->AppendItem("Mrk Cross(x)", 303);
mOpt[2]->AppendItem("Mrk Circle", 304);
mOpt[2]->AppendItem("Mrk FCircle", 305);
mOpt[2]->AppendItem("Mrk Box", 306);
mOpt[2]->AppendItem("Mrk FBox", 307);
mOpt[2]->AppendItem("Mrk Triangle", 308);
mOpt[2]->AppendItem("Mrk FTriangle", 309);
mOpt[2]->AppendItem("Mrk Star", 310);
mOpt[2]->AppendItem("Mrk FStar", 311);
mOpt[2]->SetValue(300);
mOpt[2]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);
if(mCkb[1]->GetState()==false) 
  mOpt[2]->SetUnSensitive();

cpx += spx+1.75*bsx; 
mOpt[3] = new PIOptMenu(this, "bwt-opt-3", bsx*1.75, bsy, cpx, cpy);
mOpt[3]->AppendItem("Mrk 1 pt", 401);
mOpt[3]->AppendItem("Mrk 3 pt", 403);
mOpt[3]->AppendItem("Mrk 5 pt", 405);
mOpt[3]->AppendItem("Mrk 7 pt", 407);
mOpt[3]->AppendItem("Mrk 9 pt", 409);
mOpt[3]->AppendItem("Mrk 11 pt", 411);
mOpt[3]->AppendItem("Mrk 13 pt", 413);
mOpt[3]->AppendItem("Mrk 15 pt", 415);
mOpt[3]->SetValue(405);
mOpt[3]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);
if(mCkb[1]->GetState()==false) 
  mOpt[3]->SetUnSensitive();



cpx = 2*spx;
cpy += spy+bsy;
mLab[1] = new PILabel(this, " Labels ", 2*bsx, 1.25*bsy, cpx, cpy);
mLab[1]->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);
cpx += spx+2*bsx; 
//  check boxes : label on/off 
mCkb[2] = new PICheckBox(this,"LabelON", 2003, bsx, bsy, cpx, cpy);
mCkb[2]->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);
mCkb[2]->SetState(false);

// fonte pour les niveaux 
cpx = 2*spx;
cpy += spy+bsy;
mOpt[4] = new PIOptMenu(this, "bwt-opt-4", bsx*1.75, bsy, cpx, cpy);
mOpt[4]->AppendItem("Def.Font", 500);
mOpt[4]->AppendItem("Courier", 501);
mOpt[4]->AppendItem("Helvetica", 502);
mOpt[4]->AppendItem("Times", 503);
mOpt[4]->AppendItem("Symbol-Font", 504);
mOpt[4]->SetValue(500);
mOpt[4]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);
if(mCkb[2]->GetState()==false) mOpt[4]->SetUnSensitive();


cpx += spx+1.75*bsx;
mOpt[6] = new PIOptMenu(this, "bwt-opt-6", bsx*1.75, bsy, cpx, cpy);
mOpt[6]->AppendItem("Def.FontAtt", 700);
mOpt[6]->AppendItem("Roman-Font", 701);
mOpt[6]->AppendItem("Bold-Font", 702);
mOpt[6]->AppendItem("Italic-Font", 703);
mOpt[6]->AppendItem("BoldItalic", 704);
mOpt[6]->SetValue(700);
mOpt[6]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);
if(mCkb[2]->GetState()==false) mOpt[6]->SetUnSensitive();

cpx += spx+1.75*bsx; 
mOpt[7] = new PIOptMenu(this, "bwt-opt-7", bsx*1.75, bsy, cpx, cpy);
mOpt[7]->AppendItem("Def.FontSz", 800);
mOpt[7]->AppendItem("Tiny FontSz", 801);
mOpt[7]->AppendItem("Small FontSz", 802);
mOpt[7]->AppendItem("Normal FontSz", 803);
mOpt[7]->AppendItem("Large FontSz", 804);
mOpt[7]->AppendItem("Huge FontSz", 805);
mOpt[7]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);
if(mCkb[2]->GetState()==false) mOpt[7]->SetUnSensitive();

cpy += spyo+bsyo;
cpx = 2*spx;
mButcf[0] = new PIButton(this, "GetAtt", 2800, bsx, bsy, cpx, cpy);
mButcf[0]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);

cpx += bsx+spx;
mButcf[1] = new PIButton(this, "SetAtt", 2900, bsx, bsy, cpx, cpy);
mButcf[1]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);

cpx += bsx+spx;
mButcf[4] = new PIButton(this, "Refresh", 2950, bsx, bsy, cpx, cpy);
mButcf[4]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);


cpx = 2*spx;
cpy += spy+bsyo;
mLab[2] = new PILabel(this, " params du calcul ", 3*bsx, bsy, cpx, cpy);
mLab[2]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);

cpy += spy+bsyo;

mOpt[8] = new PIOptMenu(this, "bwt-opt-8", bsx*1.75, bsy, cpx, cpy);
mOpt[8]->AppendItem("Int. Lin.", 900);
mOpt[8]->AppendItem("CubicCpl", 901);
mOpt[8]->AppendItem("B-Spline", 902);
mOpt[8]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);


cpx += spx+1.75*bsx;
mOpt[9] = new PIOptMenu(this, "bwt-opt-9", bsx*1.75, bsy, cpx, cpy);
mOpt[9]->AppendItem("LevelAuto", 910);
mOpt[9]->AppendItem("LevelNum ", 911);
mOpt[9]->AppendItem("LevelInc ", 912);
mOpt[9]->AppendItem("LevelDisc", 913);
mOpt[9]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);

cpy += spy+bsyo;
cpx = 2*spx;

mLab[3] = new PILabel(this, "Nombre", bsx, bsy, cpx, cpy);
mLab[3]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);
cpx += spx+bsx;

mTxt[0] = new PIText(this, "Nlev",bsx, (int)(bsy*1.3), cpx, cpy);
mTxt[0]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);
mTxt[0]->SetText("5");
cpx += spx+bsx;
mLab[4] = new PILabel(this, "Niveaux", bsx, bsy, cpx, cpy);
mLab[4]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);
cpx += spx+bsx;
mTxt[1] = new PIText(this, "levels",(int)(bsx*2), (int)(bsy*1.3), cpx, cpy);
mTxt[1]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);


bsy = bsyo; spy = spyo;


cpx = (wszx-3.2*bsx-2*spx)/2;
cpy += 2*spy+bsy;
mButcf[2] = new PIButton(this, "SetPArm", 3100, bsx*1.2, bsyo, cpx, cpy);
mButcf[2]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);
cpx += bsx*1.2+spx;

cpx += bsx*0.8+spx; 


mButcf[3] = new PIButton(this, "Dismiss", 3777, bsx*1.2, bsyo, cpx, cpy);
mButcf[3]->SetBinding(PIBK_elastic, PIBK_elastic, PIBK_elastic, PIBK_elastic);

cwdrwt = this;

}

/* --Methode-- */
PICnTools::~PICnTools()
{

if (cwdrwt == this)  cwdrwt = NULL; 

mCurCDrw = NULL;
int i;
for(i=0; i<5; i++)  
  delete mLab[i];
for(i=0; i<2; i++)  
  delete mCkb[i];

for(i=0; i<5; i++) delete mButcf[i]; 
for(i=0; i<2; i++) delete mButdr[i]; 
for(i=0; i<10; i++)  delete mOpt[i];
for(i=0; i<2; i++)  delete mCasc[i];
for(i=0; i<2; i++)  delete mTxt[i];

delete mNlb;

delete cmapv;
}

//  Declaration des differents attributs graphiques 
#define MYNMXCOLORS 21
static PIColors cols[MYNMXCOLORS] = { PI_NotDefColor, 
                     PI_Black, PI_White, PI_Grey, 
                     PI_Red, PI_Blue, PI_Green, 
                     PI_Yellow, PI_Magenta, 
                     PI_Cyan , PI_Turquoise, PI_NavyBlue, 
                     PI_Orange, PI_SiennaRed, PI_Purple, 
                     PI_LimeGreen, PI_Gold, PI_Violet, PI_VioletRed,
                     PI_BlueViolet, PI_DarkViolet };

static PIMarker mrk[12] = { PI_NotDefMarker, PI_DotMarker, 
                            PI_PlusMarker, PI_CrossMarker,
                            PI_CircleMarker, PI_FCircleMarker,
                            PI_BoxMarker, PI_FBoxMarker,
                            PI_TriangleMarker, PI_FTriangleMarker,
                            PI_StarMarker, PI_FStarMarker };
static PILineAtt line[10] = { PI_NotDefLineAtt, PI_ThinLine, PI_NormalLine, PI_ThickLine, 
                              PI_ThinDashedLine, PI_DashedLine, PI_ThickDashedLine, 
                              PI_ThinDottedLine, PI_DottedLine, PI_ThickDottedLine };

static PIFontName fntname[5] = { PI_DefaultFont, PI_CourierFont, PI_HelveticaFont, 
				 PI_TimesFont, PI_SymbolFont};
static PIFontAtt fntatt[5] = { PI_NotDefFontAtt, PI_RomanFont, PI_BoldFont, 
			       PI_ItalicFont, PI_BoldItalicFont };
static PIFontSize fntsz[6] = { PI_NotDefFontSize, PI_TinySizeFont, PI_SmallSizeFont, 
			       PI_NormalSizeFont, PI_LargeSizeFont, PI_HugeSizeFont };

/* --Methode-- */
void PICnTools::Show()
{
PIWindow::Show();

mNDr = 0;


UpdateAttFromDrawer();
return;
}
// Liste des differentes options de calcul 
static t_contour_kind crbe_algo[3]={CONTOUR_KIND_LINEAR,CONTOUR_KIND_CUBIC_SPL,CONTOUR_KIND_BSPLINE};
static t_contour_levels_kind lev_kind[4]={LEVELS_AUTO,LEVELS_NUM,LEVELS_INCREMENTAL,LEVELS_DISCRETE};

/* --Methode-- */
void PICnTools::UpdateAttFromDrawer()
{

PIContourDrawer* dr = mCurCDrw;

mOpt[0]->SetValue(100);
mOpt[1]->SetValue(200);
mOpt[2]->SetValue(300);
mOpt[3]->SetValue(405);
mOpt[4]->SetValue(500);
mOpt[5]->SetValue(600);
mOpt[6]->SetValue(700);
mOpt[7]->SetValue(800);
mOpt[8]->SetValue(800);
mOpt[9]->SetValue(800);

// etats des check



if (!dr)  return;

mCkb[0]->SetState(mCurCDrw->IsLineOn());
mCkb[1]->SetState(mCurCDrw->IsMarkOn());
mCkb[2]->SetState(mCurCDrw->IsLabelOn());
if(mCkb[2]->GetState()==false){ 
  mOpt[4]->SetUnSensitive();
  mOpt[6]->SetUnSensitive();
  mOpt[7]->SetUnSensitive();
}else {
  mOpt[4]->SetSensitive();
  mOpt[6]->SetSensitive();
  mOpt[7]->SetSensitive();
}


if(mCkb[1]->GetState()==false) {
  mOpt[3]->SetUnSensitive();
  mOpt[2]->SetUnSensitive();
}else{
  mOpt[3]->SetSensitive();
  mOpt[2]->SetSensitive();
}


if(mCkb[0]->GetState()==false) 
  mOpt[5]->SetUnSensitive();
else
  mOpt[5]->SetSensitive();

int ii,jj,kk;
PIColors fc = dr->GetGraphicAtt().GetFgColor();
for(kk=0; kk<MYNMXCOLORS; kk++) 
  if (fc == cols[kk])  
    { mOpt[0]->SetValue(100+kk);  break; }    


CMapId cmi = dr->GetGraphicAtt().GetColMapId();
double zmin=0;
double zmax=1.;
if(mCurCDrw!=NULL){
   zmin = mCurCDrw->Zmin();
    zmax = mCurCDrw->Zmax();
}

if (cmi == CMAP_OTHER)  {
  mOpt[1]->SetValue(200);
  mCurCDrw->GetGraphicAtt().SetColMapId(CMAP_OTHER);
  cmapv->SetColMapId(CMAP_OTHER,false, zmin , zmax,true);
}else for(kk=0; kk<PIColorMap::NumberStandardColorMaps(); kk++)
  if (cmi == PIColorMap::GetStandardColorMapId(kk)) { 
    mOpt[1]->SetValue(201+kk);
    cmapv->SetColMapId(PIColorMap::GetStandardColorMapId(kk),false, zmin , zmax,true);
    break; 
  }
  
PIMarker mk = dr->GetGraphicAtt().GetMarker();   
for(kk=0; kk<12; kk++) 
  if (mk == mrk[kk])   { mOpt[2]->SetValue(300+kk);  break; }
kk = dr->GetGraphicAtt().GetMarkerSz();
if (kk < 1)  kk = 1;
if (kk > 15) kk = 15;
if (kk%2 == 0) kk++;
mOpt[3]->SetValue(400+kk);
PIFontName fnm = dr->GetGraphicAtt().GetFontName();
PIFontAtt fat = dr->GetGraphicAtt().GetFontAtt();
PIFontSize fsz = dr->GetGraphicAtt().GetFontSz();
for(ii=0; ii<5; ii++)
  if (fnm ==  fntname[ii]) break;
for(kk=0; kk<5; kk++)
  if (fat ==  fntatt[kk]) break;
for(jj=0; jj<5; jj++) 
  if (fsz == fntsz[jj])  break;

if (ii >= 5) ii = 1;
if (kk >= 5) kk = 1;
if (jj >= 6) jj = 3;
mOpt[4]->SetValue(500+ii);
mOpt[6]->SetValue(700+kk);
mOpt[7]->SetValue(800+jj);

PILineAtt lat = dr->GetGraphicAtt().GetLineAtt();
for(kk=0; kk<10; kk++)
  if (lat == line[kk])   { mOpt[5]->SetValue(600+kk);  break; }

// parametres pour calcul des niveaux 
t_contour_kind kind = dr->GetCntKind()  ;
for (ii=0 ; ii<3 ; ii++)
  if(crbe_algo[ii]==kind)
    {mOpt[8]->SetValue(900+ii); break;}

t_contour_levels_kind lvkind = dr->GetCntLevelKind()  ;
for (ii=0 ; ii<4 ; ii++)
  if(lev_kind[ii]==lvkind)
    {mOpt[9]->SetValue(910+ii); break;}

int nlv =  dr->NLevels();
char txt[24];
sprintf(txt,"%d",nlv);
mTxt[0]->SetText(txt);  

if(dr->Levels()!=NULL){
  string strg=" ";
  for(int kk=0 ; kk<nlv ; kk++) {
    //cout << " dr->Level("<<kk<<") "<<endl;
    cout <<dr->Level(kk)<<endl;
    if (kk!=nlv-1)
       sprintf(txt,"%g ,",dr->Level(kk)); 
    else
      sprintf(txt,"%g",dr->Level(kk)); 

    strg += txt;
  }
  mTxt[1]->SetText(strg);  
  
}


return;
}







/* --Methode-- */
//setting des parms du calcul des crbes de niveau
void PICnTools::SetCalcParm(){

PIContourDrawer* dr = mCurCDrw;
if(dr==NULL)return;
int k,ii,jj,kk;

k = mOpt[8]->GetValue()-900; // type de contour 
dr->SetCntKind(crbe_algo[k]);

k = mOpt[9]->GetValue()-910; // choix des niveaux des courbes 
dr->SetCntLevelKind(lev_kind[k]);

string str=mTxt[0]->GetText();

ii=atoi(str.c_str());
if(ii>0) 
  dr->SetNLevel(ii);
else 
  cerr<< " PICnTools::SetCalcParm ERREUR noombre de contours <=0 "<<ii<<endl;
char *buff;
char *tmp;
str=mTxt[1]->GetText();

buff=strdup(str.c_str());
double * zlev=NULL;
//out << " k= "<<k<<endl;
if(k==2) {
  zlev = new double[2];
  tmp = strtok(buff,",");
  if(tmp ==NULL) {
    cerr<< " PICnTools::SetCalcParm ERREUR decodage des niveaux impossible avec " << buff <<endl;
    return;
  }
  zlev[0] = atof(tmp);
  
  tmp = strtok(NULL,",");
  if(tmp ==NULL) {
    cerr<< " PICnTools::SetCalcParm ERREUR decodage des niveaux impossible avec " << buff <<endl;
    return;
  }
  zlev[1]= atof(tmp);
  dr->SetMyLevels(zlev,2);
  // cas LEVELS_INCREMENTAL
}else if (k==3){
  // cas LEVELS_DISCRETE
  zlev = new double[ii];
  tmp = strtok(buff,",");
  if(tmp ==NULL) {
    cerr<< " PICnTools::SetCalcParm ERREUR decodage des niveaux impossible dans  " << buff <<endl;
    return;
  }
  int cntr = 0;
  for(jj=0 ; jj<ii ; jj++){
      zlev[jj]= atof(tmp);
      cntr++;
      //cout << " jj "<<zlev[jj]<<endl;
      tmp = strtok(NULL,"," );
      if(tmp == NULL) {
	
	break;
      }
      cout << " tmp = <"<<tmp<<"<"<<endl;

  }
  if(cntr<ii) {
    cerr<< " PICnTools::SetCalcParm ERREUR decodage des niveaux "<<cntr
	<<" trouves sur "<<ii<<" dans " << buff <<endl;
    return;

  }
  dr->SetMyLevels(zlev,ii);
   


}  

//
//

dr->CalcContour();
dr->Refresh();

if(zlev!=NULL) {
  delete[] zlev;
  zlev=NULL;
}

}

/* --Methode-- */
void PICnTools::SetGraphicAtt(bool refr)
{

  if ( mCurCDrw== NULL )  return;
  // etats des boutons 
  
  mCurCDrw->SetLineOn(mCkb[0]->GetState());
  mCurCDrw->SetMarkOn(mCkb[1]->GetState());
  mCurCDrw->SetLabelOn(mCkb[2]->GetState());

  
  int k,ii,jj,kk;
  k = mOpt[0]->GetValue()-100; // -> COULEUR 
  if ( (k < 0) || (k >= MYNMXCOLORS) )  k = 0;
  mCurCDrw->GetGraphicAtt().SetColAtt(cols[k]);
  double zmin=0;
  double zmax=1.;
  if(mCurCDrw!=NULL){
    zmin = mCurCDrw->Zmin();
    zmax = mCurCDrw->Zmax();
  }
  
  k = mOpt[1]->GetValue()-200; // --> COLOR MAP 
  if (k == 0){
    mCurCDrw->GetGraphicAtt().SetColMapId(CMAP_OTHER);
    cmapv->SetColMapId(CMAP_OTHER,false, zmin , zmax,true);

  }else{
    mCurCDrw->GetGraphicAtt().SetColMapId(PIColorMap::GetStandardColorMapId(k-1));
    cmapv->SetColMapId(PIColorMap::GetStandardColorMapId(k-1),false, zmin , zmax,true);
  }
  k =  mOpt[2]->GetValue()-300; // Marker 
  if ( (k < 0) || (k > 11) )  k = 0;
  kk =  mOpt[3]->GetValue()-400; // marker SIZE
  if ( (kk < 1) || (kk > 27) )  kk = 1;
  mCurCDrw->GetGraphicAtt().SetMarkerAtt(kk, mrk[k]);

  ii =  (mOpt[4]->GetValue()-500);
  jj =  (mOpt[6]->GetValue()-700);
  kk =  (mOpt[7]->GetValue()-800);
  mCurCDrw->GetGraphicAtt().SetFontAtt(fntname[ii], fntsz[kk], fntatt[jj]);

  k =  mOpt[5]->GetValue()-600;
  if ( (k < 0) || (k > 9) )  k = 0;
  mCurCDrw->GetGraphicAtt().SetLineAtt(line[k]);

  if (refr)
    if (mCurBW !=NULL) 
      mCurBW->Refresh();
    else  
      mCurCDrw->Refresh();
  else  
    mCurCDrw->Refresh();

}

/* --Methode-- */
void PICnTools::Process(PIMessage msg, PIMsgHandler* /*sender*/, void* /*data*/)
{
  char strg[64];
  PIMessage mod = ModMsg(msg);
  msg = UserMsg(msg);
  double zmin=0;
  double zmax=1.;
  if(mCurCDrw!=NULL){
    zmin = mCurCDrw->Zmin();
    zmax = mCurCDrw->Zmax();
  }
  
  if(msg>=200&&msg<300){
    int k = mOpt[1]->GetValue()-200; // _> COLOR MAP 
    if (k == 0){
      cmapv->SetColMapId(CMAP_OTHER,false, zmin , zmax,true);
      
    }else{
      
      cmapv->SetColMapId(PIColorMap::GetStandardColorMapId(k-1),false , zmin , zmax,true);
    }
    
  }
  switch (msg) {
    case 2001 :
      if(mCkb[0]->GetState()==false) 
	mOpt[5]->SetUnSensitive();
      else 
	mOpt[5]->SetSensitive();

      break;

    case 2002 :
      if(mCkb[1]->GetState()==false){ 	
	mOpt[2]->SetUnSensitive();
	mOpt[3]->SetUnSensitive();
      }else{	
	mOpt[2]->SetSensitive();
	mOpt[3]->SetSensitive();
      }

    case 2003 :
      if(mCkb[2]->GetState()==false){ 
	mOpt[4]->SetUnSensitive();
	mOpt[6]->SetUnSensitive();
	mOpt[7]->SetUnSensitive();
      }else{
	mOpt[4]->SetSensitive();
	mOpt[6]->SetSensitive();
	mOpt[7]->SetSensitive();
      }
      
      
      break;
    case 2800 :
      UpdateAttFromDrawer();
      break;

    case 2900 :
      SetGraphicAtt(false);
      break;

    case 2950 :
      SetGraphicAtt(true);
      break;

    case 3100 :
      SetCalcParm();
      break;


    case 3200 :
 
      break;

    case 3777 :
      Hide();
      break;

      /*   On ne change pas les options choisies   Reza+cmv 2/10/98  
	   mOpt[0]->SetValue(100);
	   mOpt[1]->SetValue(200);
	   mOpt[2]->SetValue(300);
	   mOpt[3]->SetValue(405);
	   mOpt[4]->SetValue(500);
	   mOpt[5]->SetValue(600);
    */
      break;

    default :
      break;
  }

return;
}



