#!/bin/csh
# - Avant toute chose, dans ce fichier:
# 1-/ Mettre le bon numero de version: set VS = "V?.?"
# 2-/ Mettre le bon TAG: set TAG = "V_???200?"
# 2-/ Mettre le bon OSCC: set OSCC = "Linux-g++"
# - Execution et creation du:
# 1-/ Se placer dans ~/Planck/DPC: cd ~/Planck/DPC/.
#     (repertoire au dessus des repertoires/modules Sophya)
# 2-/ ./tar_for_web.csh
#----------------------------------------------
set VS = "V1.4"
set TAG = "V_Nov2002"
set OSCC = "Linux-g++"
###set OSCC = "OSF1-cxx"
#----------------------------------------------
set sophyarep = ( \
    BaseTools DemoPIApp Examples FitsIOServer HiStats IFFTW \
    LinAlg Manual Mgr NTools PI PIext PIGcont \
    PMixer PrgMap PrgUtil ProgPI \
    Samba SkyMap SysTools SkyT SUtils TArray Tests \
    XAstroPack XephemAstroLib \
    modules \
    )
#----------------------------------------------

#################################################
###### Check des variables d'environnement ######
#################################################
foreach d ( $sophyarep )
  if( ! -d $d ) then
    echo repertoire `pwd`/$d inexistant
    exit -1
  endif
end
if( ! $?DPCBASEREP ) then
  echo Precisez DPCBASEREP
  exit -1
endif
if( ! -e $DPCBASEREP/Include ) then
  echo Pas de repertoire $DPCBASEREP/Include
  exit -1
endif
if( ! -e $DPCBASEREP/${OSCC} ) then
  echo Pas de repertoire $DPCBASEREP/${OSCC}
  exit -1
endif
foreach d ( Libs ShLibs Exec )
  if( ! -d $DPCBASEREP/${OSCC}/$d ) then
    echo repertoire $DPCBASEREP/${OSCC}/$d inexistant
    exit -1
  endif
end
if( ! $?EXTLIBDIR ) then
  echo Precisez EXTLIBDIR
  exit -1
endif
if( ! -e $EXTLIBDIR/Include ) then
  echo Pas de repertoire $EXTLIBDIR/Include
  exit -1
endif
if( ! -e $EXTLIBDIR/${OSCC} ) then
  echo Pas de repertoire $EXTLIBDIR/${OSCC}
  exit -1
endif
foreach d ( Libs ShLibs )
  if( ! -d $EXTLIBDIR/${OSCC}/$d ) then
    echo repertoire $EXTLIBDIR/${OSCC}/$d inexistant
    exit -1
  endif
end
set SYS = `echo $OSCC | awk -F"-" '{print $1}'`
echo "SOURCE        = " `pwd`
echo "DPCBASEREP    = " $DPCBASEREP
echo "EXTLIBDIR     = " $EXTLIBDIR
echo "Version       = " $VS
echo "Tag           = " $TAG
echo "System-compil = " $OSCC
echo "System        = " $SYS

###############################
###### Repertoire tampon ######
###############################
if( $?TMPDIR ) then
  set tmp = $TMPDIR/tar_for_web
else
  set tmp = /tmp/tar_for_web
endif
echo "tmp        = " $tmp
rm -rf $tmp
mkdir $tmp
if( $status != 0 ) then
  echo impossible de creer le repertoire temporaire $tmp
  exit -1
endif
mkdir $tmp/${VS}
mkdir $tmp/ExtLibs

############################
###### Le Code Sophya ######
############################
echo '>>>>>>>>' Code de Sophya
mkdir $tmp/${VS}/Src
cat >! $tmp/${VS}/Src/COPYRIGHT <<EOF
  ---------------------------------
      SOPHYA ::
      Version: ${VS} - ${TAG}
       Copyright (C) 1998-2002
   LAL / IN2P3-CNRS DAPNIA/SPP CEA
  ---------------------------------
EOF
foreach d ( $sophyarep )
  echo repertoire $d
  tar -chf - $d |(cd $tmp/${VS}/Src/.; tar -xf -)
  rm -rf $tmp/${VS}/Src/$d/CVS
end
pushd $tmp > /dev/null
tar -cf sophya_src.tar ${VS}/Src
rm -rf ${VS}/Src
gzip -f sophya_src.tar
popd > /dev/null

##################################################
###### Les librairies et executables Sophya ######
##################################################
echo '>>>>>>>>' Librairies et executables de Sophya
pushd $DPCBASEREP > /dev/null
tar -chf - Include |(cd $tmp/${VS}/.; tar -xf -)
popd > /dev/null
pushd $DPCBASEREP/${OSCC} > /dev/null
tar -chf - Libs   |(cd $tmp/${VS}/.; tar -xf -)
tar -chf - ShLibs |(cd $tmp/${VS}/.; tar -xf -)
tar -chf - Exec   |(cd $tmp/${VS}/.; tar -xf -)
popd > /dev/null
pushd $tmp > /dev/null
tar -cf sophya_${SYS}.tar ${VS}
rm -rf ${VS}
gzip -f sophya_${SYS}.tar
popd > /dev/null

########################################
###### Les librairies exterieures ######
########################################
echo '>>>>>>>>' Librairies exterieures de Sophya
pushd $EXTLIBDIR > /dev/null
tar -chf - Include |(cd $tmp/ExtLibs/.; tar -xf -)
popd > /dev/null
pushd $EXTLIBDIR/${OSCC} > /dev/null
tar -chf - Libs   |(cd $tmp/ExtLibs/.; tar -xf -)
tar -chf - ShLibs |(cd $tmp/ExtLibs/.; tar -xf -)
popd > /dev/null
pushd $tmp > /dev/null
tar -cf sophya_extlibs_${SYS}.tar ExtLibs
rm -rf ExtLibs
gzip -f sophya_extlibs_${SYS}.tar
popd > /dev/null

####################
###### Resume ######
####################
echo "---------------------------------------"
du -sk $tmp/sophya*.tar.gz
echo "---------------------------------------"
ls -ltr $tmp/sophya*.tar.gz
echo "---------------------------------------"

exit 0
