#ifndef LOCALMAP_SEEN
#define LOCALMAP_SEEN

#include "pixelmap.h"
#include "sphericalmap.h"

// A local map of a region of the sky, in cartesian coordinates.
// It has an origin in (theta0, phi0), mapped to pixel(x0, y0)
//   (x0, y0 might be outside of this local map)
// default value of (x0, y0) is middle of the map, center of pixel(nx/2, ny/2)
//
//    la carte est consideree comme un tableau a deux indices i et j, i etant 
//    indice de colonne et j indice de ligne. La carte est supposee resider 
//    dans un plan tangent, dont le point de tangence est repere (x0,y0) dans 
//    la carte et (theta0, phi0) sur la sphere celeste. L'extension de la 
//    carte est definie par les valeurs de deux angles couverts respectivement
//    par la totalite des pixels en x de la carte et la totalite des pixels 
//    en y. (SetSize()).
//    On considere un "plan de reference" : plan tangent a la sphere celeste 
//    aux angles theta=Pi/2 et phi=0. Dans ce plan L'origine des coordonnees 
//    est le point de tangence. L'axe Ox est la tangente parallele a 
//    l'equateur, dirige vers les phi croissants, l'axe Oy est parallele 
//    au meridien, dirige vers le pole nord.
//    De maniere interne a la classe une carte est definie dans ce plan de 
//    reference et transportee  jusqu'au point (theta0, phi0) de sorte que les //    axes restent paralleles aux meridiens et paralleles. L'utilisateur peut 
//    definir sa carte selon un repere en rotation par rapport au repere de 
//    reference (par l'angle entre le parallele et l'axe Ox souhaite -- 
//    methode SetOrigin(...))







class LocalMap : public PixelMap {
public:
   LocalMap();
   LocalMap(int_4 nx, int_4 ny);
   virtual ~LocalMap();
   // Overloading of () to access pixel number k.
inline  r_8&        operator()(int_4 k)
                          {return(PixVal(k));}
inline  r_8 const&  operator()(int_4 k) const
                          {return(PixVal(k));}
inline  r_8&        operator()(int ix, int iy)
                { return PixVal(iy*mSzX_+ix) ; };
inline  r_8 const&        operator()(int ix, int iy) const
                { return PixVal(iy*mSzX_+ix) ; };
   
// ---------- Persistence handling
   
   enum {classId = 0xF003 };
int_4               ClassId() const        { return classId; }

virtual void        WriteSelf(POutPersist&) const;
virtual void        ReadSelf(PInPersist&);

// ---------- Definition of PixelMap abstract methods

   // Number of pixels
   virtual int_4       NbPixels() const;
   
   // Value of pixel number k
   virtual r_8&        PixVal(int_4 k);
   virtual r_8 const&  PixVal(int_4 k) const;

   // Index of pixel at (theta,phi)
   virtual int_4       PixIndexSph(float theta, float phi) const;
   
   // Spherical coordinates of center of pixel number k
   virtual void        PixThetaPhi(int_4 k, float& theta, float& phi) const;
   // Pixel Solid angle  (steradians)
   virtual r_8         PixSolAngle(int_4 k) const; 

// ---------- Specific methods

   // Origin (with angle between x axis and phi axis, in degrees)
    virtual void  SetOrigin(float theta0, float phi0, float angle=0.); // x0,y0 default: middle of map
  virtual void        SetOrigin(float theta0, float phi0, int_4 x0, int_4 y0, float angle=0.);
   // Pixel size (degres) 
   virtual void        SetSize(float angleX, float angleY);

   // Projection to/from spherical map
   //virtual void        Extract(SphericalMap const& sphere);
   virtual void        Project(SphericalMap& sphere) const;
  
   // There should be a more complex algorithm somewhere to combine *several*
   // local maps to a full sphere.
   //   -> static method, or separate class

   void Pixelize(int_4,int_4); // Allocate pixel array

// ------------- mthodes internes ----------------------
          
private :

   void	     InitNul();
   void      Clear();
   void      Getij(int k, int& i, int& j) const;
   void      ReferenceToUser(float &theta, float &phi) const; 
   void      UserToReference(float &theta, float &phi) const;
   void      PixProjToAngle(float x, float y,float &theta, float &phi) const; 
   void      AngleProjToPix(float theta, float phi, float& x, float& y) const; 
// ------------- variables internes -----------------------

   int_4   mSzX_, mSzY_;
   int_4   mNPix_;
   int_4   x0_;
   int_4   y0_;
   int_4    originFlag_;
   int_4    SzFlag_;
   r_4   cos_angle_;
   r_4   sin_angle_;
   r_8     theta0_;
   r_8     phi0_;
   r_8     omeg_;
   r_8     tgAngleX_;
   r_8     tgAngleY_;
   r_8*    mPix_;
};

#endif
