#ifndef PIXELMAP_SEEN
#define PIXELMAP_SEEN

#include "ppersist.h" 
#include "dvlist.h"
#include <iostream.h>

// General map of pixels on part of sphere or whole sphere
// Class hierarchy :
//   PixelMap
//      SphericalMap
//         SphereThetaPhi
//         SphereGorski
//         SphereIco
//      LocalMap


class PixelMap : public PPersist {
public:
   PixelMap():mInfo_(NULL) {}
   virtual ~PixelMap() {}
   
   // Number of pixels
   virtual int_4       NbPixels() const=0;
   
   // Value of pixel number k
   virtual r_8&        PixVal(int_4 k)=0;
   virtual r_8 const&  PixVal(int_4 k) const=0;
   
   // Index of pixel at (theta,phi)
   virtual int_4       PixIndexSph(float theta, float phi) const=0;

   // Value of pixel number at (theta,phi)
   virtual r_8&        PixValSph(float theta, float phi)
                           {return PixVal(PixIndexSph(theta,phi));}
   virtual r_8 const&  PixValSph(float theta, float phi) const
                           {return PixVal(PixIndexSph(theta,phi));}                           
   
   // Spherical coordinates of center of pixel number k
   virtual void        PixThetaPhi(int_4 k, float& theta, float& phi) const=0;

   // Pixel  (steradians)
   virtual r_8         PixSolAngle(int_4 k) const =0; 

   // Overloading of () to access pixel number k.
   inline  r_8&        operator()(int_4 k)
                          {return(PixVal(k));}
   inline  r_8 const&  operator()(int_4 k) const
                          {return(PixVal(k));}

   // Note : no overloading of (float,float) to access pixel (theta,phi).
   // overloading of (float,float) in SphericalMap
   // overloading of (int,int)     in CartesianMap

//++
DVList&  Info()
//
//      Renvoie une rM-ifM-irence sur l'objet DVList AssociM-i
//--
{
if (mInfo_ == NULL)  mInfo_ = new DVList;
return(*mInfo_);
}

   protected :

  DVList* mInfo_;        // Infos (variables) attachees 
};

#endif
