#ifndef SPHERETHETAPHI_SEEN
#define SPHERETHETAPHI_SEEN

#include "sphericalmap.h"
#include "pdataarray.h"
#include "cvector.h"

// ***************** CLASSE SphereThetaPhi *****************************


class SphereThetaPhi : public SphericalMap {
public :


SphereThetaPhi(int_4 m, int_4 pet);
SphereThetaPhi();
SphereThetaPhi(char* flnm);
virtual ~SphereThetaPhi();

// ------------ Persistence handling

     enum {classId = 0xF001 };
int_4                  ClassId() const        { return classId; }

virtual void           WriteSelf(POutPersist&) const;
virtual void           ReadSelf(PInPersist&);

// ------------------ Definition of PixelMap abstract methods

// number of pixels
virtual  int_4           NbPixels() const;

// Value of pixel number k
virtual  r_8&       PixVal(int_4 k);
virtual  r_8 const&       PixVal(int_4 k) const;

// Index of pixel at (theta,phi)
virtual  int_4           PixIndexSph(float theta, float phi) const;

// Spherical coordinates of center of pixel number k
virtual  void          PixThetaPhi(int_4 k, float& theta, float& phi) const;

// Pixel Solid angle  (steradians)
virtual r_8         PixSolAngle(int_4 dummy) const; 
// --------------- Specific methods 


/* Valeurs de theta des paralleles et phi des meridiens limitant          */
/* le pixel d'indice k                                                   */
virtual  void          Limits(int_4 k, float& tet1, float& tet2, 
				float& phi1, float& phi2 );

/* Nombre de tranches en theta                                           */
int_4           NbThetaSlices() const;

/* Nombre de pixels en phi de la tranche d'indice kt                     */
int_4           NPhi(int_4 kt) const;

/* Renvoie dans t1,t2 les valeurs respectives de theta min et theta max  */
/* de la tranche d'indice kt                                             */
void          Theta(int_4 kt, float& t1, float& t2);

/* Renvoie dans p1,p2 les valeurs phimin et phimax du pixel d'indice jp  */
/* dans la tranche d'indice kt                                           */
void          Phi(int_4 kt, int_4 jp, float& p1, float& p2);

/* Renvoie l'indice k du pixel d'indice jp dans la tranche d'indice kt   */
int_4           Index(int_4 kt, int_4 jp) const;


/* Indice kt de la tranche et indice jp du pixel d'indice k            */
void          ThetaPhiIndex(int_4 k,int_4& kt,int_4& jp);

void Pixelize(int_4,int_4); 
void GetThetaSlice(int_4 index, r_4& theta, Vector& phi, Vector& value) const; 


private :
// ------------- mthodes internes ----------------------
          

void	      InitNul();
void          Clear();

// ------------- variables internes -----------------------
int_4 mNTheta,mNPet;
int_4 mNPix;
r_4* mTheta;
r_8  mOmeg;
int_4* mNphi;
int_4* mTNphi;
//r_8* mPix;
PDataArray<r_8>* _pixel;


};



#endif
