#ifndef SPHERICALMAP_SEEN
#define SPHERICALMAP_SEEN

// valeurs de Pi, 2*Pi, etc                                              
#include "nbmath.h"
#include <math.h>
#include "pixelmap.h"
#include "cvector.h" 
// Map of pixels on a whole sphere.
// Class hierarchy :
//   PixelMap
//      SphericalMap
//         SphereThetaPhi
//         SphereGorski
//         SphereIco
//      LocalMap

class SphericalMap : public PixelMap {

public :
SphericalMap() {};
virtual	 ~SphericalMap() {};

   // Overloading of () to access pixel number k.
   inline  r_8&        operator()(int_4 k)
                          {return(PixVal(k));}
   inline  r_8 const&  operator()(int_4 k) const
                          {return(PixVal(k));}
inline  r_8&        operator()(float theta, float phi)
                { return(PixValSph(theta, phi)) ; };
inline  r_8 const&        operator()(float theta, float phi) const
                { return(PixValSph(theta, phi)) ; };


virtual int_4 NbThetaSlices() const=0;
virtual void GetThetaSlice(int_4 index, r_4& theta, Vector& phi, Vector& value) const=0; 
};

#endif






