// This may look like C code, but it is really -*- C++ -*-

// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Cecile Renault
//                               Christophe Magneville
//                               Reza Ansari
// $Id: fitsringwtr.h,v 1.1 2002-11-28 14:41:12 aubourg Exp $

#ifndef FITSRINGWTR_H
#define FITSRINGWTR_H

#include "toi.h"
#include "toiprocessor.h"
#include "fitsio.h"

class FITSRingWriter : public TOIProcessor {
public:
  FITSRingWriter(string fn);
  ~FITSRingWriter();

  void  setNSamples(long n); // number of samples in a ring
  void  setNRings(long n);  // number of rings (-> number of HDU)
  void  setAperture(double a);
  
  void  init();
  void  run();
  
protected:
  long nSamples;
  long nRings;
  double aperture;
  string fname;
  fitsfile *fptr;
  int fstatus;
};


#endif
