// Affichage d'image            R. Ansari  05/95
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA
//                        Refonte   Reza   10/95


#include <stdlib.h>
#include <stdio.h>
#include <string>
#include <string.h>

#include "piimage.h"

#include "imageop.h"


/* --Methode-- */
PIImage::PIImage(PIContainerGen *par, char *nom,
   int sx, int sy, int px, int py) :
  PIPixmap(par, nom, sx, sy, px, py)
{

img = NULL;
aisup = false;
curshow = true;
winovis = true;     // $CHECK$ Reza A enlever si possible 17/6/96
zow = NULL; 
trtw = NULL;
trtlb = txw = NULL;
SetTextWin(NULL);
zpixm = pixm = NULL;
xszpxm = xspxm = 0;
yszpxm = yspxm = 0;
lut = NULL; 
offx = offy = 0;
xpav = ypav = 0;
xpv0 = ypv0 = 0;
xszpav = yszpav = 1;
xmv0 = ymv0 = -1;
dxmv = dymv = 0;
xcurs = ycurs = -1;
zoom = 1;

SetColMap(CMAP_COLRJ32);

SelForeground(PI_White);
SelBackground(PI_Black);

ActivateButton(1);
ActivateMove(1);
ActivateButton(2);
ActivateMove(2);
ActivateButton(3);
ActivateMove(3);

}

/* --Methode-- */
PIImage::~PIImage()
{
if (pixm) delete pixm;
if (zpixm) delete zpixm;
if (lut) delete lut;
if (aisup)  delete img;   // Suppression automatique d'image
if (trtw)  delete trtw;
}

/* --Methode-- */
void PIImage::SetImage(RzImage *pim, bool refr)
{

offx = offy = 0;
xpav = ypav = 0;
xszpav = yszpav = 1;
img = pim;
if (img)
  {
//  SetSize(img->XSize(), img->YSize());
  CenterPave();
  if (img->minPix>img->maxPix) img->CheckDyn();
  SetLut(img->minPix, img->maxPix, kLutType_Lin, 1, refr);
  }
return;
}


/* --Methode-- */
void PIImage::SetZoomWin(PIPixmap * zw, bool refr) 
{
zow = zw;
if (zow && refr && img)
  {
  zow->SetColMap(GetColMapId(), false);
  ComputeZoomPixmap();
  }
return;
}

/* --Methode-- */
void PIImage::SetTextWin(PILabel * tw, bool trw, int tx, int ty)
{
txw = tw;
if (trw)
  {
  if (trtw)  trtw->SetSize(tx, ty);
  else
    {
    trtw = new PIWindow(this, "PixVal", PIWK_transient, tx, ty, 0, 0);
    trtw->SetAutoDelChilds(true);
    trtlb = new PILabel(trtw, "PixVal", tx, ty, 0, 0);
    trtlb->SetBinding(PIBK_fixed,PIBK_fixed, PIBK_fixed,PIBK_fixed);
    }
  }
else
  if (trtw) { delete trtw; trtw = NULL;  trtlb = NULL; }

return;
}


/* --Methode-- */
void PIImage::SetAutoDelImage(bool ad)
{
aisup = ad;
return;
}

/* --Methode-- */
void PIImage::ShowCursor(bool sc)
{
if (curshow == sc) return;
curshow = sc;
if (curshow)  DrawCursor();
else DrawCursor(-1, -1);
return;
}

/* --Methode-- */
void PIImage::SetLut(float min, float max, int typlut, int lauto, bool refr)
{
if (lut) delete(lut);
if (lauto && img)
  {
  float fracnul, fracsat;
  float fnd, sigfnd;
  float minpix = min;  
  float maxpix = max; 
  int npix = img->XSize()*img->YSize();
  int rc = -1;
  if (npix > 2500)  // Ca ne marche pas quand il n'y a pas assez de pixels ...
    {  
    int vitesse=npix/20000;
    vitesse = (vitesse < 1) ? 1 : ((vitesse > 25) ? 25 : vitesse );
    int nbin=npix/10;
    nbin = (nbin < 1) ? 1 : ((nbin > 500) ? 500 : nbin );
    int nbsig = lauto;  
    float fracmax = 0.95;
    rc = RzFondSig2Ciel(img, vitesse, fracmax, nbsig, nbin, &minpix, &maxpix, 
                 &fnd, &sigfnd, &min, &max, &fracnul, &fracsat);
    }
  if (rc != 0)
    {
    img->CheckDyn(minpix, maxpix);
    min = img->moyPix-3.*img->sigPix;
    max = img->moyPix+3.*img->sigPix;
    if (min < minpix)  min = minpix;
    if (max > maxpix)  max = maxpix;
    }
  }

lut = new LUT(min, max, NbCol(), typlut);

if (refr) Apply();
return;
}


/* --Methode-- */
void PIImage::SetLut(LUT *clut, bool refr)
{
LUT * olut = lut;
lut = new LUT(clut->Min(), clut->Max(), NbCol(), clut->Type());
if (olut) delete olut;

if (refr) Apply();
return;
}

/* --Methode-- */
void PIImage::SetZoomF(float fzm, bool refr)
{
int zm;

if (fzm < 0.01) return;
if (fzm < 1.)  zm = (int)(-(1./fzm));
else zm = (int)(fzm+0.25);
SetZoom(zm, refr);
return;
}

/* --Methode-- */
void PIImage::SetZoom(int zm, bool refr)
{
if ((zm == 0) || (zm == -1) )  zoom = 1;
else if (zm > 10)  zoom = 10;
else if (zm < -10) zoom = -10;
else zoom = zm;
if (img)
  { SetOffsetFromPave();
  if (refr) Apply(); }
return;
}

/* --Methode-- */
float PIImage::GetZoomF()
{
if (zoom >= 1)  return((float)zoom);
else return(-1./(float)zoom);
}


/* --Methode-- */
void PIImage::SetOffset(int ox, int oy, bool refr)
{
if (img == NULL)  {offx = offy = 0;  return; }
if (ox < 0)  ox = 0;
if (ox >= (img->XSize()-1))  ox = img->XSize()-2;
if (oy < 0)  oy = 0;
if (oy >= (img->YSize()-1))  oy = img->YSize()-2;
offx = ox;  offy = oy;
CenterPave();
if (refr) Apply();
return;
}


/* --Methode-- */
void PIImage::SetPave(int x, int y, bool refr)
{
int xc, yc;

if (img == NULL)  
  { offx = offy = 0; 
  xpav = ypav = 0; 
  return; }

if ( (x >= (img->XSize()-1)) || ( x < 0)  ||
     (y >= (img->YSize()-1)) || ( y < 0)  ) return;

xpav = x;  ypav = y;
if (PosImg2W(xpav,ypav,&xc, &yc))  // Il faut recenter l'image
  { SetOffsetFromPave();  
  if (refr) Apply(true);  }
else if (refr)
  { Apply(false);  if (curshow)  DrawCursor();  }

return;
}


/* --Methode-- */
void PIImage::SetColMap(CMapId cmap, bool refr)
{
PIPixmap::SetColMap(cmap, refr);
if (zow)  zow->SetColMap(cmap, refr);
return;
}


/* --Methode-- */
void PIImage::Apply(bool mw)
{
if (img == NULL)  return;
if (mw)
  { 
  ComputePixmap();
  Send(Msg(), PIMsg_Active);
  }
if (zow != NULL) 
  {
  zow->SetColMap(GetColMapId(), false);
  ComputeZoomPixmap();
  }
if (txw || trtlb)
  {
  char buff[256];
  sprintf(buff,"X= %d , Y= %d  PixVal= %g ",  /*(char *)Nom().c_str(),*/
          xpav, ypav, img->FValue(xpav, ypav));
  if (txw)  txw->SetLabel((string)buff);
  if (trtlb)  trtlb->SetLabel((string)buff);
  }

return;
}

/* --Methode-- */
void PIImage::Resize()
{
// printf("PIImage::Resize\n");
PIPixmap::Resize();
CenterPave();
Apply();
return;
}

/* --Methode-- */
void PIImage::Draw(int x0, int y0, int dx, int dy)
{
PIPixmap::Draw(x0, y0, dx, dy);
winovis = false;    // $CHECK$ Reza A enlever si possible 17/6/96
if (curshow)
  {
  int xc,yc;
  PosImg2W(xpav, ypav, &xc, &yc);
  if ((xc >= x0) && (xc < x0+dx) && 
      (yc >= y0) && (yc < y0+dy) )  DrawCursor(xc, yc);
  }
return;
}

/* --Methode-- */
void PIImage::But1Press(int x, int y)
{
int xp, yp;

Send(Msg(), PIMsg_Active);
if (img == NULL)  return;
if ( PosW2Img(x, y, &xp, &yp) )  return;
SelPointerShape(PI_CrossPointer);
xpav = xp;  ypav = yp;
ShowTrTxW();
Apply(false);
if (curshow)  DrawCursor(-1,-1);
return;
}


/* --Methode-- */
void PIImage::Ptr1Move(int x, int y)
{
int xp, yp;
if (img == NULL)  return;
if ( PosW2Img(x, y, &xp, &yp) )  return;
xpav = xp;  ypav = yp;
Apply(false);
return;
}


/* --Methode-- */
void PIImage::But1Release(int /*x*/,  int /*y*/)
{
SelPointerShape(PI_ArrowPointer);
if (curshow)  DrawCursor();
if (trtw)  trtw->Hide();
return;
}


/* --Methode-- */
void PIImage::But2Press(int x, int y)
{
int xp, yp;

Send(Msg(), PIMsg_Active);
if (img == NULL)  return;
if ( PosW2Img(x, y, &xpv0, &ypv0) )  {  xmv0 = -1;  return; }
xmv0 = x;  ymv0 = y;  dxmv = dymv = 0;
if (curshow)  DrawCursor(-1,-1);
SelGOMode(PI_GOXOR);
if (GetColMapId() == CMAP_COLRJ32)
SelForeground(PI_Yellow);
else SelForeground(PI_Magenta);
SelLine(PI_NormalLine);
ShowTrTxW();
return;
}

/* --Methode-- */
void PIImage::Ptr2Move(int x, int y)
{
int xp, yp;
if (img == NULL)  return;
if (xmv0 < 0)  return;
if ( PosW2Img(x, y, &xp, &yp) )  return;
DrawBox(xmv0, ymv0, dxmv, dymv);
dxmv = x-xmv0;  dymv = y-ymv0;
DrawBox(xmv0, ymv0, dxmv, dymv);
if (txw || trtlb)
  {
  char buff[256];
  sprintf(buff,"X,Y= %d,%d  PixVal= %g (X,Yc= %d,%d)",  
          xp, yp, img->FValue(x, yp), (xp+xpv0)/2, (yp+ypv0)/2);
  if (txw)  txw->SetLabel((string)buff);
  if (trtlb)  trtlb->SetLabel((string)buff);
  }
return;
}

/* --Methode-- */
void PIImage::But2Release(int x, int y)
{
int xp2, yp2;

if (img == NULL)  return;
if (xmv0 < 0)  return;
DrawBox(xmv0, ymv0, dxmv, dymv);
SelGOMode(PI_GOCopy);
SelForeground(PI_White);
if ( PosW2Img(x, y, &xp2, &yp2) )  
  PosW2Img(xmv0+dxmv, ymv0+dymv, &xp2, &yp2);
xpav = (xpv0+xp2)/2;
ypav = (ypv0+yp2)/2;
xszpav = ((xp2-xpv0) > 0) ? (xp2-xpv0) : 1;
yszpav = ((yp2-ypv0) > 0) ? (yp2-ypv0) : 1;

Apply(false);
if (curshow)  DrawCursor();
if (trtw)  trtw->Hide();
return;
}


/* --Methode-- */
void PIImage::But3Press(int x, int y)
{
int xp, yp;

Send(Msg(), PIMsg_Active);
if (img == NULL)  return;
if ( PosW2Img(x, y, &xp, &yp) )  { xmv0 = -1;  return; }
if (curshow)  DrawCursor(-1,-1);
ShowTrTxW();
SelPointerShape(PI_TDLRArrowPointer);
xmv0 = xp;
ymv0 = yp;
return;
}


/* --Methode-- */
void PIImage::Ptr3Move(int x, int y)
{
int xp, yp;
if (img == NULL)  return;
if (xmv0 < 0)  return;
if ( PosW2Img(x, y, &xp, &yp) )  return;
if (txw || trtlb)
  {
  char buff[256];
  sprintf(buff,"DelX= %d , DelY= %d ", xp-xmv0, yp-ymv0);
  if (txw) txw->SetLabel((string)buff);
  if (trtlb) trtlb->SetLabel((string)buff);
  }
}

/* --Methode-- */
void PIImage::But3Release(int x, int y)
{
int xp, yp;

SelPointerShape(PI_ArrowPointer);
if (trtw)  trtw->Hide();
if (img == NULL)  return;
if (xmv0 < 0)  return;
if ( PosW2Img(x, y, &xp, &yp) )  return;

offx -= (xp-xmv0);
offy -= (yp-ymv0);

if (offx < 0)  offx = 0;
if (offy < 0)  offy = 0;
if (offx >= img->XSize())  offx = img->XSize();
if (offy >= img->YSize())  offy = img->YSize();
xpav = xmv0;  ypav = ymv0;
xmv0 = ymv0 = -1;
Apply();
return;
}

/* --Methode-- */
unsigned char *  PIImage::ComputePixmap(int ofx, int ofy, int zm, 
                           int xwsz, int ywsz, unsigned char * opix, 
                           int * oxsp, int * oysp)
{
unsigned char *pix, *pp, ucp;
int zmm=1;
int npx, npy, nppx, nppy, nszp, oszp;
int i,j,k,l;
float vpx;


if ( (img == NULL) || (lut == NULL) ) 
  { /* printf("PIImage::ComputePixmap:Pb img ou lut %ld %ld \n", 
            (long)img, (long)lut); */
  *oxsp = *oysp = 0; return(NULL); }

npx = img->XSize()-ofx;
npy = img->YSize()-ofy;

if ((zm == 0) || (zm == -1))  zm = 1;

if (zm >= 1)
  {
  if (npx > (xwsz/zm))  npx = xwsz/zm; 
  if (npy > (ywsz/zm))  npy = ywsz/zm;
  nppx = npx*zm;   nppy = npy*zm;
  }
if (zm < -1)
  {
  zmm = -zm;
  nppx = npx/zmm;   nppy = npy/zmm;
  if (nppx > xwsz)  nppx = xwsz; 
  if (nppy > ywsz)  nppy = ywsz;
  npx = nppx*zmm;   npy = nppy*zmm; 
  }

oszp = (*oxsp)*(*oysp);
nszp = nppx*nppy;
if ( oszp != nszp )
  {
  if (opix)  delete[] opix;
  pix = new unsigned char[nppx*nppy];
  if (pix == NULL)  { *oxsp = *oysp = 0; ; return(NULL); }
  }
else  pix = opix;
*oxsp = nppx; *oysp = nppy;

/*
printf("Debug_ComputePixmap %d %d %d (%d-%d %d-%d)\n", 
      ofx, ofy, zm, npx,nppx, npy,nppy);
*/

pp = pix;
if (zm == 1)    // Pas de zoom  
  {
  for(j=ofy; j<ofy+npy; j++)
    for(i=ofx; i<ofx+npx; i++) 
      { *pp = (unsigned char) lut->Apply(img->FValue(i,j));  pp++; }
  }
else if (zm < -1)        // Compression 
  {
  float fv = (float)(zmm*zmm); 
  for(j=ofy; j<ofy+npy; j+=zmm)
    for(i=ofx; i<ofx+npx; i+=zmm)
      {
      vpx = 0;
      for(l=0; l<zmm; l++)
        for(k=0; k<zmm; k++)
          vpx += img->FValue(i+k, j+l);
      *pp = (unsigned char) lut->Apply(vpx/fv); 
      pp++;
      }
  }
else      // Agrandissement
  {
  for(j=ofy; j<ofy+npy; j++)
    for(i=ofx; i<ofx+npx; i++)
      {
      ucp = (unsigned char) lut->Apply(img->FValue(i,j));
      for(l=0; l<zm; l++)
        {
        pp = pix+((j-ofy)*zm+l)*nppx+((i-ofx)*zm);
        for(k=0; k<zm; k++)  { *pp = ucp; pp++; }  
	}
      }
  }

return(pix);
}

/* --Methode-- */
void PIImage::ComputePixmap()
{
unsigned int xwsz, ywsz;

if (img == NULL)  return;
xwsz = this->XSize();
ywsz = this->YSize();

pixm = ComputePixmap(offx, offy, zoom, xwsz, ywsz, pixm, &xspxm, &yspxm);
SetPixmap(pixm, xspxm, yspxm); 
// Refresh();
return; 
}


/* --Methode-- */
void PIImage::ComputeZoomPixmap()
{
unsigned int xwsz, ywsz;
int ofx, ofy;
int zm;

if (zow == NULL)  return;
if (img == NULL)  return;

xwsz = zow->XSize();
ywsz = zow->YSize();

zm = zoom+4;
if ( (zm==-1) || (zm == 0) ) zm = 1;
if (zm > 0)
  {
  ofx = xpav-(xwsz/2/zm);
  ofy = ypav-(ywsz/2/zm);
  }
else 
  {
  ofx = xpav+(xwsz*zm/2);
  ofy = ypav+(ywsz*zm/2);
  }
if (ofx < 0)  ofx = 0;
if (ofy < 0)  ofy = 0;

zpixm = ComputePixmap(ofx, ofy, zm, xwsz, ywsz, zpixm, &xszpxm, &yszpxm);
zow->SetPixmap(zpixm, xszpxm, yszpxm); 
zow->SetUserData((void *)this, 0);
// zow->Refresh();
return; 

}

/* --Methode-- */
void PIImage::DrawCursor() 
{
int xc, yc;
if (PosImg2W(xpav, ypav, &xc, &yc)) DrawCursor(-1, -1);
else DrawCursor(xc, yc);
return;
}

#define CURSHSIZE  25
 
/* --Methode-- */
void PIImage::DrawCursor(int xc, int yc)
{

if ((xcurs>=0) && (ycurs>=0))
  PIPixmap::Draw(xcurs-CURSHSIZE, ycurs-CURSHSIZE, CURSHSIZE*2, CURSHSIZE*2); 

if ((xc >= 0) && (yc >= 0)) 
  {
  xcurs = xc;   ycurs = yc;
  if (winovis)  return;      // $CHECK$ Reza A enlever si possible 17/6/96
  if (zoom < 3)  SelLine(PI_NormalLine);
  else SelLine(PI_ThickLine);
  SelGOMode(PI_GOCopy);
  DrawLine(xcurs-CURSHSIZE, ycurs, xcurs-4, ycurs);
  DrawLine(xcurs+4, ycurs, xcurs+CURSHSIZE, ycurs);
  DrawLine(xcurs, ycurs-CURSHSIZE, xcurs, ycurs-4);
  DrawLine(xcurs, ycurs+4, xcurs, ycurs+CURSHSIZE);
  }
else { xcurs = ycurs = -1; }

return;
}

/* --Methode-- */
void PIImage::ShowTrTxW()
{
if (trtw) 
  {
  int tpx, tpy;
  GetScreenPos(tpx, tpy);
  tpy -= (trtw->YSize()+5);
  if (tpy < 0)  tpy = 0;
  trtw->SetPos(tpx, tpy);
  trtw->Show();  
  }

return;
}

/* --Methode-- */
int PIImage::PosW2Img(int xiw, int yiw, int * xp, int * yp)
{

if (zoom > 0)
  {
  *xp = xiw/zoom+offx;
  *yp = yiw/zoom+offy;
  }
else
  {
  *xp = offx-xiw*zoom;
  *yp = offy-yiw*zoom;
  }

if ( (*xp >= 0) && (*xp < img->XSize() ) &&
     (*yp >= 0) && (*yp < img->YSize() )  )   return(0);
else return(1);
}


/* --Methode-- */
int PIImage::PosImg2W(int xp, int yp, int * xiw, int * yiw)
{
if (zoom > 0)
  {
  *xiw = (xp-offx)*zoom+(zoom/2);
  *yiw = (yp-offy)*zoom+(zoom/2);
  }
else
  {
  *xiw = (offx-xp)/zoom;
  *yiw = (offy-yp)/zoom;
  }

if (*xiw > XSize())  *xiw = -1;
if (*yiw > YSize())  *yiw = -1;

if ((*xiw < 0) || (*yiw < 0))  return(1);
else return(0);
}


/* --Methode-- */
void PIImage::SetOffsetFromPave()
{
if (zoom > 0)
  {
  offx = xpav-XSize()/2/zoom;
  offy = ypav-YSize()/2/zoom;
  }
else
  {
  offx = xpav+XSize()/2*zoom;
  offy = ypav+YSize()/2*zoom;
  }

if (offx < 0)  offx = 0;
if (offx >= (img->XSize()-1))  offx = img->XSize()-2;
if (offy < 0)  offy = 0;
if (offy >= (img->YSize()-1))  offy = img->YSize()-2;

return;
}

/* --Methode-- */
void PIImage::CenterPave()
{
int xwsz, ywsz;

if (zoom > 0)
  { xwsz = XSize()/zoom;  
  ywsz = YSize()/zoom;  }
else
  { xwsz = -(XSize()*zoom); 
  ywsz = -(YSize()*zoom); }
  
if (xwsz > (img->XSize()-offx)) xwsz = (img->XSize()-offx);
if (ywsz > (img->YSize()-offy)) ywsz = (img->YSize()-offy);
xpav = offx+xwsz/2; 
ypav = offx+ywsz/2;
xszpav = ((xwsz+ywsz)/20) ;
if (xszpav < 1) xszpav = 1;
yszpav = xszpav; 

return;
}
