#include<stdlib.h>
#include<string.h>

#include "pisysdep.h"
#include PISTDWDG_H

/************* PILabelX ************/
#include <Xm/Label.h>


/* --Methode-- */
PILabelX::PILabelX(PIContainerGen *par, char *nom,
                   int sx, int sy, int px, int py)
: PILabelGen(par, nom, sx, sy, px, py)
{
Arg warg[2];

CreateXtWdg(nom, xmLabelWidgetClass, NULL, sx, sy, px, py);
SetBorderWidth(0);
XtSetArg(warg[0], XmNrecomputeSize, FALSE);  
XtSetValues(XtWdg(), warg, 1);
Manage();
}

/* --Methode-- */
PILabelX::~PILabelX()
{}


/************* PIButtonX ************/
#include <Xm/PushB.h>
#include <Xm/ArrowB.h>

// Fonctions privees (CallBack)
static void button_action(Widget w, XtPointer *usd, XtPointer *calld);
static void button_press(Widget w, XtPointer *usd, XmAnyCallbackStruct *calld);

/* Nouvelle-Fonction */
void  button_action(Widget , XtPointer *usd, XtPointer *)
{
PIButtonX *pib;
pib = (PIButtonX *) usd ;
pib->Send(pib->Msg(),PIMsg_Click,NULL);
return;
}

/* Nouvelle-Fonction */
void  button_press(Widget, XtPointer *usd, XmAnyCallbackStruct *calld)
{
PIButtonX *pib;
pib = (PIButtonX *) usd ;
pib->Send(pib->Msg(),PIMsg_Press,NULL);
pib->myevt = *(calld->event);
pib->myevt.type = pib->myevt.xbutton.type = ButtonRelease;
pib->myevt.xbutton.serial += 10;

return;
}


/* --Methode-- */
PIButtonX::PIButtonX(PIContainerGen *par, char *nom, PIMessage msg, 
                     int sx, int sy, int px, int py, PIBtnSign bsgn)
: PIButtonGen(par, nom, msg, sx, sy, px, py, bsgn)
{

Arg  warg[3];
int n = 0;

XtSetArg(warg[n],XmNhighlightThickness, 0);  n++;
XtSetArg(warg[n], XmNrecomputeSize, FALSE);  n++;

if (bsgn == PIBtn_Label)
  CreateXtWdg(nom, xmPushButtonWidgetClass, NULL, sx, sy, px, py);
else
  {
  CreateXtWdg(nom, xmArrowButtonWidgetClass, NULL, sx, sy, px, py);
  switch (bsgn)
    {
    case PIBtn_ArrowUp :
      XtSetArg(warg[n], XmNarrowDirection, XmARROW_UP);  n++;
      break;
    case PIBtn_ArrowDown :
      XtSetArg(warg[n], XmNarrowDirection, XmARROW_DOWN);  n++;
      break;
    case PIBtn_ArrowLeft :
      XtSetArg(warg[n], XmNarrowDirection, XmARROW_LEFT);  n++;
      break;
    case PIBtn_ArrowRight :
      XtSetArg(warg[n], XmNarrowDirection, XmARROW_RIGHT);  n++;
      break;
    }
  }

XtSetValues(XtWdg(), warg, n);
XtAddCallback(XtWdg(), XmNactivateCallback, 
              button_action, (XtPointer)this);

mAcP = false;
SetBorderWidth(0);
Manage();
}

/* --Methode-- */
PIButtonX::~PIButtonX()
{}

/* --Methode-- */
void PIButtonX::ActivatePress(bool acp)
{
if (mAcP == acp)  return; 
    
if (mAcP)
  XtRemoveCallback(XtWdg(), XmNarmCallback, 
                   button_press, (XtPointer)this);
else 
  XtAddCallback(XtWdg(), XmNarmCallback, 
                button_press, (XtPointer)this);
mAcP = acp;
return;
}       

/* --Methode-- */
void PIButtonX::ReleaseButton()
{
XPutBackEvent(myevt.xbutton.display, &myevt);
return;
}


/************* PITextX ************/
#include <Xm/Text.h>

/* --Methode-- */
PITextX::PITextX(PIContainerGen *par, char *nom,
                 int sx, int sy, int px, int py)
: PITextGen(par, nom, sx, sy, px, py)
{
CreateXtWdg(nom, xmTextWidgetClass, NULL, sx, sy, px, py);
SetMutiLineMode(false);
SetTextEditable(true);
Manage();
}

/* --Methode-- */
PITextX::~PITextX()
{}

/* --Methode-- */
void PITextX::SetText(string const& s)
{
XmTextSetString(XtWdg(), (char *)s.c_str());
return;
}

/* --Methode-- */
string PITextX::GetText() const
{
char *txtb;
txtb = XmTextGetString(XtWdg());
string s(txtb);
XtFree(txtb);
return(s);
}

/* --Methode-- */
void PITextX::SetMutiLineMode(bool mlm)
{
Arg  warg[2];
int n = 0;

if (mlm)
  { XtSetArg(warg[n],XmNeditMode, XmMULTI_LINE_EDIT);  n++; }
else
  { XtSetArg(warg[n],XmNeditMode, XmSINGLE_LINE_EDIT);  n++; }

XtSetValues(XtWdg(), warg, n);
return;
}

/* --Methode-- */
void PITextX::SetTextEditable(bool te)
{
Arg  warg[2];
int n = 0;

if (te)
  { XtSetArg(warg[n],XmNeditable, TRUE);  n++; }
else
  { XtSetArg(warg[n],XmNeditable, FALSE);  n++; }

XtSetValues(XtWdg(), warg, n);
return;
}

// Fonction privee (CallBack)
static void text_action(Widget w, XtPointer *usd, XtPointer *calld);

void  text_action(Widget, XtPointer *usd, XtPointer *)
{
PIText *pit;

pit = (PIText *) usd ;
pit->Send(pit->Msg(), PIMsg_DataChanged, NULL);
}


/* --Methode-- */
void PITextX::SetMsg(PIMessage msg)
{

if (Msg() && !msg)
  XtRemoveCallback(XtWdg(), XmNactivateCallback, 
                   text_action, (XtPointer)this);
if (!Msg() && msg)
  XtAddCallback(XtWdg(), XmNactivateCallback, 
                text_action, (XtPointer)this);

PIWdg::SetMsg(msg);
}


/************* PIScaleX ************/
#include <Xm/Scale.h>

// Fonction prive (CallBack)
static void scale_action(Widget w, XtPointer *usd, 
                         XmScaleCallbackStruct *calld);

void  scale_action(Widget, XtPointer *usd, 
                         XmScaleCallbackStruct *calld)
{
PIScale *pis;

pis = (PIScale *) usd ;
pis->CBSetVal(calld->value);
pis->Send(pis->Msg(), PIMsg_DataChanged, (void *)calld->value);
return;
}

/* --Methode-- */
PIScaleX::PIScaleX(PIContainerGen *par, char *nom, PIMessage msg,
                   int min, int max, int sx, int sy, int px, int py)
: PIScaleGen(par, nom, msg, min, max, sx, sy, px, py)
{
int n=0;
Arg warg[6];
CreateXtWdg(nom, xmScaleWidgetClass, NULL, sx, sy, px, py);
XtSetArg(warg[n], XmNshowValue, TRUE); n++;
if (sx > sy)
  {
  XtSetArg(warg[n], XmNorientation, XmHORIZONTAL); n++;
  XtSetArg(warg[n], XmNprocessingDirection, XmMAX_ON_RIGHT); n++;
  }
else
  { 
  XtSetArg(warg[n], XmNorientation, XmVERTICAL); n++;
  XtSetArg(warg[n], XmNprocessingDirection, XmMAX_ON_TOP); n++;
  }
XtSetArg(warg[n], XmNscaleWidth, sx); n++;
XtSetArg(warg[n], XmNscaleHeight, sy); n++;
XtSetArg(warg[n], XmNstringDirection, XmSTRING_DIRECTION_R_TO_L); n++;

XtSetValues(XtWdg(), warg, n);
SetMinMax(min, max);
SetValue(min);
XtAddCallback(XtWdg(), XmNvalueChangedCallback, 
              scale_action, (XtPointer)this);
Manage();
}

/* --Methode-- */
PIScaleX::~PIScaleX()
{}

/* --Methode-- */
void PIScaleX::SetMinMax(int min, int max)
{
if (min >= max)  max = min+10;
if (mVal < min)  mVal = min;
if (mVal > max)  mVal = max;
int n=0;
Arg warg[3];
XtSetArg(warg[n], XmNminimum, min); n++;
XtSetArg(warg[n], XmNmaximum, max); n++;
XtSetArg(warg[n], XmNvalue, mVal); n++;
XtSetValues(XtWdg(), warg, n);
mMin = min;   mMax = max;
return;
}


/* --Methode-- */
void PIScaleX::SetValue(int val)
{
int n=0;
if (val < mMin)  val = mMin;
if (val > mMax)  val = mMax;
Arg warg[2];
XtSetArg(warg[n], XmNvalue, val); n++;
XtSetValues(this->sdw, warg, n);
return;
}

/* --Methode-- */
int  PIScaleX::GetValue()
{
int val;
int n=0;
Arg warg[2];
XtSetArg(warg[n], XmNvalue, &val); n++;
XtGetValues(this->sdw, warg, n);
mVal = val;
return(val);
}

/* --Methode-- */
void  PIScaleX::CBSetVal(int val)
{
mVal = val;
return;
}

/************* PICheckBoxX ************/
#include <Xm/ToggleB.h>

// Fonction prive (CallBack)
static void toggb_action(Widget w, XtPointer *usd, XtPointer *calld);

/* Nouvelle-Fonction */
void  toggb_action(Widget , XtPointer *usd, XtPointer *)
{
PICheckBoxX *picb;
picb = (PICheckBoxX *) usd ;
picb->Send(picb->Msg(), PIMsg_DataChanged, (void *)picb->GetState());
return;
}

/* --Methode-- */
PICheckBoxX::PICheckBoxX(PIContainerGen *par, char *nom, PIMessage msg,
                         int sx, int sy, int px, int py)
: PICheckBoxGen(par, nom, msg, sx, sy, px, py)
{
CreateXtWdg(nom, xmToggleButtonWidgetClass, NULL, sx, sy, px, py);
XtAddCallback(XtWdg(), XmNvalueChangedCallback,
              toggb_action, (XtPointer)this);
Arg warg[2];
XtSetArg(warg[0],XmNhighlightThickness, 0);
XtSetValues(XtWdg(), warg, 1);
Manage();
}


/* --Methode-- */
PICheckBoxX::~PICheckBoxX()
{}


/* --Methode-- */
void PICheckBoxX::SetState(bool st)
{
Arg warg[2];
XtSetArg(warg[0],XmNset, st);
XtSetValues(XtWdg(), warg, 1);
return;
}

/* --Methode-- */
bool PICheckBoxX::GetState()
{
int val;
Arg warg[2];
XtSetArg(warg[0], XmNset, &val); 
XtGetValues(XtWdg(), warg, 1);
return ((bool)val);
}
