#ifndef PISTDWDGX_H_SEEN
#define PISTDWDGX_H_SEEN

#include "pistdwdggen.h"


class PILabelX : public PILabelGen
{
public:
                     PILabelX(PIContainerGen *par, char *nom,
                                 int sx=10, int sy=10, int px=0, int py=0);
  virtual           ~PILabelX();
  
};

class PIButtonX : public PIButtonGen
{
public:
                     PIButtonX(PIContainerGen *par, char *nom, 
                               PIMessage msg = PIMsg_Click,
                               int sx=10, int sy=10, int px=0, int py=0,
                               PIBtnSign bsgn = PIBtn_Label);
  virtual           ~PIButtonX();

  virtual void       ActivatePress(bool acp=false);

  void               ReleaseButton();   // Fonction a utiliser avec attention

  XEvent myevt;   // Attention - Pour usage interne 

protected :
  bool mAcP;
};


class PITextX : public PITextGen
{
public:
                     PITextX(PIContainerGen *par, char *nom, 
                                  int sx=10, int sy=10, int px=0, int py=0);
  virtual           ~PITextX();
  virtual void       SetText(string const&);
  virtual string     GetText() const;

  virtual void       SetMutiLineMode(bool mlm=false);
  virtual void       SetTextEditable(bool te=true);

  virtual void       SetMsg(PIMessage msg=0);
};

class PIScaleX : public PIScaleGen
{
public:
  PIScaleX(PIContainerGen* par, char* nom, PIMessage msg=PIMsg_Click,
         int min=0, int max=10, int sx=100, int sy=10, int px=0, int py=0);
  ~PIScaleX();

  virtual void SetMinMax(int min, int max);
  virtual void SetValue(int val);
  virtual int  GetValue(); 

  virtual void CBSetVal(int val);   // A ne pas utiliser pour Callback
protected: 
  int mVal, mMin, mMax;
};


class PICheckBoxX : public PICheckBoxGen
{
public:
                     PICheckBoxX(PIContainerGen *par, char *nom, 
                                 PIMessage msg=PIMsg_Click,
                                 int sx=10, int sy=10, int px=0, int py=0);
  virtual           ~PICheckBoxX();

  virtual void       SetState(bool st=false);
  virtual bool       GetState();
};


typedef PILabelX       PILabel;
typedef PIButtonX      PIButton;
typedef PITextX        PIText;
typedef PIScaleX       PIScale;
typedef PICheckBoxX    PICheckBox;


#endif
