#include <stdio.h>
#include <X11/cursorfont.h>
#include "piapplx.h"
#include "picontainerx.h"


#define DEBUG_APPLX

static Cursor a_curs[3];
static bool a_fgcur=false;

/* --Methode-- */
PIApplicationX::PIApplicationX(int sx, int sy, int narg, char *arg[])
: PIApplicationGen()
{
int sxt, syt;

#ifdef DEBUG_APPLX
puts("PIApplicationX::PIApplicationX()_info : App creation");
#endif
mStop = true;
topwdg = new PIWdgX(narg, arg);

intcont = new PIContainerX((PIMsgHandler *)this, topwdg, "MBCont", 
                            10, 10, 0, 0);
menubar = new PIMenubar(this, "DefMenubar");
Menubar()->SetBinding(PIBK_fixed, PIBK_fixed, PIBK_fixed, PIBK_free);
sxt = ( sx > Menubar()->XSize() ) ? sx : Menubar()->XSize();
syt = ( sy > 0 ) ? sy : 0;
//syt += Menubar()->YSize();
syt += 40;
MBCont()->SetSize(sxt, syt);
if ( (sx > 0) && (sy > 0) )
  {
  topcont = new PIContainerX(MBCont(), "TopLevelCont", 
                             sx, sy, 0, 40);
  topcont->SetBinding(PIBK_fixed, PIBK_fixed, PIBK_fixed, PIBK_fixed);
  topcont->Show();
  }
else topcont = MBCont();

MBCont()->Show();
topwdg->Manage();

if (!a_fgcur)
  {
  Display *mdsp;
  mdsp = XtDisplay (topwdg->XtWdg()); 
  a_curs[0] = XCreateFontCursor(mdsp, XC_arrow);
  a_curs[1] = XCreateFontCursor(mdsp, XC_X_cursor);
  a_curs[2] = XCreateFontCursor(mdsp, XC_watch);
  }

mState = -1;
SetReady();
}

/* --Methode-- */
PIApplicationX::~PIApplicationX()
{
#ifdef DEBUG_APPLX
puts("PIApplicationX::~PIApplicationX()_info : App delete");
#endif
Display *mdsp;
mdsp = XtDisplay (topwdg->XtWdg()); 
topwdg->Unmanage();
delete menubar;
if (topcont != MBCont())  delete topcont;
delete intcont;
delete topwdg;
XtCloseDisplay(mdsp);
return;
}

/* --Methode-- */
void PIApplicationX::Run()
{
XEvent evt;
#ifdef DEBUG_APPLX
puts("PIApplicationX::Run()_info : App Run ");
#endif

topwdg->SetSize(MBCont()->XSize(), MBCont()->YSize());

while (mStop)
  {
  XtNextEvent(&evt);
  XtDispatchEvent(&evt);
  }
return;
}


/* --Methode-- */
void PIApplicationX::SetReady()
{
if (mState != kReadyState)
  {
  Display * mdsp;
  mState = kReadyState;
  mdsp = XtDisplay (topwdg->XtWdg());
  XDefineCursor(mdsp, XtWindow(topwdg->XtWdg()), a_curs[0]);
  XFlush(mdsp);
  }
}

/* --Methode-- */
void PIApplicationX::SetBusy()
{
if (mState != kBusyState)
  {
  Display * mdsp;
  mState = kBusyState;
  mdsp = XtDisplay (topwdg->XtWdg());
//  if ( XtIsRealized(topwdg->XtWdg()) )
  XDefineCursor(mdsp, XtWindow(topwdg->XtWdg()), a_curs[2]);
  XFlush(mdsp);
  }
return;
}

/* --Methode-- */
void PIApplicationX::SetBlocked()
{
if (mState != kBlockedState)
  {
  Display * mdsp;
  mState = kBlockedState;
  mdsp = XtDisplay (topwdg->XtWdg());
  XDefineCursor(mdsp, XtWindow(topwdg->XtWdg()), a_curs[1]);
  XFlush(mdsp);
  }
}
