// This may look like C code, but it is really -*- C++ -*-
#ifndef PIERRDISP_H_SEEN
#define PIERRDISP_H_SEEN

#include "pisysdep.h"
#include PIBWDG_H
#include PISTDWDG_H
#include PICONT_H
#include PIPERIOD_H
#include <string>

#include "errorhandlerc.h"

class PIErrorBox : public PIBaseWdg {
public:
  PIErrorBox(PIContainerGen* par, int sx=100, int sy = 50,
	     int px=0, int py=0);
  ~PIErrorBox();

  void Draw();
  
  void SetText(string const& txt) {currErrText = txt;}
  void Cycle();

protected:
  string currErrText;
  int           state;     // Cycle decoratif en couleurs violentes...  
};

class PIErrorDisplay : public PIContainer, public PIPeriodic {
public:
  
  PIErrorDisplay(PIContainerGen* par, int sx=150, int sy=50,
		 int px=0, int py=0);
  virtual      ~PIErrorDisplay();
  
  void          UpdData();
  void          Process(PIMessage msg, PIMsgHandler *sender, void *data);
  void          DoPeriodic() {UpdData();}
protected:
  int           currErrId;

  PIErrorBox*   errorBox;
  PIButton*     ackButton;
  PIButton*     updButton;   // TEMPORAIRE
};


#endif
