#ifndef PISCDRAWWDG_H
#define PISCDRAWWDG_H


#include "pisysdep.h"
#include PIBWDG_H
#include PISTDWDG_H
#include PIWIN_H

#include <list.h>

  enum {
    kStdAxes     = 0x0001,
    kBoxAxes     = 0x0002,
    kTicks       = 0x0004,
    kIntTicks    = 0x0010,
    kExtTicks    = 0x0020,
    kMajTicks    = 0x0040,
    kMinTicks    = 0x0080,
    kLabels      = 0x1000,
    kAxesDflt    = kStdAxes | kTicks | kLabels
  };


class PIScDrawWdg : public PIBaseWdg {
public:
                     PIScDrawWdg(PIContainerGen *par, char *nom,
                                   int sx=10, int sy=10, int px=0, int py=0);
  virtual           ~PIScDrawWdg();

  virtual void       SetLimits(double xmin, double xmax, double ymin, double ymax, bool tmp=false);
  
  virtual void       ScDrawString(double x, double y, char* s, int pos = 0);
  virtual void       ScDrawLine(double x1, double y1, double x2, double y2);
  virtual void       ScDrawBox(double x0, double y0, double dx, double dy);
  virtual void       ScDrawFBox(double x0, double y0, double dx, double dy);
  virtual void       ScDrawCircle(double x0, double y0, double r);
  virtual void       ScDrawFCircle(double x0, double y0, double r);
  virtual void       ScDrawPolygon(double *x, double *y, int n);  
  virtual void       ScDrawFPolygon(double *x, double *y, int n);
  virtual void       ScDrawMarker(double x0, double y0);
  virtual void       ScDrawMarkers(double *x0, double *y0, int n);

  virtual double     ScStringWidth(char const*);

  virtual void       ScSelFontSz(double size, PIFontAtt att=PI_RomanFont); 
  virtual void       ScSelMarker(double size=0, PIMarker mrk=PI_DotMarker); 

  virtual void       DrawAxes(int flags = -1);
  virtual void       DrawSelf() {}
  
  virtual void       Resize();
  
  virtual void       CalcTicks();
  virtual void       CalcScale();
  
  virtual void       Sc2Local(double x, double y, int& xpix, int& ypix);
  virtual void       Local2Sc(int xpix, int ypix, double& x, double& y);
  virtual void       DSc2Local(double dx, double dy, int& dxpix, int& dypix);
  
  virtual void       Draw();
  
  friend class PIScDrawer;
  virtual void       AddDrawer(PIScDrawer*);   // Ajoute un drawer
  virtual void       RemoveDrawer(PIScDrawer*);  // Ote un drawer sans le detruire
  virtual void       DeleteDrawers();            // Ote et detruit tous les drawers
  static  void       CallDrawer(PIScDrawer*);
  virtual void       CallDrawers();
  virtual void       SetAxesFlags(int flags=kAxesDflt);
  
  void               SetTextWin(PILabel * tw, bool trw=true, int tx=200, int ty=30);

  double XMin() const {return xMin;}
  double XMax() const {return xMax;}
  double YMin() const {return yMin;}
  double YMax() const {return yMax;}
  int    LimitsFixed() const {return limitsFixed;}
  void   FreeLimits() {limitsFixed = 0;}
  void   NoClip() {clip = false;}
  void   Clip() {clip = true;}
    

  virtual void       But1Press(int x, int y);
  virtual void       But1Release(int x, int y);
  virtual void       Ptr1Move(int x, int y);

  virtual void       But2Press(int x, int y);
  virtual void       But2Release(int x, int y);
  virtual void       Ptr2Move(int x, int y);
  
protected:
  double xMin, xMax, yMin, yMax; // Valeurs en unites user
  double xMinS, xMaxS, yMinS, yMaxS; // Sauvegarde pour zoom
  double xOrg, yOrg;             // Position en pixels de (0.0, 0.0)
  double xScale, yScale;         // Pixels par unites graphiques
  double xFirstMajTick, xFirstMinTick;
  double yFirstMajTick, yFirstMinTick;
  double xMajTickStep, xMinTickStep;
  double yMajTickStep, yMinTickStep;
  double xMajTickLen,  xMinTickLen;
  double yMajTickLen,  yMinTickLen;
  
  int limitsFixed;
  int axesFlags;
  list<PIScDrawer*>   mDrawers;
  
  int xBegDrag, yBegDrag;
  int xEndDrag, yEndDrag;
  PIColors cForCol;
  PIGOMode cGOmod;  
  PIPointer cPointer;
  PILineAtt cLatt;
  PILabel * mTxw;  
  PILabel * mTrlb;
  PIWindow * mTrW;
  bool clip;
  bool padsup;


private:
  void DrawHTicks(double y, double tickUp, double tickDown, double xBeg, double xStep);
  void DrawVTicks(double x, double tickLeft, double tickRight, double yBeg, double yStep);
  void DrawHLabels(double y, double xBeg, double xStep, int just=0);
  void DrawVLabels(double x, double yBeg, double yStep, int just=0);
  
  bool  UpdateText(int xp, int yp);
};

class PIScDrawer {
public:
                     PIScDrawer();
  virtual           ~PIScDrawer();

  virtual void       Draw() = 0;
protected:
  friend class       PIScDrawWdg;
  virtual void       AttachTo(PIScDrawWdg*);
  PIScDrawWdg*       mDrawWdg;
};

class PIScFuncDrawer : public PIScDrawer {
public:
  typedef double(*FUNC)(double);
                     PIScFuncDrawer(FUNC);
  virtual           ~PIScFuncDrawer();
  
  virtual void       Draw();
protected:
  FUNC               mFunc;
};

class GeneralFunction;
class PIScGFFDrawer : public PIScDrawer {
public:
                     PIScGFFDrawer(GeneralFunction*);
  virtual           ~PIScGFFDrawer();
  
  virtual void       Draw();
  virtual void       SetParms(double const*);
protected:
  GeneralFunction*    mFunc;
  int                 mNParms;
  double*             mParms;
};


#endif
