#include <string.h>

#include "pisysdep.h"

#include PIAPP_H
#include PIWIN_H 
#include PIMENU_H 
#include PIOPTMENU_H 
#include PISTDWDG_H 

#include PIFILECHO_H 

#include "piimage.h"
#include "pihisto.h"
#include "pidrawwin.h"


#define NMXWIN 25   // Nb maxi de fenetres ouvertes simultanement 

class VisuTools;
class CutTools;
class LutWind;
class UserProcWind;
class OptionWind;

class PIDemoApp : public PIApplication {
public:
     PIDemoApp(char *path);
     ~PIDemoApp();

     virtual void   Process(PIMessage msg, PIMsgHandler* sender, void* data=NULL);

     void AddImage(ImageR4 * nouv, string const & name, int zm=0, int typ=3);
     void AddHisto(Histo *h);
     void OpenImage(string const & flnm);
     void CloseCurrent();
     void SaveCurrentImg(string const & flnm);
     inline PIImage * CurrentPIImage() { return (mCurPII); }
     ImageR4 * CurrentImage();
     PIWindow * CurrentWindow() { return (mCurWin); };
     int  GetNumCurrent();
     int  GetCurrentWType();

     PIWindow * GetWindow(int sx, int sy, int typ, char * nom);

     inline VisuTools * VisTC()  { return mVisTC; } 
     inline CutTools *  CutTC()  { return mCutTC; } 

     inline PILabel * ImagLabelWdg() { return labimg; }
     inline PILabel * DrawLabelWdg() { return labdrw; }

private:
    void MBProcess1(PIMessage msg, PIMsgHandler* sender, void* data=NULL);
    void MBProcess2(PIMessage msg, PIMsgHandler* sender, void* data=NULL);
    void MBProcess3(PIMessage msg, PIMsgHandler* sender, void* data=NULL);
    void MBProcess4(PIMessage msg, PIMsgHandler* sender, void* data=NULL);
    bool FitPSF_Res(ImageR4 *pim);

    PIPDMenu  *m[5];
    PIButton * but;
    PIPixmap * zoom;
    PILabel  * labimg, *labdrw;
    PILabel  *lab, * mTlb[2];
    PIFileChooser * pfc;

    VisuTools *mVisTC;
    CutTools *mCutTC;

    int mTCId;

    PIWindow * awp[NMXWIN];
    int taw[NMXWIN];
    int mNwin,mTnw;
    PIWindow * mCurWin;
    PIImage * mCurPII;

    LutWind * mLutw;
    UserProcWind * mUP;
    OptionWind * mOptw;
};

/* --------------------------------------------------------------------------- */

class VisuTools : public PIContainer {
public :
  VisuTools(PIDemoApp *par, PIContainer *pw);
  ~VisuTools();
  virtual void  Process(PIMessage msg, PIMsgHandler* sender, void* data=NULL);

  PIPUMenu * ZoomOptMenu() { return mPum[1]; }
  PIPUMenu * LutOptMenu() { return mPum[0]; }
  PIPUMenu * ColMapOptMenu() { return mPum[2]; }

private:
  PIDemoApp * dap;
  PILabel * mTlb;
  PIPUMenu * mPum[3];
  PIOptMenu * mOpt[3];
  PILabel * mOlb[3];
  
};

/* --------------------------------------------------------------------------- */

class CutTools : public PIContainer {
public :
  CutTools(PIDemoApp *par, PIContainer *pw);
  ~CutTools();
  virtual void  Show();
  virtual void  Process(PIMessage msg, PIMsgHandler* sender, void* data=NULL);

private:
  void FillHistos();

  PIDemoApp * dap;
  PIButton * mBut[4];
  PIPUMenu * mPum;
  PIOptMenu * mOpt;
  PILabel * mOlb;
  
  int mDx, mDy, mDxy;
  int mPx, mPy;

  PIHisto * mPIH[2];
  PIScDrawWdg * mDrw[2]; 
  PILabel * mLab;

  bool fgpb;
  bool fgdiag;
  
};


/* --------------------------------------------------------------------------- */

class LutWind : public PIWindow {
public :
  LutWind(PIDemoApp *par);
  ~LutWind();
  virtual void  Show();
  virtual void  Process(PIMessage msg, PIMsgHandler* sender, void* data=NULL);

private:
  PIDemoApp * dap;
  PILabel * mLab[2];
  PIButton * mBut[2];
  PIText * mText[2];
  PIPUMenu * mPum[2];
  PIOptMenu * mOpt[2];
  PILabel * mOlb[2];
  
};

/* --------------------------------------------------------------------------- */

class UserProcWind : public PIWindow {
public :
                UserProcWind(PIDemoApp *par);
                ~UserProcWind();
  virtual void  Show();
  virtual void  Process(PIMessage msg, PIMsgHandler* sender, void* data=NULL);
  void          SelectUP(int n) { mUpr = n; };

private:
  PIDemoApp * dap;
  PILabel  * mLab[3];
  PIButton * mBut[2];
  PIText * mText[3];
  int mUpr;
  
};


/* --------------------------------------------------------------------------- */

class OptionWind : public PIWindow {
public :
  OptionWind(PIDemoApp *par);
  ~OptionWind();
  virtual void  Show();
  virtual void  Process(PIMessage msg, PIMsgHandler* sender, void* data=NULL);

private:
  PIDemoApp * dap;
  PILabel * mLab[8];
  PIButton * mBut[2];
  PIText * mText[8];
  PIPUMenu * mPum[2];
  PIOptMenu * mOpt[2];
  PILabel * mOlb[2];
  PILabel * mTlb[4];
  PICheckBox * mCkb[4];
  bool mCkv[4];
  
};
