// This may look like C code, but it's really -*- C++ -*-

#if !defined(_PSB2RING_H_SEEN_)
#define _PSB2RING_H_SEEN_

#include <iostream.h>
#include <string>
#include "toiprocessor.h"
#include "spherehealpix.h"
#include "localmap.h"
#include "flagtoidef.h"

class PSB2ring : public TOIProcessor
{
public:
  PSB2ring(SphereHEALPix<r_8>* ringQ, 
	   SphereHEALPix<r_8>* ringU,
	   SphereHEALPix<r_8>* ringQW,
	   SphereHEALPix<r_8>* ringUW,
	   const vector<r_8>& table_angle,
	   int_4 wsz=819);

  virtual ~PSB2ring();
  inline void SetWSize(int_4 wsz) { wsize_ = (wsz<4) ? 4 : wsz; }
  inline int_8 ProcessedSampleCount() const { return totsncount_; }
  void SetNSide(int_4 nside);
  virtual void init();
  virtual void run();
  
  virtual void PrintStatus(ostream& os);

protected:
  bool PSB2ringdone;

  SphereHEALPix<r_8>* ringq;   // carte de Q
  SphereHEALPix<r_8>* ringu;   // carte de U
  
  string ringqfile;
  string ringufile;

  vector<r_8> TableFP_;
  SphereHEALPix<r_8>* ringqw;   // carte du nb de hit
  SphereHEALPix<r_8>* ringuw;
  
  string ringqwfile;
  string ringuwfile;

  int wsize_;
  int_8 totsncount_;
  int_8 Npix_;
};

#endif











