#include "machdefs.h"
#include "pexceptions.h"
#include "ring33.h"


// -------------------------------------------------------
// Classe simple de matrice 3x3 - sans allocation memoire
// -------------------------------------------------------

// constructor
RingOfMatrix3x3::RingOfMatrix3x3(int_4 npix)
{
  if (npix < 1) throw RangeCheckError("RingOfMatrix3x3::RingMatrix3x3() size < 1 !");
  size_ = npix;
  mtxtab_ = new Matrix3x3[npix];
}

// Destructor
RingOfMatrix3x3::~RingOfMatrix3x3()
{
  delete[] mtxtab_;
}
