// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: toi2toi_addsp.cc,v 1.4 2002-07-16 17:01:36 cmv Exp $

#include "machdefs.h"
#include "toimanager.h"
#include "pexceptions.h"
#include "ctimer.h"
#include "toi2toi_addsp.h"
// La valeur "Pi" doit etre celle de smathconst.h a cause du test sur theta
#include "smathconst.h"

////////////////////////////////////////////////////////////////////////
Toi2toi_Addsp::Toi2toi_Addsp(int_4 ns)
  : nb_src(ns)
{
 Fill_Info_scr();
 SetEquinox();
 SetCoorIn();
 SetCoorMap();
 SetTestFlag();
 SetTestMin();
 SetTestMax();

}

Toi2toi_Addsp::~Toi2toi_Addsp()
{
}

////////////////////////////////////////////////////////////////////////
void Toi2toi_Addsp::Print(::ostream & os)
{
}

////////////////////////////////////////////////////////////////////////
void Toi2toi_Addsp::init() {
  cout << "Toi2toi_Addsp::init" << endl;
  declareInput("BoloIn"); 
  declareInput("Coord1In");
  declareInput("Coord2In");
  declareInput("utc"); 
  declareInput("lon"); 
  declareInput("lat"); 
 
  declareOutput("BoloOut");
}

////////////////////////////////////////////////////////////////////////
void Toi2toi_Addsp::run()
{
long snb = getMinIn();
long sne = getMaxIn();

if(snb>sne) {
  cout<<"Toi2toi_Addsp::run() - Bad sample interval"<<snb<<" , "<<sne<<endl;
  throw ParmError("Toi2toi_Addsp::run() - Bad sample interval");
}
if(!checkInputTOIIndex(0) || !checkInputTOIIndex(1) || !checkInputTOIIndex(2)) {
  cout<<"Toi2toi_Addsp::run() - Input TOI (Coord1In or Coord2In or BoloIn) not connected! "<<endl;
  throw ParmError("Toi2toi_Addsp::run() Output TOI (Coord1In or Coord2In or BoloIn) not connected!");
}
if( !(mTypCoorIn&TypCoordEq || mTypCoorIn&TypCoordGal) ) {
  cout<<"Toi2toi_Addsp::run() - Input Coordinates not Eq or Gal! "<<endl;
  throw ParmError("Toi2toi_Addsp::run() - Input Coordinates not Eq or Gal!");
}
if( !(mTypCoorMap&TypCoordEq || mTypCoorMap&TypCoordGal) ) {
  cout<<"Toi2toi_Addsp::run() - Output Coordinates not Eq or Gal! "<<endl;
  throw ParmError("Toi2toi_Addsp::run() - Output Coordinates not Eq or Gal!");
}

//---------------------------------------------------------
#define NFILL 25
try {

double mjd = MJDfrYear(mActualYear);

cout<<"Toi2toi_Addsp::run() from "<<snb<<" to "<<sne;

for(int s=snb;s<=sne;s++) {
  uint_8 fgbolo = 0;
  double bolo,bolo_sp,coord1,coord2;
  //              Equatoriales   /   Galactiques
  // coord1,2 =   alpha,delta    /   gLon,gLat

  getData(0,s,bolo,fgbolo);
  coord1 = getData(1,s);
  coord2 = getData(2,s);

  // Comme il n'y a pas de toi en sortie, il faut dire
  // aux processeur/toi que l'on a plus besoin des donnees.
  if (s%100 == 0) wontNeedBefore(s-1);
  if(mTFlag && fgbolo&mBadFlag) continue;
  if(mTMin && bolo<mValMin) continue;
  if(mTMax && bolo>mValMax) continue;

  // sphere phi   entre [0,2*Pi] en radians
  // sphere theta entre [0,Pi]   en radians
  double phi=-1.;
  CoordConvertToStd(mTypCoorIn,&coord1,&coord2);

  if(mTypCoorIn&TypCoordEq && mTypCoorMap&TypCoordGal) { // Eq -> Gal
    EqtoGal(mjd,coord1,coord2,&coord1,&coord2);
    phi   = coord1 * Pi/180.;
  } else if(mTypCoorIn&TypCoordGal && mTypCoorMap&TypCoordEq) { // Gal -> Eq
    GaltoEq(mjd,coord1,coord2,&coord1,&coord2);
    phi   = coord1 * Pi/12.;
  } else if(mTypCoorMap&TypCoordGal) { // Gal -> Gal
    phi   = coord1 * Pi/180.;
  } else if(mTypCoorMap&TypCoordEq) { // Eq -> Eq
    phi   = coord1 * Pi/12.;
  }
  ToCoLat(&coord2,TypUniteD);
  bolo_sp=bolo;
  
  putData(0,s,bolo_sp,fgbolo);

}
 

 cout<<"Toi2toi_Addsp::run(): Fin de boucle sur les sampleNum"<<endl;


//---------------------------------------------------------
} catch (PException & exc) {
  cout<<"Toi2toi_Addsp: Catched Exception "<<(string)typeid(exc).name()
      <<"\n .... Msg= "<<exc.Msg()<<endl;
}

return;      
}

//--------------------------------------------------------------------
void Toi2toi_Addsp::Fill_Info_scr(void)
{
  if(nb_src<=0) return;
  for (int i=0; i<nb_src ; i++){
    Info_src srcloc;
    srcloc.glon = 80.+i*10.;
    srcloc.glat = 0.;
    srcloc.amp  = 1.;
    srcloc.tau1 = 0.5;
    srcloc.tau2 = 0.5;
    src.push_back(srcloc);
  }
}
