// This may look like C code, but it is really -*- C++ -*-

// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: correl.h,v 1.1 2002-03-23 23:05:21 aubourg Exp $

#ifndef CORREL_H
#define CORREL_H

#include "config.h"

#ifndef NO_SOPHYA
#include "machdefs.h"
using namespace SOPHYA;
#endif


class CorrelEstimator {
public:
  CorrelEstimator(int n, int wsize); // n = longueur calcul autocorr, wsize = nsamples pour calcul
  ~CorrelEstimator();

  void push(int_4 t, r_8 x, r_8 y);
  void push(int_4 t, r_8 x); // auto-correlation

  r_8      correl(int k);    // correlation r_k
  int_4    ns4correl(int k); // n. samples used for correl

  void reset();
  
protected:
  int winsize;
  int ncor;

  int_4* mT;
  r_8*   mX;
  r_8*   mY;

  int_4  mNDat;
  int_4  mINext;
  int_4  mIFirst;

  r_8*   mC;
  int_4* mNC;

  void pop();
  void recompute();
};



#endif

