//////////////////////////
//  gph425_ring.cc         //
//////////////////////////

//*******************************************************

#include <iostream.h>
#include <stdlib.h>
//#include <strstream.h>
#include <string>
#include <stdio.h>
#include <vector>

#include "toi.h"
#include "toisegment.h"
//#include "toiseqbuff.h"
#include "nooppr.h"
#include "toiprocessor.h"
#include "fitstoirdr.h"
#include "fitstoiwtr.h"
#include "toimanager.h"
#include "datacards.h"
#include "fitsfile.h"
#include "sophyainit.h"
#include "toiseqbuff.h"
#include "timing.h"
#include "sambainit.h"
#include "fitsspherehealpix.h"
#include "ring33.h"
#include "Bolos2ring.h"
#include "PSB2ring.h"

#include <stdexcept>

int main(int argc, char* argv[])
{
  cout << "Starting Simple Ring Making ..." << endl;

  try {
    
    SophyaInit();
    InitTim();
    
    char str[80];

  TOIManager* mgr = TOIManager::getManager();
  int wsize = 512; /// Segment size for TOISegmented

  /// One command line argument: the filename of the datacard.
  if( argc < 2 )
    {
      cout << "Need a parameter file!! " << endl;
      exit(-1);
    }
  DataCards param(argv[1]);

  
  int_8 PSB = param.IParam("METHOD_PSB_diff");
  int_8 COMBI = param.IParam("METHOD_BOLOS_combi");  

  if ((PSB + COMBI <= 0) ||  (PSB + COMBI >= 2))
  {
    cout << "METHOD should be PSB_DIFF or BOLOS_COMBI" << endl;
    exit(-1);
  }
  
  cout << endl <<    "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" << endl;
  if(PSB==1) cout << "!!!!!!!!!!!!!! METHOD PSB_DIFF !!!!!!!!!!!!!!!!!" << endl;
  else cout <<       "!!!!!!!!!!!!!! METHOD BOLOS_combi !!!!!!!!!!!!!!" << endl;
  cout <<            "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" << endl << endl;
  
  int_4 Bolos_OK[4];
  int nbbolos_ok=0;
  
  if (PSB==0) {
    for(int i=0; i<4; i++) {
      sprintf(str,"BOLOS_OK_%d",i);
      Bolos_OK[i] = param.IParam(str);
      if (Bolos_OK[i] >=1 ) nbbolos_ok ++;
    }
    if (nbbolos_ok <3) {
      cout << "At least 3 Bolos must be used : " << Bolos_OK [0] << " "
	   << Bolos_OK[1] << " "<< Bolos_OK[2] << " "<< Bolos_OK[3] << " "<< endl;
      exit(-1);
    } else 
      cout << nbbolos_ok << " Bolos OK : " << Bolos_OK[0] << " "
	   << Bolos_OK[1] << " "<< Bolos_OK[2] << " "<< Bolos_OK[3] << " "<< endl;

  } else Bolos_OK[0]=Bolos_OK[1]=Bolos_OK[2]=Bolos_OK[3]=1;
  

  /// Nside : parameter for HEALPix ring
  int_4 Nside = param.IParam("Nside", 0, 128);

  /// The rings to create (Q,U and weight ring)
  SphereHEALPix<r_8>* ringQ = new SphereHEALPix<r_8>(Nside);
  SphereHEALPix<r_8>* ringU = new SphereHEALPix<r_8>(Nside);
  SphereHEALPix<r_8>* ringQW = new SphereHEALPix<r_8>(Nside);
  SphereHEALPix<r_8>* ringUW = new SphereHEALPix<r_8>(Nside);

  int_8 snb = param.IParam("SN_Start", 0);
  int_8 sne = param.IParam("SN_End", 0);

  /// Define start and end sample number to treat
  mgr->setRequestedSample(snb,sne);
  cout << "SampleNumbers from " << snb << " to " << sne << endl;

  vector<string> file_pointing(2);
  vector<string> theta_pointing(2);
  vector<string> phi_pointing(2);
  vector<string> file_bolo(4);
  vector<string> name_bolo(4);
  vector<r_8> table_angle(4);
  string toiqfile = param.SParam("FILE_TOI_Q",0,"toiQ.fits");
  string toiufile = param.SParam("FILE_TOI_U",0,"toiU.fits");
  string ringqfile = param.SParam("FILE_RING_Q",0,"ringQ.fits");
  string ringufile = param.SParam("FILE_RING_U",0,"ringU.fits");
  string ringqwfile = param.SParam("FILE_RING_WQ",0,"ringQW.fits");
  string ringuwfile = param.SParam("FILE_RING_WU",0,"ringUW.fits");
  if (PSB == 1) cout << "Output toi files " << toiqfile << " " << toiufile <<endl;
  cout << "Output ring files " << ringqfile << " " << ringufile <<endl;
  cout << "Output weights files " << ringqwfile << " " << ringuwfile <<endl;
  
  
  int i,j;
  for(i=0; i<2; i++ ) {
    sprintf(str,"FILE_POINT_%d",i);
    file_pointing[i] = param.SParam(str, 0);
    cout << "Pointing file " << i << ": " << file_pointing[i] << endl;
    
    sprintf(str,"NAME_POINT_%d_theta",i);
    theta_pointing[i] = param.SParam(str, 0);
    cout << "Pointing theta " << i << ": " << theta_pointing[i] << endl;
    
    sprintf(str,"NAME_POINT_%d_phi",i);
    phi_pointing[i] = param.SParam(str, 0);
    cout << "Pointing phi " << i << ": " << phi_pointing[i] << endl;

    for(j=0; j<2; j++ ) if (Bolos_OK[2*i+j]) {
    
      sprintf(str,"FILE_PSB%d_BOLO%d",i,j);
      file_bolo[i*2+j] = param.SParam(str, 0);
      cout << "bolo file " << i*2+j << ": " << file_bolo[i*2+j] << endl;
      
      sprintf(str,"NAME_PSB%d_BOLO%d",i,j);
      name_bolo[i*2+j] = param.SParam(str, 0);
      cout << "bolo name " << i*2+j << ": " << name_bolo[i*2+j] << endl;
      
      sprintf(str,"ANGLE_PSB%d_BOLO%d",i,j);
      table_angle[i*2+j] = param.DParam(str, 0);
      cout << "Angle " << i*2+j << ": " << table_angle[i*2+j] << endl;
    }
  }

  PSB2ring psb2ring(ringQ, ringU, ringQW, ringUW, table_angle, wsize);
  Bolos2ring bolos2ring(ringQ, ringU, ringQW, ringUW, table_angle, Bolos_OK, wsize);  

  //  1- pointage
  vector<FITSTOIReader*> pt(2);
  for(i=0; i<2; i++) 
    {
      pt[i] = new FITSTOIReader(file_pointing[i]);
      pt[i]->setImplicitSN(long(0));
      cout << "Opening pointing file " << file_pointing[i] << endl;
    }
  //  2- les Bolos
  vector<FITSTOIReader*> bolo(4);
  for(i=0; i<4; i++) if (Bolos_OK[i])
    {
      bolo[i] = new FITSTOIReader(file_bolo[i]);
      bolo[i]->setImplicitSN(long(0));
      cout << "Opening bolometer signal file " << file_bolo[i] << endl;
    }

  // Creation des tubes:
  //   1- du pointage vers Bolos2ringQU
  // chaque fichier de pointage envoie 2 donnees au processor
  vector<TOI*> toi_pt_theta(2);
  vector<TOI*> toi_pt_phi(2);
  for(i=0; i<2; i++)
    {
      cout << "Creation des pipes pour Pointage " << i << endl;

      sprintf(str,"toi_theta_%d",i);
      toi_pt_theta[i] = new TOISegmented(str,wsize);
      
      sprintf(str,"toi_phi_%d",i);
      toi_pt_phi[i] = new TOISegmented(str,wsize);

      pt[i]->addOutput(theta_pointing[i], toi_pt_theta[i]);
      pt[i]->addOutput(phi_pointing[i], toi_pt_phi[i]);

      sprintf(str,"theta_pointing%d",i);
      if (PSB == 1) psb2ring.addInput(str, toi_pt_theta[i]);
      else bolos2ring.addInput(str, toi_pt_theta[i]);
      sprintf(str,"phi_pointing%d",i);
      if (PSB == 1) psb2ring.addInput(str, toi_pt_phi[i]);
      else bolos2ring.addInput(str, toi_pt_phi[i]);
    }
  //   2- les Bolos 
  vector<TOI*> toi_bolo(4);
  for(i=0; i<4; i++) {

    sprintf(str,"toi_%d",i);

    if (Bolos_OK[i]) {
      toi_bolo[i] = new TOISegmented(str,wsize);   // creation des tuyaux
      bolo[i]->addOutput(name_bolo[i], toi_bolo[i]);    // assemblage sortie de Bolos

    } else {
      NoOpProcessor noop;
      noop.addOutput(name_bolo[i],toi_bolo[i] );
    }

    sprintf(str,"Bolo%d",i);
    if (PSB == 1) psb2ring.addInput(str, toi_bolo[i]); // assemblage entree de Bolos2ringQU 
    else bolos2ring.addInput(str, toi_bolo[i]);
  }

  // Maintenant, le traitement est termine, et on doit avoir recupere
  // les cartes de Q et U dans ringQ et ringU.
  // Il n'y a plus qu'a ecrire ces cartes sur le disque:

  // TOI
  FITSTOIWriter wtoiU(toiufile),wtoiQ(toiqfile);
  wtoiU.setImplicitSN();
  wtoiQ.setImplicitSN();
  cout << "fits toi writer created" << endl;

  TOISegmented * toioutQ = new TOISegmented("toi_outQ",wsize);
  TOISegmented * toioutU = new TOISegmented("toi_outU",wsize);
  if (PSB == 1) {
    psb2ring.addOutput("out_toiQ",toioutQ);
    psb2ring.addOutput("out_toiU",toioutU);
    wtoiQ.addInput("power",toioutQ);
    wtoiU.addInput("power",toioutU);
    cout << "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" << endl;
    
  }    


 
  // L'assemblage est termine : il reste a lancer les Processors
  cout << "Starting all processors..." << endl;
  
  for(i=0; i<2; i++) pt[i]->start();
  for(i=0; i<4; i++) bolo[i]->start();
  if (PSB == 1) {
    psb2ring.start();
    wtoiU.start(); 
    wtoiQ.start(); 
  }
  else bolos2ring.start(); 

  cout << "Joining ..." << endl;
  mgr->joinAll();
  PrtTim("End threads");

  
  // Write rings in FITS files
  FitsOutFile qfits(ringqfile,FitsFile::clear);
  cout<<"gph524_ring: Creating sphere fits file "<<ringqfile<<endl;
  qfits << *ringQ;
  FitsOutFile ufits(ringufile,FitsFile::clear);
  cout<<"gph524_ring: Creating sphere fits file "<<ringufile<<endl;
  ufits << *ringU;
  
  FitsOutFile qwfits(ringqwfile,FitsFile::clear);
  cout<<"gph524_ring: Creating sphere fits file "<<ringqwfile<<endl;
  qwfits << *ringQW;
  FitsOutFile uwfits(ringuwfile,FitsFile::clear);
  cout<<"gph524_ring: Creating sphere fits file "<<ringuwfile<<endl;
  uwfits << *ringUW;

 // Nettoyage
 cout << "gph524_ring: cleanup " << endl;
 delete ringQ; delete ringU;
 delete ringQW; delete ringUW;
 
  return(0);
  }
  catch(PThrowable & exc )
    {
      cerr << " Catched Exception " << (string)typeid(exc).name() 
	   << " - Msg= " << exc.Msg() << endl;
    }
  catch(...)
    {
      cerr << " Catched another exception..." << endl ;
    }

}




