#include "toi.h"
#include "toiseqbuff.h"
#include "toiprocessor.h"
#include "fitstoirdr.h"
#include "fitstoiwtr.h"
#include "toisqfilter.h"
#include "toiregwindow.h"
#include "toimanager.h"

int main(int argc, char** argv) {
  cout << "tstflag starting" << endl;
  TOIManager* mgr = TOIManager::getManager();
  mgr->setRequestedSample(104001000,104001500);

  FITSTOIReader r1(argv[1]);
  FITSTOIWriter w(argv[2]);

  
  TOI* toi1 = new TOISeqBuffered();
  //TOI* toi1 = new TOIRegularWindow();
  
  r1.addOutput("boloMuV_8", toi1); 

  
  w.addInput("143K01", toi1, true);
  w.addInput("143K0X", toi1, false);
  w.addInput("143K0Y", toi1, true);
  w.addInput("143K0Z", toi1, false);
  
  
  cout << "starting" << endl;

  r1.start();
  w.start();

  cout << "joining" << endl;
  mgr->joinAll();
  return(0);
}
