#include <unistd.h>
#include "toi.h"
#include "toiprocessor.h"
#include "fitstoirdr.h"
#include "fitstoiwtr.h"
#include "toimanager.h"
#include "toisegment.h"
#include "sophyainit.h"
#include "ktoibad.h"
#include "smoothtoi.h"
#include <stdexcept>

void usage(void);
void usage(void) {
 cout<<"tstktoibad [-h] [options] fits_in fits_out"
 <<" -s sdeb,sfin"
 <<" -b label_bolomuv"
 <<" -d vmin,vmax"
 <<" -g lg,lm,nsg,bupd"
 <<" -a lmaround"
 <<" -S lsmooth,sdeg"
 <<" -p lp,sn1,sn2"
 <<endl;
}

int main(int narg, char** arg)
{
 int_4 sdeb=0,sfin=-1;
 int_4 lp=1,sn1=-1,sn2=-1;
 uint_4 lg=3,lm=15,bupd=1000,lmaround=10;
 uint_4 lsmooth=1024,sdeg=2;
 r_8 nsg=5.;
 r_8 vmin=1.,vmax=-1.;
 char *label_bolomuv = "boloMuV";
  int c;
 while((c = getopt(narg,arg,"hs:g:d:b:a:S:p:")) != -1) {
  switch (c) {
  case 's' :
   sscanf(optarg,"%d,%d",&sdeb,&sfin);
   break;
  case 'd' :
   sscanf(optarg,"%lf,%lf",&vmin,&vmax);
   break;
  case 'g' :
   sscanf(optarg,"%d,%d,%lf,%d",&lg,&lm,&nsg,&bupd);
   break;
  case 'a' :
   sscanf(optarg,"%d",&lmaround);
   break;
  case 'S' :
   sscanf(optarg,"%d,%d",&lsmooth,&sdeg);
   break;
  case 'b' :
    label_bolomuv = optarg;
    break;
  case 'p' :
   sscanf(optarg,"%d,%d,%d",&lp,&sn1,&sn2);
   break;
  case 'h' :
  default:
   usage(); exit(1);
  }
 }
 if(optind+1>=narg) {usage(); exit(2);}
 char * fitsin  = arg[optind];
 char * fitsout = arg[optind+1];

 SophyaInit();
 TOIManager* mgr = TOIManager::getManager();
 if(sfin>=sdeb) mgr->setRequestedSample(sdeb,sfin);
 cout<<"Resquested sampleNum: "<<sdeb<<" , "<<sfin<<endl;


 //--------------------------------------------------------------------
 try {
 //--------------------------------------------------------------------

 ////// Lecteurs / ecriveurs FITS
 // FITS reader
 FITSTOIReader rfits(fitsin);
 cout<<"Lecteur: created"<<endl;

 // FITS writer
 FITSTOIWriter wfits(fitsout);
 cout<<"Ecriveur: created"<<endl;

 ////// TOI processeurs
 FlagOutOfRange flgout(vmin,vmax);
 flgout.Print();

 FlagGlitch deglitch(lg,lm,nsg);
 deglitch.SetBuffUpd(bupd);
 deglitch.SetDebug(lp,sn1,sn2);
 deglitch.Print();

 FlagAroundFlag flgaround(lm);
 //flgaround.SetLimits(vmin,vmax);
 flgaround.Print();

 DataSmooth dsmooth(lsmooth,sdeg);
 dsmooth.Print();

 ////// Creation des tuyaux et des connections associees
 int taille = 8192;

 // tuyau bolo pour entree processeur FlagOutOfRange
 TOISegmented * toi0 = new TOISegmented("tuyau_bolo_0",taille);
 rfits.addOutput(label_bolomuv,toi0);
 flgout.addInput("DataIn",toi0);

 // tuyau bolo pour entree processeur FlagGlitch
 TOISegmented * toi1 = new TOISegmented("tuyau_bolo_1",taille);
 flgout.addOutput("DataOut",toi1);
 deglitch.addInput("DataIn",toi1);

 // tuyau bolo pour entree processeur FlagAround
 TOISegmented * toi2 = new TOISegmented("tuyau_bolo_2",taille);
 deglitch.addOutput("DataOut",toi2);
 flgaround.addInput("DataIn",toi2);

 // tuyau bolo pour smooth DataSmooth et fits writer
 TOISegmented * toi3 = new TOISegmented("tuyau_bolo_3",taille);
 flgaround.addOutput("DataOut",toi3);
 dsmooth.addInput("DataIn",toi3);
 wfits.addInput(label_bolomuv,toi3,true);

 // tuyau bolo pour entree fits writer
 TOISegmented * toi31 = new TOISegmented("tuyau_bolo_31",taille);
 dsmooth.addOutput("DataSmooth",toi31);
 wfits.addInput("smbolo",toi31,true);

 // Print de status avant lancement des taches:
 cout<<"----- FITSReaderTOI::PrintStatus() 1 : -----"<<endl;
 rfits.PrintStatus(cout);
 cout<<"----- FITSWriterTOI::PrintStatus() : -----"<<endl;
 wfits.PrintStatus(cout);  
 cout<<"----- TOISegmented::PrintStatus() : -----"<<endl;
 toi0->PrintStatus(cout);  
 toi1->PrintStatus(cout);  
 toi2->PrintStatus(cout);  
 toi3->PrintStatus(cout);  
 toi31->PrintStatus(cout);  
 cout<<"-----FlagOutOfRange ::PrintStatus() : -----"<<endl;
 flgout.PrintStatus(cout);  
 cout<<"-----FlagGlitch ::PrintStatus() : -----"<<endl;
 deglitch.PrintStatus(cout);  
 cout<<"-----FlagAround ::PrintStatus() : -----"<<endl;
 flgaround.PrintStatus(cout);  
 cout<<"-----DataSmooth ::PrintStatus() : -----"<<endl;
 dsmooth.PrintStatus(cout);  

 // Lancement des taches

 rfits.start();
 wfits.start();
 flgout.start();  
 deglitch.start();
 flgaround.start();  
 dsmooth.start();  

 // Gestion de la re-connection des threads
 mgr->joinAll();
 cout<<"End threads"<<endl;

 //--------------------------------------------------------------------
 // Que fait on avec les exceptions qui ont ete lancees ?
 } catch (PThrowable & exc) {    // Sophya exceptions
  cout<<"\ntstktoibad: Catched Exception \n"<<(string)typeid(exc).name() 
      <<" - Msg= "<<exc.Msg()<<endl;
 } catch (const std::exception & sex) {    // Standard exceptions
  cout<<"\ntstktoibad: Catched std::exception \n" 
      <<(string)typeid(sex).name()<<endl; 
 } catch (...) {    // Other exceptions
  cout<<"\ntstktoibad: some other exception was caught ! "<<endl;
 }
 //--------------------------------------------------------------------

 return(0);
}
