// This may look like C code, but it is really -*- C++ -*-

// ArchTOIPipe           (C)     CEA/DAPNIA/SPP IN2P3/LAL
//                               Eric Aubourg
//                               Christophe Magneville
//                               Reza Ansari
// $Id: toi2ring.h,v 1.1 2003-01-29 15:24:42 cecile Exp $

#ifndef TOI2RING_H
#define TOI2RING_H

#include "toiprocessor.h"
#include "spherehealpix.h"
#include "flagtoidef.h"
#include "xastropack.h"

//-- Un generateur de RING a partir d'une sphere et de 2 TOIs coordin1,coordin2
// Lecture de 2 TOI coord1,coord2 et d'une Sphere Healpix
// Sortie de 3 RING coord1,coord2,boloMuV
//
// Structure generale :
//             Sphere ---- |
//                         |
//                     -----------
//   toi phase    ---> |         | ---> ring value
//                     |Toi2RING | ---> ring weight
//   toi value    ---> |         | 
//                     -----------

class Toi2RING : public TOIProcessor {
public:
                 Toi2RING(long n);
  virtual	~Toi2RING();

  inline void setNSamples( long n=1024)
              {Nsamples = n;}

  virtual void	init(void);
  virtual void	run(void);



  // Print
  void Print(::ostream & os);
  inline long 	ProcessedSampleCount() const { return totnscount; }
  inline long	ProcessedRingCount() const { return nRings; }

protected:
  long Nsamples;
  long totnscount;
  long nRings;
  
};

#endif
